// кнопка информация о точке на карте
function behaviorInfo(map) {
    function getInfo(e) {
        var position = e.get('coords');
        ymaps.geocode(position, { results: 1 }).then(function (res) {
            var firstGeoObject = res.geoObjects.get(0);

            map.balloon.open(position, firstGeoObject.properties.get('balloonContentBody'));
        });
    }

    var infoCursor,
        infoButton = new ymaps.control.Button({ data: { content: 'инфо' } });

    infoButton.events.add('select', function() {
        infoCursor = map.cursors.push('help');
        map.events.add('click', getInfo);
    });
    infoButton.events.add('deselect', function() {
        infoCursor && infoCursor.remove();
        map.events.remove('click', getInfo);
    });

    return infoButton;
}
