include('settings.js');

function RedStation(s) {
    var self,
        handleWwwStationsOnRedraw,
        styles = {
//            "twirl#lightblueIcon", "twirl#whiteIcon", "twirl#greenIcon", "twirl#redIcon",
//            "twirl#yellowIcon", "twirl#darkblueIcon", "twirl#nightIcon", "twirl#greyIcon",
//            "twirl#blueIcon", "twirl#orangeIcon", "twirl#darkorangeIcon", "twirl#pinkIcon", "twirl#violetIcon"
            normal : { preset: 'islands#greenIcon' },
            red : { preset: 'islands#redIcon' },
            yellow : { preset: 'islands#yellowIcon' }
        },
        listItemStyles = {
            normal : function($tr) { $tr.css('background-color', ''); },
            yellow : function($tr) { $tr.css('background-color', '#ed6'); }
        };


    self = {

        setIconStyleProperties : function(styleName) {
            var style = styles[styleName];
            if(!self.pm || !style) { return; }

            $.each(style, function(k, v) {
                self.pm.options.set(k, v);
            });
        },

        setListItemStyleProperties : function(styleName) {
            var applyStyle = listItemStyles[styleName] || listItemStyles['normal'];
            if(!self.$tr) { return; }
            applyStyle(self.$tr);
        },

        setStyle : function(styleName) {
            self.setListItemStyleProperties(styleName);
            if(styleName == 'normal') {
                setTimeout(function() {
                    self.setIconStyleProperties(styleName);
                }, 330);
            } else {
                self.setIconStyleProperties(styleName);
            }
        },

        pmCreate : function() {
            var options,
                wwwStation = wwwStations.getById(self.www_station.id),
                lon = wwwStation && wwwStation.lon || null,
                lat = wwwStation && wwwStation.lat || null;

            if(!lon || !lat) {
                lon = self.lon;
                lat = self.lat;
            }

            if(!self.pm && lon && lat) {
                options = {
                    draggable: false,
                    hideIconOnBallon: false
                };

                self.pm = new ymaps.Placemark(
                    [lon, lat], {
                        iconContent: self.number,
                        hintContent: self.www_station.id + '<br>' + self.www_station.title,
                        balloonContent: '<div><table>' +
                            '<tr><td>' + self.www_station.id + '</td></tr>' +
                            '<tr><td>' + self.www_station.title + '</td></tr>' +
                            '<tr><td><a href="/admin/www/station/' + self.www_station.id + '/" target="_blank">' + gettext('Редактировать в геоадмине') + '</a></td></tr>' +
                            '<tr><td class="ac"><input type="button" class="b_delete_station_from_route" data-id="' + self.id + '" value="' + gettext('Отвязать') + '" /></td></tr>' +
                            '<tr><td>' + wwwStations.majorityChanger(self.www_station.id, self.www_station.majority_id) + '</td></tr>' +
                            '</table></div>'
                    },
                    options
                );

                self.setIconStyleProperties('normal');

                self.pm.red_station_id = self.id;

                self.pm.events.add('mouseenter', function() {
                    redStations.each(function(j, s) {s.setStyle('normal')}); //  Сбросим залипающие желтые стили
                    self.setStyle('yellow');
                });

                self.pm.events.add('mouseleave', function() {
                    self.setStyle('normal');
                });

                // map видна отсюда (RedStation подключена в function Route подключенной в red.js)
                map.geoObjects.add(self.pm);
            }
        },

        pmUpdate : function() {
            if(self.pm) {
                self.pmDelete();
            }
            self.pmCreate();
        },

        pmDelete : function() {
            if(self.pm) {
                map.geoObjects.remove(self.pm);
                self.pm = null;
            }
        },

        update : function(s) {

            if(typeof(s) != 'undefined' && !$.isEmptyObject(s)) {
                $.each(['id', 'www_station', 'number', 'order', 'title', 'arrival', 'departure', 'lon', 'lat',
                        'is_fuzzy', 'is_searchable_to', 'is_searchable_from', 'in_station_schedule'],
                    function(j, k) {
                        if(typeof(s[k]) != 'undefined') {
                            self[k] = s[k];

                            if(s[k] === null) {
                                self[k] = '';
                            }
                        }
                    }
                );
            }

            if(!self.number) {
                self.number = '';
            }

            self.pmUpdate();

        },

        setNumber : function(number) {
            self.number = number;

            if(self.pm) {
                self.pm.properties.set('iconContent', self.number);
            }
            if(self.$tr) {
                $('TD:first', self.$tr).text(self.number);
            }
        },

        recreate : function() {
            self.pmDelete();
            self.pmUpdate();
            if(self.$tr) {
                $('.i-title', self.$tr).text(self.title);
            }
        },

        get$tr : function(){
            var fuzzy_states = ['yes', 'no', 'inherit'];

            function next_fuzzy_state(state) {
                return fuzzy_states[($.inArray(state, fuzzy_states) + 1) % fuzzy_states.length];
            };

            function fuzzy_flag_html(name, state, hint) {
                var attr = '',
                    text = '';

                if(state == 'yes') attr = ' checked="checked" ';
                else if(state != 'no') attr =  ' disabled ';

                if(state == 'yes') text = 'да';
                else if(state == 'no') text =  'нет';

                return '<div class="fuzzyflag" style="width: 25px; text-align: center; padding-bottom: 2px; height:12px; border: 1px dotted grey; margin-right: 4px;"' +
                        ' data-name="' + name + '" ' +
                        ' data-state="' + state + '"' +
                        ' title="' + hint + '" >' +
                        '' + text +
                        '</div>';
            };

            function set_fuzzy_flag_state($flag, state) {
                $flag.attr('data-state', state);
                $flag.text({'yes': 'да', 'no': 'нет', 'inherit': ''}[state]);
            };

            function get_fuzzy_flag_state($flag) {
                return $flag.attr('data-state');
            };

            function get_fuzzy_flag_name($flag) {
                return $flag.attr('data-name');
            };

            if(!self.$tr) {
                var fuzzy_flag = {
                    'is_fuzzy': gettext("Нечеткие данные"),
                    'is_searchable_from': gettext("искать от станции"),
                    'is_searchable_to': gettext("искать до станции"),
                    'in_station_schedule': gettext("в расписании по станции")
                };

                self.$tr = $('<tr id="' + self.id + '">' +
                                '<td>' + self.number + '</td>' +
                                '<td class="i-title">' + self.www_station.title + '</td>' +
                                '<td><input type="text" name="arrival" value="' + self.arrival + '" /></td>' +
                                '<td><input type="text" name="departure" value="' + self.departure + '" /></td>' +
                                $.map(fuzzy_flag, function(hint, name) {
                                    return '<td>' + fuzzy_flag_html(name, self[name], hint) + '</td>';
                                }).join('') +
                                '<td><i class="b-remove">&nbsp;</i></td>' +
                            '</tr>');

                $('.fuzzyflag', self.$tr).each(function(what, val) {
                    var $flag = $(this),
                        flag_name = get_fuzzy_flag_name($flag);

                    $flag.click(function() {
                        var new_state = next_fuzzy_state(get_fuzzy_flag_state($flag));

                        if(self.number == 1 && flag_name == 'is_fuzzy') {
                            statusBar.say(gettext('Время отправления с первой станции может быть лишь чётким'),
                                {wait: STATUS_MESSAGE_SHOW_TIME});
                            return;
                        }

                        set_fuzzy_flag_state($flag, new_state);
                        self[flag_name] = new_state;
                        route.changed();
                    });
                });

                self.$tr.hover(
                    function() {
                        self.setStyle('yellow');
                    },
                    function() {
                        self.setStyle('normal');
                    });

                $('[name=arrival]', self.$tr).change(function() {
                    self.arrival = $(this).val();
                    route.changed();
                });

                $('[name=departure]', self.$tr).change(function() {
                    self.departure = $(this).val();
                    route.changed();
                });

                $('TD.i-title', self.$tr).click(function() {
                    var wwwStation = wwwStations.getById(self.www_station.id),
                        lon = wwwStation && wwwStation.lon,
                        lat = wwwStation && wwwStation.lat;

                    if(!lon || !lat) {
                        lon = self.lon;
                        lat = self.lat;
                    }

                    if(lon && lat) {
                        map.setCenter([lon, lat], 11, { duration: 330 });
                    }
                });

                $('.b-remove', self.$tr).click(function() {
                    self.deleteFromRoute();
                });

                self.$tr.bind('contextmenu', function(e) {
                    e.preventDefault();

                    var offset = self.$tr.offset();
                    offset.top += self.$tr.height();

                    contextMenu.setStation(self);
                    contextMenu.show(offset);
                });

            }

            return self.$tr;
        },

        deleteFromRoute : function() {
            if(confirm(gettext('Удалить станцию') + ' «' + self.www_station.title + '» ' + gettext('из мета-рейса') + '?')) {
                $.post('/admin/redmap/mrstation/delete/', { 'station_id': self.id },
                    function (data) {
                        if(data.status == 'ok') {
                            redStations.destructById(self.id);

                            if (data.route_check_error) {
                                statusBar.say(data.route_check_error, {wait: STATUS_MESSAGE_SHOW_TIME});
                            }
                        } else {
                            alert(gettext('Не можем удалить станцию мета-рейса'));
                        }
                    },
                    'json'
                ).error(function() {
                        alert(gettext('Не можем удалить станцию мета-рейса'));
                });
            }
        },

        destruct : function() {
            self.pmDelete();

            // Отвязать обработчик обновления метки
            wwwStations.unbind('redraw', handleWwwStationsOnRedraw);

            if(self.$tr) {
                self.$tr.remove();
                self.$tr = null;
            }
        },

        updateFromWwwStation : function(s) {
            var data = {};
            $.each(['lon', 'lat', 'title'], function(j, k) {
                data[k] = s[k];
            });
            data['www_station'] = {id:s.id, title:s.title};
            self.update(data);
        }
    };

    // Привязать обработчик обновления метки
    handleWwwStationsOnRedraw = function () {
        self.pmUpdate();
    };
    wwwStations.bind('redraw', handleWwwStationsOnRedraw);

    wwwStations.bind('moved', function(e, data) {
        if(data.station.id == self.www_station.id) {
            self.update({lon: data.station.lon, lat: data.station.lat});
        }
    });

    wwwStations.bind('prejoined', function(e, data) {
        if(data.src.id == self.www_station.id) {
            self.updateFromWwwStation(data.dst);
            self.recreate();
        }
    });

    wwwStations.bind('majorityChanged', function(e, data) {
        if(data.www_station.id == self.www_station.id) {
            self.www_station.majority_id = data.www_station.majority_id;
            self.pmDelete();
            self.pmUpdate();
        }
    });

    self.update(s);

    return self;
}
