


$(function () {
    var locationEl = $('.ymaps-point'),
        zoomButton = $('<input type="button" value="' + gettext("Сохранить масштаб") + '" />'),
        mapEl = $('<div style="height: 400px; width: 100%"></div>'),
        lngEl = $('input[name=longitude]'),
        latEl = $('input[name=latitude]'),
        zoomEl = $('input[name=map_zoom]');

    zoomButton.appendTo(locationEl).wrap('<div class="form-row" />').parent().prepend(mapEl);

    var map = new YMaps.Map(mapEl[0]);

    zoomButton.click(function () {
        zoomEl.val(map.getZoom());
    });

    YMaps.MapType.PMAP.setName(gettext('Н-схема'));
    YMaps.MapType.PHYBRID.setName(gettext('Н-гибрид'));
    map.addControl(new YMaps.TypeControl([YMaps.MapType.MAP,
                                          YMaps.MapType.SATELLITE,
                                          YMaps.MapType.HYBRID,
                                          YMaps.MapType.PMAP,
                                          YMaps.MapType.PHYBRID
                                         ]));

    map.addControl(new YMaps.Zoom);
    // map.enableScrollZoom();

    var placemark;

    function setPlaceMark(point) {
        if(!placemark) {
            placemark = new YMaps.Placemark(point, {draggable: true});
            map.addOverlay(placemark);

            YMaps.Events.observe(placemark, placemark.Events.Drag, function (mEvent) {
                var pt = mEvent.getGeoPoint();
                latEl.val(pt.getLat()) ;
                lngEl.val(pt.getLng());
            });
        } else {
            placemark.setGeoPoint(point);
        }
    }

    if(lngEl.val() && latEl.val()) {
        var point = new YMaps.GeoPoint(lngEl.val(), latEl.val());
        map.setCenter(point, zoomEl.val() || 10);
        setPlaceMark(point);
    } else {
        map.setCenter(new YMaps.GeoPoint(93, 60), 3);
        var region, settlement;

        try {
            region = $('.region strong').html();
        } catch (e) {};

        try {
            settlement = $('.settlement strong').html();
        } catch (e) {};

        var geocoder = new YMaps.Geocoder(settlement || region, {results: 1});

        YMaps.Events.observe(geocoder, geocoder.Events.Load, function () {
            if(this.length()) {
                map.setCenter(this.get(0).getGeoPoint(), settlement ? 10 : 8);
            }
        });
    }

    YMaps.Events.observe(map, map.Events.Click, function (map, mEvent) {
        var pt = mEvent.getGeoPoint();

        setPlaceMark(pt);
        latEl.val(pt.getLat());
        lngEl.val(pt.getLng());
    });
});
