# -*- coding: utf-8 -*-
# Generated by Django 1.9.12 on 2019-03-14 13:29
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.manager


class Migration(migrations.Migration):

    dependencies = [
        ('staticpages', '0002_partner_dohop_vendor'),
    ]

    operations = [
        migrations.CreateModel(
            name='ArticleBinding',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('page', models.ForeignKey(to='staticpages.StaticPage', verbose_name='страница',
                                           on_delete=models.deletion.CASCADE)),
                ('country', models.ForeignKey(to='www.Country', verbose_name='Страна',
                                              on_delete=models.deletion.CASCADE)),
                ('t_type', models.ForeignKey(to='www.TransportType', verbose_name='тип транспорта',
                                             blank=True, null=True,
                                             on_delete=models.deletion.CASCADE)),
                ('settlement', models.ForeignKey(to='www.Settlement', verbose_name='город',
                                                 blank=True, null=True,
                                                 on_delete=models.deletion.CASCADE)),
                ('priority', models.PositiveSmallIntegerField(default=0, verbose_name='приоритет показа статьи')),
            ],
            options={
                'ordering': ('priority',),
                'verbose_name': 'привязка страницы к виду транспорта и городу',
                'verbose_name_plural': 'страницы',
            },
        ),
        migrations.AlterModelManagers(
            name='partner',
            managers=[
                ('admin_manager', django.db.models.manager.Manager()),
            ],
        ),
        migrations.AlterModelManagers(
            name='staticpage',
            managers=[
                ('admin_manager', django.db.models.manager.Manager()),
            ],
        ),
        migrations.AlterIndexTogether(
            name='articlebinding',
            index_together=set([('country', 't_type', 'settlement')]),
        ),
    ]
