# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import common.utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0001_initial'),
        ('order', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='DynamicCache',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('eventdate', models.DateField(verbose_name='\u0414\u0430\u0442\u0430')),
                ('percent', models.PositiveSmallIntegerField(verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043f\u043e\u043f\u0430\u0434\u0430\u043d\u0438\u0439')),
                ('count', models.PositiveIntegerField(verbose_name='\u041a\u043e\u043b-\u0432\u043e')),
                ('month_year', models.CharField(max_length=7, verbose_name='\u041c\u0435\u0441\u044f\u0446 \u0438 \u0433\u043e\u0434')),
                ('national_version', models.CharField(max_length=2, verbose_name='\u041d\u0430\u0446. \u0432\u0435\u0440\u0441\u0438\u044f', choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr'), (b'com', b'com')])),
            ],
            options={
                'ordering': ['national_version', 'month_year', 'eventdate'],
            },
        ),
        migrations.CreateModel(
            name='FlexibleCache',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('eventdate', models.DateField(verbose_name='\u0414\u0430\u0442\u0430')),
                ('percent', models.PositiveSmallIntegerField(verbose_name='\u041f\u0440\u043e\u0446\u0435\u043d\u0442 \u043f\u043e\u043f\u0430\u0434\u0430\u043d\u0438\u0439')),
                ('count', models.PositiveIntegerField(verbose_name='\u041a\u043e\u043b-\u0432\u043e')),
                ('national_version', models.CharField(max_length=2, verbose_name='\u041d\u0430\u0446. \u0432\u0435\u0440\u0441\u0438\u044f', choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr'), (b'com', b'com')])),
            ],
            options={
                'ordering': ['national_version', 'eventdate', 'percent', 'count'],
            },
        ),
        migrations.CreateModel(
            name='ImportChart',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('when', models.DateTimeField(verbose_name='\u0412\u0440\u0435\u043c\u044f', db_index=True)),
                ('event', models.CharField(max_length=80, verbose_name='\u0421\u043e\u0431\u044b\u0442\u0438\u0435', db_index=True)),
                ('machine', common.utils.fields.TrimmedCharField(default=b'', max_length=40, verbose_name='\u041c\u0430\u0448\u0438\u043d\u0430 \u043a\u043b\u0430\u0441\u0442\u0435\u0440\u0430', blank=True)),
                ('value', models.FloatField(default=0, verbose_name='\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435')),
                ('partner', models.ForeignKey(to='order.Partner')),
            ],
        ),
        migrations.CreateModel(
            name='MinPriceStatus',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('eventdate', models.DateField(verbose_name='\u0414\u0430\u0442\u0430')),
                ('national_version', models.CharField(max_length=2, verbose_name='\u041d\u0430\u0446. \u0432\u0435\u0440\u0441\u0438\u044f', choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr'), (b'com', b'com')])),
                ('status', models.CharField(max_length=8, verbose_name='\u0421\u0442\u0430\u0442\u0443\u0441', choices=[(b'In range', b'In range'), (b'Lower', b'Lower'), (b'Greater', b'Greater')])),
                ('settlement_from', models.ForeignKey(related_name='+', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', to='www.Settlement')),
                ('settlement_to', models.ForeignKey(related_name='+', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', to='www.Settlement')),
            ],
            options={
                'ordering': ['national_version', 'eventdate', 'settlement_from', 'settlement_to'],
            },
        ),
        migrations.CreateModel(
            name='ServiceMetric',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('when', models.DateTimeField(verbose_name='\u0412\u0440\u0435\u043c\u044f', db_index=True)),
                ('period', models.CharField(max_length=5, verbose_name='\u043f\u0435\u0440\u0438\u043e\u0434', choices=[(b'hour', b'hour'), (b'day', b'day'), (b'month', b'month'), (b'year', b'year')])),
                ('service', models.CharField(max_length=6, verbose_name='\u0421\u0435\u0440\u0432\u0438\u0441', choices=[(b'ticket', b'ticket'), (b'rasp', b'rasp')])),
                ('group', models.CharField(max_length=20, verbose_name='\u0413\u0440\u0443\u043f\u043f\u0430')),
                ('event', models.CharField(max_length=20, verbose_name='\u0421\u043e\u0431\u044b\u0442\u0438\u0435')),
                ('value', models.FloatField(default=0, verbose_name='\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435')),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='servicemetric',
            unique_together=set([('when', 'period', 'group', 'event', 'service')]),
        ),
        migrations.AlterUniqueTogether(
            name='flexiblecache',
            unique_together=set([('national_version', 'eventdate', 'percent')]),
        ),
        migrations.AlterUniqueTogether(
            name='dynamiccache',
            unique_together=set([('national_version', 'month_year', 'eventdate')]),
        ),
        migrations.AlterUniqueTogether(
            name='minpricestatus',
            unique_together=set([('national_version', 'eventdate', 'settlement_from', 'settlement_to')]),
        ),
        migrations.AlterUniqueTogether(
            name='importchart',
            unique_together=set([('partner', 'when', 'event', 'machine')]),
        ),
    ]
