# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import common.utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Notice',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', common.utils.fields.TrimmedCharField(max_length=255, verbose_name='\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a')),
                ('text', common.utils.fields.TrimmedTextField(verbose_name='\u0422\u0435\u043a\u0441\u0442')),
                ('mobile_text', common.utils.fields.TrimmedTextField(null=True, verbose_name='\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442', blank=True)),
                ('type', models.CharField(default='other', max_length=100, verbose_name='\u0422\u0438\u043f', choices=[('cancel', '\u043e\u0442\u043c\u0435\u043d\u0430'), ('assign', '\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435'), ('change', '\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435'), ('other', '\u0434\u0440\u0443\u0433\u043e\u0435')])),
                ('start_date', models.DateField(verbose_name='\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430')),
                ('end_date', models.DateField(verbose_name='\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f')),
                ('directions', models.ManyToManyField(to='www.ExternalDirection')),
            ],
            options={
                'ordering': ('start_date', 'end_date'),
                'db_table': 'www_suburbanschedulechangenotice',
                'verbose_name': '\u041e\u0431\u044a\u044f\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u0435\u043a',
                'verbose_name_plural': '\u041e\u0431\u044a\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u043e\u0431 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f\u0445 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0439 \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u0435\u043a',
            },
        ),
        migrations.CreateModel(
            name='NoticeEmailTemplate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', common.utils.fields.TrimmedCharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('code', common.utils.fields.TrimmedCharField(default='draft', max_length=100, verbose_name='\u0422\u0438\u043f \u0448\u0430\u0431\u043b\u043e\u043d\u0430', choices=[('draft', '\u0427\u0435\u0440\u043d\u043e\u0432\u0438\u043a'), ('every_day', '\u041a\u0430\u0434\u0436\u043d\u044b\u0439 \u0434\u0435\u043d\u044c')])),
                ('days_ahead', models.IntegerField(default=0, verbose_name='\u0414\u043d\u0435\u0439 \u0432\u043f\u0435\u0440\u0435\u0434')),
                ('days_ago', models.IntegerField(default=0, verbose_name='\u0414\u043d\u0435\u0439 \u043d\u0430\u0437\u0430\u0434')),
                ('subject_template', common.utils.fields.TrimmedCharField(max_length=255, verbose_name='\u0428\u0430\u0431\u043b\u043e\u043d \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430')),
                ('template', common.utils.fields.TrimmedTextField(default='<!doctype html>\n<html>\n<head>\n<title>{{ subject }}</title>\n<style>\nli {\npadding: 10px 0;\n}\n</style>\n</head>\n<body>\n<h1>{{ subject }}</h1>\n{% if zones %}\n<ul>\n{% for zone in zones %}\n<li>\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043f\u043e \u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u043e\u0439 \u0437\u043e\u043d\u0435 {{zone.title}}</li>\n  <ul>\n    {% for notice in zone.notices %}\n    <li>C {{notice.start_date}} \u043f\u043e {{notice.end_date}}:<br> {{ notice.text }}</li>\n    {% endfor %}\n  </ul>\n{% endfor %}\n</ul>\n{% else %}\n<p>\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u043d\u0435\u0442</p>\n{% endif %}\n</body>\n</html>', verbose_name='\u0428\u0430\u0431\u043b\u043e\u043d')),
                ('content_type', common.utils.fields.TrimmedCharField(default='text/html; charset=utf-8', max_length=200, verbose_name='\u0422\u0438\u043f \u0448\u0430\u0431\u043b\u043e\u043d\u0430', choices=[('text/plain; charset=utf-8', '\u0422\u0435\u043a\u0441\u0442'), ('text/html; charset=utf-8', 'HTML')])),
            ],
            options={
                'verbose_name': '\u0428\u0430\u0431\u043b\u043e\u043d \u043f\u0438\u0441\u0435\u043c\u0430',
                'verbose_name_plural': '\u0428\u0430\u0431\u043b\u043e\u043d\u044b \u043f\u0438\u0441\u0435\u043c',
            },
        ),
        migrations.CreateModel(
            name='Recipient',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('email', models.EmailField(max_length=254)),
                ('comment', common.utils.fields.TrimmedCharField(max_length=200, verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439', blank=True)),
            ],
            options={
                'verbose_name': '\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c',
                'verbose_name_plural': '\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u0438',
            },
        ),
        migrations.AddField(
            model_name='noticeemailtemplate',
            name='recipients',
            field=models.ManyToManyField(to='suburban_change_notices.Recipient', verbose_name='\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u0438', blank=True),
        ),
        migrations.AddField(
            model_name='noticeemailtemplate',
            name='zones',
            field=models.ManyToManyField(to='www.SuburbanZone', verbose_name='\u041f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u044b\u0435 \u0417\u043e\u043d\u044b', blank=True),
        ),
    ]
