# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging
from traceback import format_exc

from django.core.mail.message import EmailMessage
from django.utils.encoding import smart_unicode

from travel.rasp.library.python.common23.date import environment
from suburban_change_notices import settings


log = logging.getLogger(__name__)


def send_email_by_template(notice_template, recipients=None, today=None):
    today = today or environment.today()
    subject = notice_template.get_subject(today)
    body = notice_template.get_email_body(today)
    content_type = notice_template.content_type

    recipients = recipients or notice_template.get_recipient_emails()

    fails = []

    for recipient in recipients:
        log.info('Пробуем отправить уведомлениe по шаблону %s %s "%s" на email %s',
                 notice_template.id, notice_template.code, notice_template.name, recipient)
        try:
            message = EmailMessage(subject, body, settings.FROM_EMAIL,
                                   [recipient])
            message.content_subtype = content_type.split('/')[1]
            message.send()

            log.info('Успешно отправили уведомлениe по шаблону %s %s "%s" на email %s',
                     notice_template.id, notice_template.code, notice_template.name, recipient)
        except Exception:
            error = format_exc()
            fails.append((recipient, smart_unicode(error)))
            log.exception('Ошибка отправки уведомления по шаблону %s %s "%s" на email %s',
                          notice_template.id, notice_template.code, notice_template.name, recipient)

    return fails
