# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations
from django.db.migrations.operations.special import SeparateDatabaseAndState

import common.utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('tariffs_admin', '0001_initial'),
    ]

    operations = [
        SeparateDatabaseAndState(state_operations=[
            migrations.DeleteModel(
                name='UFSDepthOfSales',
            ),
            migrations.DeleteModel(
                name='UFSDirectionDaysAhead',
            )
        ]),
        migrations.AlterField(
            model_name='tchdirection',
            name='iata_from',
            field=common.utils.fields.CodeCharField(max_length=10, verbose_name='IATA код отправления'),
        ),
        migrations.AlterField(
            model_name='tchdirection',
            name='iata_to',
            field=common.utils.fields.CodeCharField(max_length=10, verbose_name='IATA код прибытия'),
        ),
    ]
