# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations

from travel.rasp.admin.lib.migrations import drop_table_if_exists


def remove_old_fields_and_tables(apps, schema_editor):
    # https://st.yandex-team.ru/RASPADMIN-1299
    drop_table_if_exists(schema_editor, 'tariffs_ufsdepthofsales')
    drop_table_if_exists(schema_editor, 'tariffs_ufsdirectiondaysahead')


class Migration(migrations.Migration):

    dependencies = [
        ('tariffs_admin', '0002_delete_ufs_days_ahead'),
    ]

    operations = [
        migrations.RunPython(remove_old_fields_and_tables, migrations.RunPython.noop)
    ]
