PY2_LIBRARY()

OWNER(
    g:rasp-back
)

PEERDIR(
    contrib/python/freezegun
    contrib/python/httpretty
    contrib/python/parameterized
    contrib/python/PyHamcrest
    contrib/python/pytest
    contrib/python/six

    library/python/resource

    travel/rasp/admin
    travel/rasp/admin/tester
)

RESOURCE(
    lib/ref-image.svg lib/ref-image.svg
    lib/ref-image.png lib/ref-image.png
)

# data files
RESOURCE_FILES(PREFIX travel/rasp/admin/tests/
    # importinfo
    importinfo/data/test_blacklist/threads.xml
    importinfo/data/test_tsi_thread_station_flags/threads.xml

    # lib
    lib/data/encoding/test_detect_encoding_cp1251.txt
    lib/data/encoding/test_detect_encoding_utf8.txt
    lib/data/test_rar/test.rar
    lib/data/un7zip/arc_with_file.7z
    lib/data/un7zip/arch_with_file_and_folder.7z
    lib/data/un7zip/not_arch.7z
    lib/data/unzip/test_unpack_file.zip
    lib/data/unzip/test_unpack_with_subdirs.zip
    lib/data/xls/test_xls_parser.xls

    # scripts
    scripts/schedule/data/import_mta/schedule.xml
    scripts/schedule/data/import_mta/stops.xml
    scripts/schedule/bus/data/test_dyc/dyc.zip
)

# fixtures
RESOURCE_FILES(PREFIX travel/rasp/admin/tests/
    scripts/schedule/fixtures/test_import_mta.yaml

    importinfo/fixtures/default_supplier.yaml
    importinfo/fixtures/settlement.yaml
    importinfo/fixtures/test_blacklist.yaml
    importinfo/fixtures/test_tsi_thread_station_flags.yaml
)

PY_SRCS( NAMESPACE tests
    __init__.py
    conftest.py
    manage_local_settings.py
    utils.py
    importinfo/test_blacklist.py
    importinfo/test_triangle_mask_parser.py
    importinfo/test_tsi_thread_station_flags.py
)

SET(_SRCS
    admin/__init__.py
    admin/admin_tasks/__init__.py
    admin/admin_tasks/test_run_task.py
    admin/admin_tasks/test_task_log.py
    admin/middleware/test_idm_tvm.py
    admin/red/__init__.py
    admin/red/test_api.py
    admin/red/test_end_date_in_mask.py
    admin/red/test_import_red_metaroute.py
    admin/red/test_import_red_subtype.py
    admin/test_blue.py

    importinfo/__init__.py
    importinfo/test_tsi_group_package_filters.py
    importinfo/admin/__init__.py
    importinfo/admin/test_af_train_turnover_admin.py
    importinfo/admin/test_afdbchangesfile_admin.py
    importinfo/afdbchanges/__init__.py
    importinfo/afdbchanges/actions/__init__.py
    importinfo/afdbchanges/actions/test_www_settlement.py
    importinfo/afdbchanges/actions/test_www_station.py
    importinfo/afdbchanges/test_utils.py
    importinfo/models/__init__.py
    importinfo/models/test_importreport.py
    importinfo/models/test_original_thread_data_fast_delete.py
    importinfo/test_station_mapping.py
    importinfo/test_train_turnovers.py
    importinfo/two_stage_import/__init__.py
    importinfo/two_stage_import/test_admin.py

    lib/__init__.py
    lib/mask_builder/__init__.py
    lib/mask_builder/test_afmask_builder.py
    lib/mask_builder/test_standard_builders.py
    lib/mask_builder/test_ycal_builders.py
    lib/migrations/__init__.py
    lib/migrations/test_columns_manipulations.py
    lib/migrations/test_table_manipulations.py
    lib/test_encoding.py
    lib/test_exception.py
    lib/test_image.py
    lib/test_lock.py
    lib/test_logs.py
    lib/test_maintenance.py
    lib/test_metadata_conf.py
    lib/test_mysqlutils.py
    lib/test_processes.py
    lib/test_rar.py
    lib/test_redirect_email_backend.py
    lib/test_un7zip.py
    lib/test_unzip.py
    lib/test_xls.py

    order/__init__.py
    order/admin/__init__.py
    order/admin/test_partneradmin_save_model.py

    scripts/export/__init__.py
    scripts/export/test_export_bus_station_codes.py
    scripts/export/test_export_nearest_suburban.py
    scripts/export/test_export_suburban_cities.py
    scripts/export/test_gen_t_types_by_geoid_for_mobile_morda.py
    scripts/test_upload_to_s3.py

    scripts/schedule/__init__.py
    scripts/schedule/test_af_suburban_delays/__init__.py
    scripts/schedule/test_af_suburban_delays/test_af_suburban_delays.py
    scripts/schedule/test_afmasktext.py
    scripts/schedule/test_import_af.py
    scripts/schedule/test_import_mta.py
    scripts/schedule/test_route_compare.py
    scripts/schedule/test_route_loader.py

    scripts/schedule/af/__init__.py
    scripts/schedule/af/af_thread_parser/__init__.py
    scripts/schedule/af/af_thread_parser/test_gen_title.py
    scripts/schedule/af/af_thread_parser/test_get_t_subtype.py
    scripts/schedule/af/common/__init__.py
    scripts/schedule/af/common/test_changemode_insert.py
    scripts/schedule/af/common/test_utils.py
    scripts/schedule/af/suburban/__init__.py
    scripts/schedule/af/suburban/test_changemode_add.py
    scripts/schedule/af/suburban/test_changemode_cancel.py
    scripts/schedule/af/suburban/test_changemode_change.py
    scripts/schedule/af/suburban/test_changemode_change_daystr.py
    scripts/schedule/af/suburban/test_changemode_change_facilities.py
    scripts/schedule/af/suburban/test_changemode_change_schedule_plan.py
    scripts/schedule/af/suburban/test_changemode_change_weektemplate.py
    scripts/schedule/af/suburban/test_changemode_delete.py
    scripts/schedule/af/suburban/test_changemode_insert.py
    scripts/schedule/af/suburban/test_changemode_refill_calendar.py
    scripts/schedule/af/suburban/test_changemode_replace.py
    scripts/schedule/af/suburban/test_changemode_restore.py
    scripts/schedule/af/suburban/test_changemode_rewrite_facilities.py
    scripts/schedule/af/suburban/test_importing_flags.py
    scripts/schedule/af/suburban/test_possible_route_uids_generation.py
    scripts/schedule/af/suburban/test_utils.py
    scripts/schedule/af/utils.py

    scripts/schedule/bus/__init__.py
    scripts/schedule/bus/dyc/__init__.py
    scripts/schedule/bus/dyc/test_dyc.py
    scripts/schedule/bus/dyc/test_dyc_parser.py
    scripts/schedule/bus/test_buscomua_transportmodel_rename.py
    scripts/schedule/bus/test_import_mta.py
    scripts/schedule/bus/test_import_mta_reverse_times.py
    scripts/schedule/bus/test_tkvc_masks.py

    scripts/schedule/test_re_import_af_schedule.py

    scripts/schedule/tis_train/__init__.py
    scripts/schedule/tis_train/test_check_deluxe_trains.py
    scripts/schedule/tis_train/test_import_tis.py

    scripts/schedule/utils/__init__.py
    scripts/schedule/utils/test_code_sharing.py
    scripts/schedule/utils/test_fill_middle_times.py
    scripts/schedule/utils/test_plane.py

    scripts/single/__init__.py
    scripts/single/test_point_slugs_generator.py
    scripts/single/test_regenerate_import_uids.py

    scripts/sitemap/__init__.py
    scripts/sitemap/sitemaps/__init__.py
    scripts/sitemap/sitemaps/test_city_transport_sitemap.py
    scripts/sitemap/sitemaps/test_lastochka_sitemap.py
    scripts/sitemap/sitemaps/test_search_all_days_sitemap.py
    scripts/sitemap/sitemaps/test_station_schedule_sitemap.py
    scripts/sitemap/sitemaps/test_threads_sitemap.py
    scripts/sitemap/sitemaps/test_transport_sitemap.py

    scripts/test_build_namesearch_index.py
    scripts/test_build_pseudo_back_routes.py
    scripts/test_clean_empty_threads.py
    scripts/test_cron_switch_copy_files.py
    scripts/test_direction_bind.py
    scripts/test_fill_thead_canonical_uid.py
    scripts/test_fill_train_purchase_numbers.py
    scripts/test_find_packages_to_reload_to_use_is_base.py
    scripts/test_moscow_quarantine_buses.py
    scripts/test_notify_bus_suppliers.py
    scripts/test_rotate_temporary_data.py
    scripts/test_suburban_tarffs_import.py
    scripts/test_support_methods.py
    scripts/test_update_geobase.py
    scripts/test_www_companies.py
    scripts/test_www_stations.py
    scripts/test_z_noderoute2.py
    scripts/test_z_station_schedule.py

    scripts/utils/__init__.py
    scripts/utils/file_wrapper/test_mds_utils.py
    scripts/utils/test_import_file_storage.py
    scripts/utils/test_action_list.py

    mds_files_viewer/test_mds_files_viewer.py

    test_atomic_rollback.py

    timecorrection/__init__.py
    timecorrection/test_data_downloaders.py
    timecorrection/test_models_data_access.py
    timecorrection/test_path_checkers.py
    timecorrection/test_utils.py

    www/__init__.py
    www/admin/__init__.py
    www/admin/test_company_admin.py
    www/admin/test_station_admin.py
    www/utils/__init__.py
    www/utils/test_mysql.py
)

IF(DEBUG_WITH_PYCHARM)
    PY_SRCS(
        NAMESPACE tests
        # Duplicate all test files here for debug via PyCharm (RASPFRONT-7607)
        ${_SRCS}
    )
ENDIF()

TEST_SRCS(
    ${_SRCS}
    www/test_district.py
    www/test_thread.py
)

END()
