# -*- coding: utf-8 -*-
from django.contrib import admin

from travel.rasp.admin.lib.admin_options import RaspExportModelAdmin

from travel.rasp.admin.timecorrection.models import PathSpan, MapData


class MapDataInline(admin.StackedInline):
    model = MapData
    extra = 3


class PathSpanAdmin(RaspExportModelAdmin):
    inlines = [MapDataInline, ]
    fields = (
        ('station_from', 'station_to',),
        ('duration', 'min_drive_time', 'max_drive_time'),
        'distance',
        'is_one_country_path',
        ('manual_max_drive_speed', 'max_drive_speed'),
        ('manual_min_drive_speed', 'min_drive_speed'),
    )
    readonly_fields = ['max_drive_speed', 'min_drive_speed', 'min_drive_time', 'max_drive_time']
    raw_id_fields = ('station_from', 'station_to',)


admin.site.register(PathSpan, PathSpanAdmin)


class MapDataAdmin(RaspExportModelAdmin):
    readonly_fields = ('raw',)
    raw_id_fields = ('pathspan',)


admin.site.register(MapData, MapDataAdmin)
