# -*- coding: utf-8 -*-
import logging

from common.models.schedule import RThread
from travel.rasp.admin.timecorrection.models import ThreadCalcDataCache
from travel.rasp.admin.timecorrection.models_data_access import ThreadCalcDataCacheProxy

log = logging.getLogger(__name__)


def drop_and_calc_temp_thread_for_package(two_stage_package_id):
    temp_thread_data_qs = ThreadCalcDataCache.objects.filter(thread__route__two_stage_package_id=two_stage_package_id)
    log.info(u'Общее количество рассчитанных ниток этого пакета {}'.format(temp_thread_data_qs.count()))

    temp_thread_data_qs.all().delete()
    log.info(u'Расчетные данные пакета были сброшены')

    thread_data_cache = ThreadCalcDataCacheProxy()
    for thread in RThread.objects.filter(route__two_stage_package_id=two_stage_package_id):
        thread_data_cache.get_thread_data_cache(thread)

    log.info(u'Общее количество ниток {}'.format(temp_thread_data_qs.count()))
    log.info(u'Ниток с ошибками в координатах {bad_coordinates}, неподтвержденных в ЛГА {not_approved}, '
             u'скорректированных {corrected}'
             .format(bad_coordinates=temp_thread_data_qs.filter(permanent_path_data__path_correct=False).count(),
                     not_approved=temp_thread_data_qs.filter(path_approved=False).count(),
                     corrected=temp_thread_data_qs.filter(corrected=True).count()))
