# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from django.db.models.deletion import CASCADE


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0015_namesearchindex_index'),
    ]

    operations = [
        migrations.CreateModel(
            name='MapData',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('raw', models.TextField(default=None, null=True, editable=False, blank=True)),
                ('time', models.FloatField(default=None, verbose_name='время пути в минутах')),
                ('distance', models.FloatField(default=None, verbose_name='расстояние между станциями в километрах')),
                ('json_path', models.TextField(help_text='json-данные геокодирования маршрута', null=True, verbose_name='координаты пути', blank=True)),
            ],
            options={
                'verbose_name': 'Данные маршрутизатора',
            },
        ),
        migrations.CreateModel(
            name='PathSpan',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('duration', models.FloatField(default=None, verbose_name='время пути в минутах')),
                ('distance', models.FloatField(default=None, verbose_name='расстояние между станциями в километрах')),
                ('is_data_calculated', models.BooleanField(default=False, verbose_name='данные были рассчитаны вручную')),
                ('is_one_country_path', models.BooleanField(default=False)),
                ('station_from', models.ForeignKey(related_name='pathspan_station_from', verbose_name='от какой станции', to='www.Station')),
                ('station_to', models.ForeignKey(related_name='pathspan_station_to', verbose_name='до какой станции', to='www.Station')),
            ],
            options={
                'verbose_name': 'время пути между двумя станциями',
                'verbose_name_plural': 'времена в пути между двумя станциями',
            },
        ),
        migrations.CreateModel(
            name='PathSpanDataCache',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('stop_time', models.FloatField(default=None, verbose_name='время остановки на станции "от"')),
                ('time_shift', models.FloatField(default=None, verbose_name='время участка от поставщика')),
                ('line_distance', models.FloatField(default=None, verbose_name='расстояние по прямой')),
                ('line_with_div', models.FloatField(default=None, verbose_name='расстояние по прямой с дорожным дополнением')),
                ('geo_dist', models.FloatField(null=True, verbose_name='расстояние по гео админу', blank=True)),
                ('is_corrected', models.BooleanField(default=False, db_index=True, verbose_name='время участка было скорректировано')),
                ('path_span', models.ForeignKey(related_name='calculated_data', blank=True, to='timecorrection.PathSpan', null=True)),
                ('rtstation_from', models.ForeignKey(on_delete=CASCADE, related_name='pathspan_station_from', verbose_name='от какой станции', to='www.RTStation')),
                ('rtstation_to', models.ForeignKey(on_delete=CASCADE, related_name='pathspan_station_to', verbose_name='до какой станции', to='www.RTStation')),
            ],
        ),
        migrations.CreateModel(
            name='ThreadCalcDataCache',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('corrected', models.BooleanField(default=False, db_index=True, verbose_name='нитка скорректирована')),
                ('path_correct', models.BooleanField(default=False, db_index=True, verbose_name='нитка не вызывает подозрений')),
                ('path_approved', models.BooleanField(default=False, db_index=True, verbose_name='нитка подтверждена')),
                ('thread_distance', models.FloatField(default=0, db_index=True, verbose_name='длинна нитки', blank=True)),
                ('line_distance', models.FloatField(default=0, db_index=True, verbose_name='длинна нитки по прямой', blank=True)),
                ('duration_sum', models.FloatField(default=0, db_index=True, verbose_name='время нитки поставщика', blank=True)),
                ('duration_sum_correct', models.FloatField(default=0, db_index=True, verbose_name='время нитки корректора', blank=True)),
                ('correct_sum', models.FloatField(default=0, db_index=True, verbose_name='сумма по модулю всех корректировок', blank=True)),
                ('correct_percent', models.FloatField(default=0, db_index=True, verbose_name='процент корректировки', blank=True)),
                ('thread', models.OneToOneField(on_delete=CASCADE, related_name='calc_data', to='www.RThread')),
            ],
        ),
        migrations.AddField(
            model_name='mapdata',
            name='pathspan',
            field=models.OneToOneField(related_name='map_data', null=True, blank=True, to='timecorrection.PathSpan'),
        ),
    ]
