# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from django.db.models.deletion import CASCADE


class Migration(migrations.Migration):
    dependencies = [
        ('timecorrection', '0002_sql_cascade'),
    ]

    operations = [
        migrations.AddField(
            model_name='threadcalcdatacache',
            name='correct_to_valid_sum',
            field=models.FloatField(default=0, db_index=True,
                                    verbose_name='сумма минимального времени, на которое нужно изменить участки нитки,'
                                                 ' чтобы она стала валидной',
                                    blank=True),
        ),
        migrations.CreateModel(
            name='CorrectionResult',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('algorithm_type', models.CharField(max_length=30, verbose_name='тип корректировки', db_index=True)),
                ('is_path_valid',
                 models.BooleanField(default=False, db_index=True, verbose_name='нитка верна после корректировки')),
                ('number_of_moved_parts',
                 models.IntegerField(default=None, null=True, verbose_name='количество измененных участков нитки',
                                     db_index=True, blank=True)),
                ('thread_data_cache',
                 models.ForeignKey(related_name='correction_results', to='timecorrection.ThreadCalcDataCache',
                                   null=True, on_delete=CASCADE)),
            ],
        ),
        migrations.AddField(
            model_name='threadcalcdatacache',
            name='number_of_invalid_parts',
            field=models.IntegerField(default=0, db_index=True, verbose_name='количество невалидных участков нитки',
                                      blank=True),
        ),
        migrations.AddField(
            model_name='pathspan',
            name='manual_max_drive_speed',
            field=models.FloatField(default=0, verbose_name='максимальная скорость движения в км/ч'),
        ),
        migrations.AddField(
            model_name='pathspan',
            name='manual_min_drive_speed',
            field=models.FloatField(default=0, verbose_name='минимальная скорость движения в км/ч'),
        ),
    ]
