# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('timecorrection', '0004_sql_cascade_for_correction_result'),
    ]

    operations = [
        migrations.AlterField(
            model_name='threadcalcdatacache',
            name='correct_to_valid_sum',
            field=models.FloatField(
                default=0,
                db_index=True,
                verbose_name='сумма минимального времени, на которое нужно изменить участки нитки, '
                             'чтобы она стала валидной',
                blank=True),
        ),
        migrations.RemoveField(
            model_name='threadcalcdatacache',
            name='path_correct',
        ),
        migrations.CreateModel(
            name='PermanentPathData',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('stations_coordinates_hash', models.CharField(max_length=40,
                                                               verbose_name='Хеш из координат станций нитки',
                                                               db_index=True)),
                ('station_coordinates_string', models.TextField(default=b'', verbose_name='координаты станций')),
                ('path_correct', models.BooleanField(default=True, verbose_name='путь не вызывает подозрений')),
            ],
        ),
        migrations.AddField(
            model_name='threadcalcdatacache',
            name='permanent_path_data',
            field=models.ForeignKey(related_name='+', db_constraint=False, blank=True,
                                    to='timecorrection.PermanentPathData', null=True),
        ),
    ]
