# coding: utf-8

import logging
from optparse import OptionParser

import travel.rasp.admin.scripts.load_project  # noqa
from django.db.models.query import QuerySet

from common.models.schedule import RThread
from common.models.transport import TransportType
from travel.rasp.admin.lib.logs import add_stdout_handler, create_current_file_run_log
from travel.rasp.admin.timecorrection.path_checkers import GeometryCheck, is_path_approved
from travel.rasp.admin.timecorrection.models_data_access import PathSpanProxy
from travel.rasp.admin.timecorrection.utils import n_wize

log = logging.getLogger(__name__)


def import_pathspan(thread_qs, update=False):
    if isinstance(thread_qs, QuerySet) and thread_qs.query.model == RThread:
        pathspan_proxy = PathSpanProxy()

        for route_thread in thread_qs:
            stations = route_thread.get_stations()
            if is_path_approved(stations) and GeometryCheck.is_path_correct(stations):
                for pair in n_wize(stations, n=2):
                    pathspan_proxy.get_pathspan(*pair, update=update)
        log.info(u'Количество запросов к маршрутизатору {num}'.format(num=pathspan_proxy.total_map_requests))
    else:
        raise NotImplementedError


if __name__ == "__main__":
    usage = u'usage: %prog [options] -s or -a'
    opt_parser = OptionParser(usage=usage)

    opt_parser.add_option('-v', '--verbose', action='store_true', dest='verbose',
                          help=u'выводить лог на экран')
    opt_parser.add_option('-u', '--update', action='store_true', dest='update', default=False,
                          help=u'обновлять существующие данные')
    opt_parser.add_option('-a', '--all', action='store_true', dest='all', default=False,
                          help=u'обрабатываются маршруты всех поставщиков')
    opt_parser.add_option('-s', '--supplier', action='store', dest='supplier',
                          help=u'supplier id')
    opt_parser.add_option('-n', '--number', action='store', dest='number',
                          help=u'обрабатываются первые N маршрутов')

    options, args = opt_parser.parse_args()

    create_current_file_run_log()
    if options.verbose:
        add_stdout_handler(log)

    thread_query_set = RThread.objects.filter(t_type_id=TransportType.BUS_ID)

    if options.supplier:
        thread_query_set = thread_query_set.filter(supplier_id=options.supplier)
    elif options.all:
        log.info(u'обрабатываются маршруты всех поставщиков')
    else:
        opt_parser.error(u'incorrect number of arguments')

    if options.number:
        thread_query_set = thread_query_set[:options.number]

    import_pathspan(thread_query_set, update=options.update)
    log.info(u'Инициализация завершена')
