# -*- coding: utf-8 -*-
import logging
from optparse import OptionParser

import travel.rasp.admin.scripts.load_project  # noqa

from common.models.schedule import RThread
from travel.rasp.admin.timecorrection.models import ThreadCalcDataCache
from travel.rasp.admin.timecorrection.models_data_access import ThreadCalcDataCacheProxy
from travel.rasp.admin.lib.logs import add_stdout_handler, create_current_file_run_log

log = logging.getLogger(__name__)


def init_thread_data_cache(package_id, num=None, update=False, field=None):
    if field:
        thread_data_cache_qs = ThreadCalcDataCache.objects.filter(thread__route__two_stage_package_id=package_id)
        try:
            ThreadCalcDataCacheProxy.update_field(thread_data_cache_qs, field)
        except ThreadCalcDataCacheProxy.UpdateFieldError as e:
            log.error(e.msg)
        return
    if update:
        ThreadCalcDataCache.objects.filter(thread__route__two_stage_package_id=package_id).delete()

    thread_data_cache = ThreadCalcDataCacheProxy()
    thread_query_set = RThread.objects.filter(route__two_stage_package_id=package_id)

    if num is not None:
        thread_query_set = thread_query_set[:num]

    for thread in thread_query_set:
        thread_data_cache.get_thread_data_cache(thread)


if __name__ == '__main__':
    usage = u'usage: %prog [options] <two stage package id>'
    opt_parser = OptionParser(usage=usage)

    opt_parser.add_option('-v', '--verbose', action='store_true', dest='verbose',
                          help=u'выводить лог на экран')
    opt_parser.add_option('-n', '--number', action='store', dest='number',
                          help=u'обрабатываются первые N маршрутов')
    opt_parser.add_option('-u', '--update', action='store_true', dest='update', default=False,
                          help=u'обновлять существующие данные')
    opt_parser.add_option('-f', '--field', action='store', dest='field', default=None,
                          help=u'обновлять конкретное поле. Флаги number и update игнорируются')

    options, args = opt_parser.parse_args()

    if options.verbose:
        add_stdout_handler(log)
    if len(args) != 1:
        opt_parser.error(u'incorrect number of arguments')

    create_current_file_run_log()
    init_thread_data_cache(package_id=args[0], num=options.number, update=options.update, field=options.field)
