var n = d3.range(diff.length);


function sigmoid(x, a) {
    return 1 / (1 + Math.exp(-1 * a * x))
}

var svg = d3.select(".svg").append("svg")
    .attr("width", "100%")
    .attr("height", "100%");

var x = d3.scaleLinear().range([10, 90]);

var etalonScale = x.domain(d3.extent(calculatedDuraionArrayAcc));

var etalonCircle = svg.append("g").selectAll("circle")
    .data(n)
    .enter().append("circle")
    .attr("cx", function (d) {
        return etalonScale(calculatedDuraionArrayAcc[d]) + '%'
    })
    .attr("cy", etalonPersent + "%")
    .attr("r", 3.5)
    .on("mouseover", function (d) {
        d3.select(this).style("fill", "red");
    })
    .on("mouseout", function () {
        d3.select(this).style("fill", "black");
    });

var calcScale = x.domain(d3.extent(supplierDurationArrayAcc));

var calculatedCircle = svg.append("g").selectAll("circle")
    .data(n)
    .enter().append("circle")
    .attr("cx", function (d) {
        return calcScale(supplierDurationArrayAcc[d] + diffArray[d]) + '%';
    })
    .attr("cy", calcPersent + "%")
    .attr("r", 3.5)
    .on("mouseover", function (d) {
        d3.select(this).style("fill", "red");
        etalonCircle._groups[0][d].style = "fill:red";
    })
    .on("mouseout", function (d) {
        d3.select(this).style("fill", "black");
        etalonCircle._groups[0][d].style = "fill:black";
    }).transition()
    .duration(2500);

var supplierCircle = svg.append("g").selectAll("circle")
    .data(n)
    .enter().append("circle")
    .attr("cx", function (d) {
        return calcScale(supplierDurationArrayAcc[d]) + '%';
    })
    .attr("cy", supplierPersent + "%")
    .attr("r", 3.5)
    .on("mouseover", function (d) {
        d3.select(this).style("fill", "red");
        etalonCircle._groups[0][d].style = "fill:red";
    })
    .on("mouseout", function (d) {
        d3.select(this).style("fill", "black");
        etalonCircle._groups[0][d].style = "fill:black";
    });

svg.append("line")
    .attr("class", "line")
    .attr("x1", "10%")
    .attr("y1", etalonPersent + "%")
    .attr("x2", "90%")
    .attr("y2", etalonPersent + "%");

svg.append("line")
    .attr("class", "line")
    .attr("x1", "10%")
    .attr("y1", calcPersent + "%")
    .attr("x2", "90%")
    .attr("y2", calcPersent + "%");

svg.append("line")
    .attr("class", "line")
    .attr("x1", "10%")
    .attr("y1", supplierPersent + "%")
    .attr("x2", "90%")
    .attr("y2", supplierPersent + "%");

var sigmoidX = d3.scaleLinear()
    .range([700, 900])
    .domain([-100, 100]);
var sigmoidY = d3.scaleLinear()
    .range([110, 10]);

var lineCreator = d3.line()
    .x(function (d) {
        return sigmoidX(d[0]);
    })
    .y(function (d) {
        return sigmoidY(d[1]);
    });

var sigmoidLine = svg.append("path")
    .datum(d3.range(-10, 10, 0.1).map(function (x) {
        return [x, sigmoid(x, A)]
    }))
    .attr("class", "line")
    .attr("fill", "none")
    .attr("d", lineCreator);


d3.select("#coef input")
    .on("input", function () {
        changeOunput(this.value);
    })
    .each(function () {
        changeOunput(this.value);
    });

d3.select("#std input")
    .on("input", function () {
        changeOunputStd(this.value);
    })
    .each(function () {
        changeOunputStd(this.value);
    });


function changeOunputStd(x) {
    std = x;
    d3.select("#std output").text(x);
    calculatedCircle.each(changeDataOnPage);
}
var prev_sum = 0;
function changeDataOnPage() {
    var sigmoidScale = d3.scaleLinear()
        .range([-10, 10]).domain([-0.1, 0.1]);
    var circle = d3.select(this);
    var num = circle._groups[0][0].__data__;
    var z = sigmoid(sigmoidScale(Math.abs(diff[num]) - std), A);
    if (num == 0)
        prev_sum = 0;
    else {
        var up_coef = diff[num] * z * supplierDurationSum;
        var acc_val = supplierDurationArrayAcc[num] + up_coef;
        document.getElementById('result' + (num - 1)).textContent = Math.round((acc_val - prev_sum) * 100) / 100;
        circle.transition().attr("cx", function (d) {
            return calcScale(acc_val) + '%';
        });
        prev_sum = acc_val;
    }

}
function changeOunput(changeValue) {
    A = changeValue;
    d3.select("#coef output").text(changeValue);
    sigmoidLine.transition()
        .duration(1000)
        .attr("d", lineCreator(d3.range(-100, 100, 1).map(
            function (x) {
                return [x, sigmoid(x, changeValue)]
            })
            )
        );
    calculatedCircle.each(changeDataOnPage)
}
