ymaps.ready(init);

function init() {
    var YaMap = new ymaps.Map("map", {
        center: [points[1].longitude, points[1].latitude],
        zoom: 6
    });

    var pointsCollection = new ymaps.GeoObjectCollection({}, {preset: "islands#blueStretchyIcon"});

    points.forEach(function (point, n) {
        pointsCollection.add(new ymaps.Placemark(
            [point.longitude, point.latitude],
            {
                iconContent: ++n + " " + point.title
            },
            {}))
    });
    var geoPathCollection = new ymaps.GeoObjectCollection({}, {
        strokeColor: '#FF0000',
        strokeWidth: 3
    });

    geoPath.forEach(function (path) {
        geoPathCollection.add(new ymaps.Polyline(path));
    });

    var mapPathCollection = new ymaps.GeoObjectCollection({}, {
        strokeColor: '#0000FF',
        strokeWidth: 3
    });

    multiRoutePath.forEach(function (path) {
        mapPathCollection.add(new ymaps.Polyline(path));
    });


    YaMap.geoObjects.add(mapPathCollection).add(pointsCollection).add(geoPathCollection);

    var pointsListBoxItem = new ymaps.control.ListBoxItem({data: {content: 'Точки'}, state: {selected: true}});
    var navigatorListBoxItem = new ymaps.control.ListBoxItem({data: {content: 'Навигатор'}, state: {selected: true}});
    var geoListBoxItem = new ymaps.control.ListBoxItem({data: {content: 'Гео админ'}, state: {selected: true}});

    pointsListBoxItem.events.add(['select', 'deselect'], function (e) {
        var eType = e.get('type');
        pointsCollection.options.set('visible', 'select' == eType)

    });
    navigatorListBoxItem.events.add(['select', 'deselect'], function (e) {
        var eType = e.get('type');
        mapPathCollection.options.set('visible', 'select' == eType)

    });
    geoListBoxItem.events.add(['select', 'deselect'], function (e) {
        var eType = e.get('type');
        geoPathCollection.options.set('visible', 'select' == eType)

    });
    var listBox = new ymaps.control.ListBox({
        data: {
            content: 'Объекты на карте'
        },
        items: [pointsListBoxItem, navigatorListBoxItem, geoListBoxItem]
    });

    YaMap.controls.add(listBox);
}
