# coding: utf-8 -*-

from django.conf.urls import url, include

import travel.rasp.admin.timecorrection.view as timecorrection_view


new_urlpatterns = [
    url(r'^$', timecorrection_view.new, name='new'),
    url(r'^package_(?P<package_id>\d+)$', timecorrection_view.new_package_view, name='new_package_view'),
    url(r'^thread_list$', timecorrection_view.new_thread_list, name='new_thread_list'),
]

urlpatterns = [
    url(r'^test$', timecorrection_view.test),
    url(r'^new/', include(new_urlpatterns)),
    url(r'^package_(?P<package_id>\d+)/$', timecorrection_view.package, name='by_package'),
    url(r'^uid_(?P<uid>\w+)/$', timecorrection_view.by_uid, name='by_uid'),
    url(r'^(?P<supplier_id>\d+)/two_station/$', timecorrection_view.two_station, name='two_station'),
    url(r'^(?P<supplier_id>\d+)/', timecorrection_view.index, name='index'),
]
