# -*- coding: utf-8 -*-
import math
import operator
from itertools import islice, izip


class Constants(object):
    # time
    SECONDS_IN_MINUTE = 60.
    MINUTES_IN_HOUR = 60.

    # distance
    METERS_IN_KM = 1000


def mean_speed_function(distance):
    if distance < 1:
        return 35
    else:
        return 5 * math.log(distance) + 35


def n_wize(iterable, n=2):
    """s -> (s0,s1,s2, ... n), (s1,s2,s3, ... n), (s2,s3,s4, ... n), ..."""
    s = (islice(iterable, i, None) for i in xrange(n))
    return izip(*s)


def accumulate(iterable, func=operator.add):
    """Return running totals
    >>>accumulate([1,2,3,4,5]) -> 1 3 6 10 15
    >>>accumulate([1,2,3,4,5], operator.mul) -> 1 2 6 24 120
    """
    it = iter(iterable)
    try:
        total = next(it)
    except StopIteration:
        return
    yield total
    for element in it:
        total = func(total, element)
        yield total


def undo_accumulate(iterable, func=operator.sub):
    """
    Обратная функция для accumulate
    >>>undo_accumulate([1,3,6,10,15]) -> 1 2 3 4 5
    >>>undo_accumulate([1,2,6,24,120], operator.div) -> 1 2 3 4 5
    """
    it = tuple(iterable)
    if not len(it):
        return
    yield it[0]
    for n in range(1, len(it)):
        yield func(it[n], it[n - 1])
