# coding: utf-8
import math


def norm(value, domain=None):
    """
    normalization for sigmoid function
    :param domain: sets the domain
    :param value: value for normalization
    :return: normalized value
    """
    if domain is None:
        domain = [-0.1, 0.1]

    lower_range, upper_range = [-10, 10]
    lower_domain, upper_domain = domain
    return (((value - lower_domain) * (upper_range - lower_range)) / (upper_domain - lower_domain)) + lower_range


def std(arr):
    """
    standard deviation
    https://en.wikipedia.org/wiki/Standard_deviation
    :param arr: массив отклонений
    :return:
    """
    return math.sqrt(sum([v ** 2 for v in arr]) / (len(arr) - 1))


def sigmoid_function(value, a=0.15):
    """
    https://en.wikipedia.org/wiki/Sigmoid_function
    :param value:
    :param a:
    :return:
    """
    value = norm(value)
    return 1 / (1 + math.exp(-1 * a * value))
