# -*- coding: utf-8 -*-

from django.conf.urls import url, include
from django.conf import settings
from django.contrib.staticfiles.urls import staticfiles_urlpatterns

from travel.rasp.admin.www.views import django_ping, version, logtail
from common.views.db_info import db_info


urlpatterns = [
    url(r'^(?:django/)?ping', django_ping),
    url(r'^version$', version),

    url(r'^admin/maintenance/logtail/(?P<path>[\w\-./]+)$', logtail),

    url(r'^admin/', include('travel.rasp.admin.admin.urls')),
    url(r'^dostup/', include('django_idm_api.urls')),

    url(r'^dev/dbinfo$', db_info),

    url(r'^', include('travel.rasp.admin.admin.urls')),
]


if settings.DEBUG:
    urlpatterns += staticfiles_urlpatterns()
