# coding: utf-8

from __future__ import unicode_literals

import logging

from django.conf import settings

from common.settings.db import WorkInstance, ServiceInstance

log = logging.getLogger(__name__)


def default(request):
    debug = settings.DEBUG

    other_text = other_url = ''
    if settings.INSTANCE_ROLE is WorkInstance:
        other_text = 'Открыть на сервисной'
        other_url = 'https://{}{}'.format(settings.DOMAIN_NAMES[ServiceInstance.code], request.get_full_path())
    elif settings.INSTANCE_ROLE is ServiceInstance:
        other_text = 'Открыть на боевой'
        other_url = 'https://{}{}'.format(settings.DOMAIN_NAMES[WorkInstance.code], request.get_full_path())

    d = {
        'now': request.now,
        'debug': debug,

        'quick_tree_url': '/admin/quick_tree/',

        # настройки
        'settings': settings,
        'absolute_uri': request.build_absolute_uri(),
        'other_admin_text': other_text,
        'other_admin_url': other_url,

        'MARKUP_URL': settings.MARKUP_URL
    }

    return d
