# coding: utf-8

from __future__ import unicode_literals


import logging

from django.core.management import call_command
from django.core.management.base import BaseCommand

from travel.rasp.admin.lib.logs import create_run_log, print_log_to_stdout


log = logging.getLogger(__name__)


# Наследуем, чтобы обработались все аргументы
class Command(BaseCommand):
    def handle(self, *args, **kwargs):
        create_run_log('special.management_runs.' + __name__)

        if int(kwargs.get('verbosity', 0)) > 0:
            print_log_to_stdout()

        log.warning('Внимание! Скрипт потерял актуальность нужно пользоваться migrate --noinput')
        log.info(u'Создаем базу')
        # Нужна команды именно из south
        call_command('migrate', verbosity=kwargs.get('verbosity', 1), interactive=False)

        log.info(u'Готово')
