# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management import BaseCommand

from travel.rasp.admin.lib.maintenance.flags import flags


class Command(BaseCommand):
    def add_arguments(self, parser):
        parser.add_argument('flag_name')

    def handle(self, flag_name=None, **options):
        if not flag_name:
            self.stdout.write(u'Укажите название флага')
            self.stdout.write(u'Usage: manage.py remove_flag <flag_name>')
        else:
            flags[flag_name] = False
            self.stdout.write(u'Флаг %s на %s успешно снят' % (flag_name, settings.INSTANCE_ROLE.code))
