# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, print_function

import sys
import logging

from django.core.management import call_command
from django.core.management.base import BaseCommand

from travel.rasp.admin.lib.maintenance.flags import flags
from travel.rasp.admin.lib.maintenance.scripts import job
from travel.rasp.admin.lib.logs import create_run_log, print_log_to_stdout


log = logging.getLogger(__name__)

DJANGO_MIGRATIONS_TABLE_NAME = 'django_migrations'


class Command(BaseCommand):
    help = u'''
    Команда для обновления реальной базы или копии реальной базы.
    Для других случаев лучше использовать обычный migrate.
    '''

    def add_arguments(self, parser):
        parser.add_argument('--ignore-flag', action='store_true', default=False)

    def handle(self, verbosity=0, ignore_flag=False, **kwargs):
        create_run_log('special.management_runs.' + __name__)

        if verbosity > 0:
            print_log_to_stdout()

        if not ignore_flag:
            if flags['maintenance']:
                log.warning(u"Идет работа с базой данных нельзя запускать миграцию")
                sys.exit(1)

            flags['maintenance'] = job.UPDATE.flag_value

        try:
            log.info(u"Начинаем миграцию")
            call_command('migrate', verbosity=verbosity, interactive=False, traceback=True)

            if not ignore_flag:
                flags['maintenance'] = 0

            log.info(u"Миграция прошла успешно")
        except BaseException:
            log.exception(u"Возникла ошибка при миграции")
            raise

    def migration_table_exists(self):
        from django.db import connection

        cursor = connection.cursor()
        cursor.execute('SHOW TABLES')
        tables = [t.lower() for t, in cursor.fetchall()]
        connection.close()

        return DJANGO_MIGRATIONS_TABLE_NAME in tables
