# -*- coding: utf-8 -*-

import logging

from django.conf import settings
from django.contrib.auth.middleware import AuthenticationMiddleware
from django.utils import translation


log = logging.getLogger(__name__)


class AdminAuth(AuthenticationMiddleware):
    """ Авторизация работает только для админки """

    def process_request(self, request):
        if settings.YAUSER_ADMIN_LOGIN:
            request.user = request.yauser.get_django_user()
        else:
            super(AdminAuth, self).process_request(request)


class Language:
    def process_request(self, request):
        request.supported_langs = settings.ADMIN_LANGUAGES

        if 'lang' in request.GET:
            lang = request.GET['lang']

        elif 'locale' in request.GET:
            lang = request.GET['locale']

        else:
            if settings.YAUSER_ADMIN_LOGIN:
                lang = request.yauser.lang or 'ru'
            else:
                lang = 'ru'

            request.maps_language = lang

        translation.activate(lang)

        request.LANGUAGE_CODE = translation.get_language()
