# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import common.models.schedule
import common.utils.fields
import common.models.transport
import common.models_utils.geo
import common.models_utils
import common.utils.files.validators
import common.models_abstract.schedule
import django.core.validators

from travel.rasp.library.python.common23.models.core.schedule import base_supplier
from travel.rasp.library.python.common23.models.transport.transport_subtype import TransportSubtypeIconField, transportsubtypeiconfield_generate_filename
from travel.rasp.library.python.common23.models.core.schedule.company import get_svg2png_logo_upload_to


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='AeroexTariff',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('tariff', models.FloatField(verbose_name='\u0426\u0435\u043d\u0430')),
                ('suburban_search', models.BooleanField(default=True, verbose_name='\u0412 \u043f\u043e\u0438\u0441\u043a\u0435 \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u0435\u043a')),
                ('reverse', models.BooleanField(default=True, verbose_name='\u0442\u0443\u0434\u0430-\u043e\u0431\u0440\u0430\u0442\u043d\u043e')),
                ('precalc', models.BooleanField(default=False, verbose_name='\u0417\u043e\u043d\u043d\u044b\u0439')),
                ('currency', models.CharField(default=None, max_length=10, null=True, verbose_name='\u0412\u0430\u043b\u044e\u0442\u0430', blank=True)),
            ],
            options={
                'verbose_name': '\u0442\u0430\u0440\u0438\u0444 \u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u043e\u0433\u043e \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u0442\u043e\u0447\u043a\u0430-\u0442\u043e\u0447\u043a\u0430',
                'verbose_name_plural': '\u0442\u0430\u0440\u0438\u0444\u044b \u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u043e\u0433\u043e \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u0442\u043e\u0447\u043a\u0430-\u0442\u043e\u0447\u043a\u0430',
            },
        ),
        migrations.CreateModel(
            name='AviaAlliance',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('logo_svg', models.FileField(upload_to=b'data/alliance/logo', verbose_name='SVG \u043b\u043e\u0433\u043e\u0442\u0438\u043f', blank=True)),
                ('enabled', models.BooleanField(default=False, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c')),
                ('title', common.utils.fields.TrimmedCharField(default='', max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u043b\u044c\u044f\u043d\u0441\u0430')),
                ('title_ru', common.utils.fields.TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u043b\u044c\u044f\u043d\u0441\u0430 (ru)', blank=True)),
                ('title_en', common.utils.fields.TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u043b\u044c\u044f\u043d\u0441\u0430 (en)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u043b\u044c\u044f\u043d\u0441\u0430 (tr)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u043b\u044c\u044f\u043d\u0441\u0430 (uk)', blank=True)),
                ('description', models.TextField(verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('description_ru', models.TextField(verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('description_en', models.TextField(verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('description_tr', models.TextField(verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('description_uk', models.TextField(verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (uk)', blank=True)),
            ],
            options={
                'ordering': ('title',),
                'verbose_name': '\u0430\u0432\u0438\u0430 \u0430\u043b\u044c\u044f\u043d\u0441',
                'verbose_name_plural': '\u0430\u0432\u0438\u0430 \u0430\u043b\u044c\u044f\u043d\u0441\u044b',
            },
        ),
        migrations.CreateModel(
            name='CityMajority',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
            ],
            options={
                'db_table': 'www_citymajority',
                'verbose_name': '\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u0433\u043e\u0440\u043e\u0434\u0430',
                'verbose_name_plural': '\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u0438 \u0433\u043e\u0440\u043e\u0434\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='CodeSystem',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f')),
                ('code', common.utils.fields.CodeCharField(unique=True, max_length=100, verbose_name='\u043a\u043e\u0434 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f')),
            ],
            options={
                'ordering': ('id',),
                'db_table': 'www_codesystem',
                'verbose_name': '\u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f',
                'verbose_name_plural': 'c\u0438\u0441\u0442\u0435\u043c\u044b \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('address', models.CharField(max_length=255, null=True, verbose_name='\u0430\u0434\u0440\u0435\u0441', blank=True)),
                ('supplier_code', common.utils.fields.CodeCharField(null=True, default=None, max_length=255, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u0414\u0430\u043d\u043d\u044b\u0445')),
                ('sirena_id', common.utils.fields.CodeCharField(null=True, default=None, max_length=100, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u0421\u0438\u0440\u0435\u043d\u0430')),
                ('iata', common.utils.fields.CodeCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043a\u043e\u0434 IATA', db_index=True)),
                ('icao', common.utils.fields.CodeCharField(max_length=100, unique=True, null=True, verbose_name='\u043a\u043e\u0434 ICAO', blank=True)),
                ('icao_ru', common.utils.fields.CodeCharField(max_length=100, unique=True, null=True, verbose_name='\u043a\u043e\u0434 ICAO(\u0440\u0443\u0441)', blank=True)),
                ('is_freight', models.BooleanField(default=False, help_text='\u041d\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u043c \u0442\u0430\u043a\u0438\u0435 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438 \u043e\u0442 OAG', verbose_name='\u0413\u0440\u0443\u0437\u043e\u0432\u0430\u044f \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f')),
                ('priority', models.IntegerField(default=0, help_text='\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442 \u0434\u043b\u044f \u0440\u0430\u0437\u043b\u0438\u0447\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0439 \u0441 \u043e\u0434\u043d\u0438\u043c \u0438\u0430\u0442\u0430-\u043a\u043e\u0434\u043e\u043c', blank=True)),
                ('url', models.URLField(max_length=255, null=True, verbose_name='\u0443\u0440\u043b \u0441\u0430\u0439\u0442\u0430', blank=True)),
                ('email', models.EmailField(max_length=255, null=True, verbose_name='email', blank=True)),
                ('contact_info', models.TextField(default=None, null=True, verbose_name='\u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f', blank=True)),
                ('phone', common.utils.fields.TrimmedCharField(default=b'', max_length=255, verbose_name='\u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d', blank=True)),
                ('phone_booking', common.utils.fields.TrimmedCharField(default=b'', max_length=255, verbose_name='\u0442\u0435\u043b\u0435\u0444\u043e\u043d \u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f', blank=True)),
                ('description', models.TextField(default=None, null=True, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('logo', models.ImageField(default=None, upload_to=b'data/company/logo', null=True, verbose_name='\u043b\u043e\u0433\u043e\u0442\u0438\u043f', blank=True)),
                ('icon', models.ImageField(default=None, upload_to=b'data/company/icon', null=True, verbose_name='\u0438\u043a\u043e\u043d\u043a\u0430', blank=True)),
                ('logo_mono', models.ImageField(default=None, upload_to=b'data/company/logo_mono', null=True, verbose_name='\u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0431\u0435\u0437 \u0444\u043e\u043d\u0430', blank=True)),
                ('logo_bgcolor', common.utils.fields.TrimmedCharField(default=b'', help_text='\u0412 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 #FF0044', max_length=7, verbose_name='\u0446\u0432\u0435\u0442 \u0444\u043e\u043d\u0430 \u043b\u043e\u0433\u043e\u0442\u0438\u043f\u0430', blank=True)),
                ('svg_logo', models.FileField(default=None, upload_to=b'data/company/svg', null=True, verbose_name='svg \u043b\u043e\u0433\u043e\u0442\u0438\u043f', blank=True)),
                ('svg2png_logo', models.ImageField(default=None, storage=common.utils.fields.ReplaceableFileSystemStorage(), upload_to=get_svg2png_logo_upload_to, blank=True, null=True, verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png \u043b\u043e\u0433\u043e\u0442\u0438\u043f')),
                ('hidden', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0438\u0433\u0434\u0435!')),
                ('strange', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043f\u043e\u043d\u044f\u0442\u043d\u044b\u0435 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0438')),
                ('meta_title', models.CharField(max_length=255, null=True, verbose_name='meta title', blank=True)),
                ('meta_description', models.TextField(null=True, verbose_name='meta description', blank=True)),
                ('bonus_name', common.utils.fields.TrimmedCharField(default='', max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0434\u043b\u044f \u0447\u0430\u0441\u0442\u043e \u043b\u0435\u0442\u0430\u044e\u0449\u0438\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432', blank=True)),
                ('bonus_name_ru', common.utils.fields.TrimmedCharField(default='', max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0434\u043b\u044f \u0447\u0430\u0441\u0442\u043e \u043b\u0435\u0442\u0430\u044e\u0449\u0438\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 (ru)', blank=True)),
                ('bonus_name_en', common.utils.fields.TrimmedCharField(default='', max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0434\u043b\u044f \u0447\u0430\u0441\u0442\u043e \u043b\u0435\u0442\u0430\u044e\u0449\u0438\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 (en)', blank=True)),
                ('bonus_name_tr', common.utils.fields.TrimmedCharField(default='', max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0434\u043b\u044f \u0447\u0430\u0441\u0442\u043e \u043b\u0435\u0442\u0430\u044e\u0449\u0438\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 (tr)', blank=True)),
                ('bonus_name_uk', common.utils.fields.TrimmedCharField(default='', max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0434\u043b\u044f \u0447\u0430\u0441\u0442\u043e \u043b\u0435\u0442\u0430\u044e\u0449\u0438\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 (uk)', blank=True)),
                ('registration_phone', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438', blank=True)),
                ('registration_phone_ru', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (ru)', blank=True)),
                ('registration_phone_en', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (en)', blank=True)),
                ('registration_phone_tr', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (tr)', blank=True)),
                ('registration_phone_uk', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (uk)', blank=True)),
                ('title', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('short_title', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u0440\u0430\u0442\u043a\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('short_title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u0440\u0430\u0442\u043a\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('short_title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u0440\u0430\u0442\u043a\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('short_title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u0440\u0430\u0442\u043a\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('short_title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u0440\u0430\u0442\u043a\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('registration_url', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='Url \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438', blank=True)),
                ('registration_url_ru', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='Url \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (ru)', blank=True)),
                ('registration_url_en', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='Url \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (en)', blank=True)),
                ('registration_url_tr', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='Url \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (tr)', blank=True)),
                ('registration_url_uk', common.utils.fields.TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='Url \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (uk)', blank=True)),
                ('alliance', models.ForeignKey(related_name='companies', verbose_name='\u0410\u0432\u0438\u0430-\u0430\u043b\u044c\u044f\u043d\u0441', blank=True, to='www.AviaAlliance', null=True)),
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_company',
                'verbose_name': '\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f-\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a',
                'verbose_name_plural': '\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438-\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0438',
            },
        ),
        migrations.CreateModel(
            name='CompanyOffice',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('address', models.CharField(max_length=255, verbose_name='\u0410\u0434\u0440\u0435\u0441\u0441')),
                ('contact_info', models.TextField(default=b'', verbose_name='\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f', blank=True)),
                ('phone', common.utils.fields.TrimmedCharField(default=b'', max_length=255, verbose_name='\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d', blank=True)),
                ('phone_booking', common.utils.fields.TrimmedCharField(default=b'', max_length=255, verbose_name='\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f', blank=True)),
                ('description', models.TextField(default=b'', verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('longitude', models.FloatField(default=None, null=True, verbose_name='\u0414\u043e\u043b\u0433\u043e\u0442\u0430', blank=True)),
                ('latitude', models.FloatField(default=None, null=True, verbose_name='\u0428\u0438\u0440\u043e\u0442\u0430', blank=True)),
                ('is_main', models.BooleanField(default=False, verbose_name='\u0413\u043b\u0430\u0432\u043d\u044b\u0439 \u043e\u0444\u0438\u0441')),
                ('company', models.ForeignKey(verbose_name='\u041a\u043e\u043c\u043f\u0430\u043d\u0438\u044f \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a', to='www.Company')),
            ],
            options={
                'verbose_name': '\u041e\u0444\u0438\u0441 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438-\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430',
                'verbose_name_plural': '\u041e\u0444\u0438\u0441\u044b \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0439-\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title_ru_preposition_v_vo_na', common.utils.fields.TrimmedCharField(default=None, max_length=2, null=True, verbose_name='\u043f\u0440\u0435\u0434\u043b\u043e\u0433 (\u0432, \u0432\u043e, \u043d\u0430)', blank=True)),
                ('title_ru_genitive', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u0440\u043e\u0434. \u043f\u0430\u0434\u0435\u0436', blank=True)),
                ('title_ru_locative', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u043c\u0435\u0441\u0442\u043d\u044b\u0439. \u043f\u0430\u0434\u0435\u0436)', blank=True)),
                ('title_uk_accusative', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u0432\u0438\u043d. \u043f\u0430\u0434\u0435\u0436) (uk)', blank=True)),
                ('_geo_id', models.IntegerField(default=None, unique=True, null=True, verbose_name='geo ID', blank=True)),
                ('_kladr_id', models.CharField(default=None, editable=False, max_length=50, blank=True, null=True, verbose_name='kladr ID')),
                ('code', common.utils.fields.CodeCharField(null=True, default=None, max_length=4, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b ISO 2-alpha')),
                ('domain_zone', common.utils.fields.CodeCharField(null=True, default=None, max_length=2, blank=True, help_text="\u0431\u0435\u0437 \u0442\u043e\u0447\u043a\u0438: 'ru', 'us', 'uk'", unique=True, verbose_name='\u0438\u043c\u044f \u0434\u043e\u043c\u0435\u043d\u043d\u043e\u0439 \u0437\u043e\u043d\u044b IANA')),
                ('language', common.utils.fields.CodeCharField(default=b'ru', max_length=5, verbose_name='\u044f\u0437\u044b\u043a \u0441\u0442\u0440\u0430\u043d\u044b', choices=[(b'af', 'Afrikaans'), (b'ar', 'Arabic'), (b'ast', 'Asturian'), (b'az', 'Azerbaijani'), (b'bg', 'Bulgarian'), (b'be', 'Belarusian'), (b'bn', 'Bengali'), (b'br', 'Breton'), (b'bs', 'Bosnian'), (b'ca', 'Catalan'), (b'cs', 'Czech'), (b'cy', 'Welsh'), (b'da', 'Danish'), (b'de', 'German'), (b'el', 'Greek'), (b'en', 'English'), (b'en-au', 'Australian English'), (b'en-gb', 'British English'), (b'eo', 'Esperanto'), (b'es', 'Spanish'), (b'es-ar', 'Argentinian Spanish'), (b'es-mx', 'Mexican Spanish'), (b'es-ni', 'Nicaraguan Spanish'), (b'es-ve', 'Venezuelan Spanish'), (b'et', 'Estonian'), (b'eu', 'Basque'), (b'fa', 'Persian'), (b'fi', 'Finnish'), (b'fr', 'French'), (b'fy', 'Frisian'), (b'ga', 'Irish'), (b'gl', 'Galician'), (b'he', 'Hebrew'), (b'hi', 'Hindi'), (b'hr', 'Croatian'), (b'hu', 'Hungarian'), (b'ia', 'Interlingua'), (b'id', 'Indonesian'), (b'io', 'Ido'), (b'is', 'Icelandic'), (b'it', 'Italian'), (b'ja', 'Japanese'), (b'ka', 'Georgian'), (b'kk', 'Kazakh'), (b'km', 'Khmer'), (b'kn', 'Kannada'), (b'ko', 'Korean'), (b'lb', 'Luxembourgish'), (b'lt', 'Lithuanian'), (b'lv', 'Latvian'), (b'mk', 'Macedonian'), (b'ml', 'Malayalam'), (b'mn', 'Mongolian'), (b'mr', 'Marathi'), (b'my', 'Burmese'), (b'nb', 'Norwegian Bokmal'), (b'ne', 'Nepali'), (b'nl', 'Dutch'), (b'nn', 'Norwegian Nynorsk'), (b'os', 'Ossetic'), (b'pa', 'Punjabi'), (b'pl', 'Polish'), (b'pt', 'Portuguese'), (b'pt-br', 'Brazilian Portuguese'), (b'ro', 'Romanian'), (b'ru', 'Russian'), (b'sk', 'Slovak'), (b'sl', 'Slovenian'), (b'sq', 'Albanian'), (b'sr', 'Serbian'), (b'sr-latn', 'Serbian Latin'), (b'sv', 'Swedish'), (b'sw', 'Swahili'), (b'ta', 'Tamil'), (b'te', 'Telugu'), (b'th', 'Thai'), (b'tr', 'Turkish'), (b'tt', 'Tatar'), (b'udm', 'Udmurt'), (b'uk', 'Ukrainian'), (b'ur', 'Urdu'), (b'vi', 'Vietnamese'), (b'zh-cn', 'Simplified Chinese'), (b'zh-hans', 'Simplified Chinese'), (b'zh-hant', 'Traditional Chinese'), (b'zh-tw', 'Traditional Chinese')])),
                ('title', common.utils.fields.TrimmedCharField(default=None, max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
            ],
            options={
                'db_table': 'www_country',
                'verbose_name': '\u0441\u0442\u0440\u0430\u043d\u0430',
                'verbose_name_plural': '\u0441\u0442\u0440\u0430\u043d\u044b',
            },
            bases=(models.Model, common.models_utils.geo.Point),
        ),
        migrations.CreateModel(
            name='DefaultPoint',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', common.utils.fields.TrimmedCharField(help_text="\u0432 \u043d\u0438\u0436\u043d\u0435\u043c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0435, '\u043c\u043e\u0441\u043a\u0432\u0430'", unique=True, max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
            ],
            options={
                'verbose_name': '\u0423\u0442\u043e\u0447\u043d\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e',
                'verbose_name_plural': '\u0423\u0442\u043e\u0447\u043d\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e',
            },
        ),
        migrations.CreateModel(
            name='DefaultSuggest',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('priority', models.IntegerField(help_text='\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u0442 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432', verbose_name='\u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442')),
                ('lang', models.CharField(help_text='\u042f\u0437\u044b\u043a, \u0434\u043b\u044f \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0431\u0443\u0434\u0435\u0442 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c\u0441\u044f \u043f\u043e\u0434\u0441\u043a\u0430\u0437\u043a\u0430: ru, tr,...', max_length=10, verbose_name='\u044f\u0437\u044b\u043a (deprecated)', choices=[(b'ru', '\u0420\u0443\u0441\u0441\u043a\u0438\u0439'), (b'be', '\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0439'), (b'kk', '\u041a\u0430\u0437\u0430\u0445\u0441\u043a\u0438\u0439'), (b'tt', '\u0422\u0430\u0442\u0430\u0440\u0441\u043a\u0438\u0439'), (b'uk', '\u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0438\u0439'), (b'en', '\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439'), (b'tr', '\u0422\u0443\u0440\u0435\u0446\u043a\u0438\u0439')])),
                ('national_version', models.CharField(default=b'ru', max_length=25, verbose_name='\u041d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f', choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr')])),
                ('suggest_type_id', models.IntegerField(help_text='Suggest \u043a \u043a\u043e\u0442\u043e\u0440\u043e\u043c\u0443 \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0441\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442', verbose_name='Suggest', choices=[(2, '\u0436/\u0434 \u0433\u043e\u0440\u043e\u0434'), (1, '\u0436/\u0434 \u0441\u0442\u0430\u043d\u0446\u0438\u044f'), (4, '\u0430\u0432\u0438\u0430 \u0433\u043e\u0440\u043e\u0434'), (3, '\u0430\u0432\u0438\u0430 \u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442')])),
                ('value', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u041f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435', null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435')),
                ('value_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u041f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435', null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (ru)')),
                ('value_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u041f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435', null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (en)')),
                ('value_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u041f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435', null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (tr)')),
                ('value_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u041f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435', null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (uk)')),
            ],
            options={
                'ordering': ('suggest_type_id', 'lang', 'priority', 'value'),
                'verbose_name': 'default suggest',
                'verbose_name_plural': 'default suggests',
            },
        ),
        migrations.CreateModel(
            name='DeLuxeTrain',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('numbers', common.utils.fields.TrimmedCharField(max_length=50, verbose_name='\u043d\u043e\u043c\u0435\u0440\u0430')),
                ('deluxe', models.BooleanField(default=False, verbose_name='\u043f\u043e\u0435\u0437\u0434 \u0444\u0438\u0440\u043c\u0435\u043d\u043d\u044b\u0439')),
                ('plain_title', common.utils.fields.TrimmedCharField(max_length=100, null=True, verbose_name='\u043f\u0440\u043e\u0441\u0442\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('title', common.utils.fields.TrimmedCharField(db_index=True, max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('title_ru', common.utils.fields.TrimmedCharField(db_index=True, max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('title_en', common.utils.fields.TrimmedCharField(db_index=True, max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(db_index=True, max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(db_index=True, max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
            ],
            options={
                'db_table': 'www_deluxetrain',
                'verbose_name': '\u0444\u0438\u0440\u043c\u0435\u043d\u043d\u044b\u0439 \u0438\u043b\u0438 \u0438\u043c\u0435\u043d\u043d\u043e\u0439 \u043f\u043e\u0435\u0437\u0434',
                'verbose_name_plural': '\u0444\u0438\u0440\u043c\u0435\u043d\u043d\u044b\u0435 \u0438 \u0438\u043c\u0435\u043d\u043d\u044b\u0435 \u043f\u043e\u0435\u0437\u0434\u0430',
            },
        ),
        migrations.CreateModel(
            name='Direction',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),
                ('title_from', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u0434\u0430(\u043e\u0442 \u041c\u043e\u0441\u043a\u0432\u044b)')),
                ('title_to', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043e\u0431\u0440\u0430\u0442\u043d\u043e(\u043d\u0430 \u041c\u043e\u0441\u043a\u0432\u0443)')),
                ('code', models.CharField(unique=True, max_length=50, verbose_name='\u043a\u043e\u0434 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_direction',
                'verbose_name': '\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435',
                'verbose_name_plural': '\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='DirectionFromTranslate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('value', common.utils.fields.TrimmedCharField(null=True, default=None, max_length=100, blank=True, unique=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435')),
                ('value_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (ru)', blank=True)),
                ('value_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (en)', blank=True)),
                ('value_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (tr)', blank=True)),
                ('value_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (uk)', blank=True)),
            ],
            options={
                'ordering': ('value',),
                'db_table': 'www_directionfromtranslate',
                'verbose_name': '\u043f\u0435\u0440\u0435\u0432\u043e\u0434 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u0434\u0430 \u0438 \u043e\u0431\u0440\u0430\u0442\u043d\u043e',
                'verbose_name_plural': '\u043f\u0435\u0440\u0435\u0432\u043e\u0434\u044b \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0439 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439 \u0442\u0443\u0434\u0430 \u0438 \u043e\u0431\u0440\u0430\u0442\u043d\u043e',
            },
        ),
        migrations.CreateModel(
            name='DirectionMarker',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title_from', models.CharField(help_text='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u0434\u0430(\u043e\u0442 \u041c\u043e\u0441\u043a\u0432\u044b). \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438((\u043e\u0442 \u041c\u043e\u0441\u043a\u0432\u044b) \u043d\u0430 \u041a\u0430\u0442\u044b\u0448\u043a\u0443)', max_length=100, null=True, verbose_name='\u0442\u0443\u0434\u0430', blank=True)),
                ('title_to', models.CharField(help_text='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043e\u0431\u0440\u0430\u0442\u043d\u043e(\u043d\u0430 \u041c\u043e\u0441\u043a\u0432\u0443). \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438((\u043d\u0430 \u041c\u043e\u0441\u043a\u0432\u0443) \u043d\u0430 \u0411\u0443\u0442\u043a\u0443)', max_length=100, null=True, verbose_name='\u043e\u0431\u0440\u0430\u0442\u043d\u043e', blank=True)),
                ('order', models.IntegerField(verbose_name='\u043f\u043e\u0440\u044f\u0434\u043e\u043a', db_index=True)),
                ('arrival_title_from', models.CharField(help_text='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u0434\u0430(\u043e\u0442 \u041c\u043e\u0441\u043a\u0432\u044b). \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f \u043d\u0430 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438((\u043e\u0442 \u041c\u043e\u0441\u043a\u0432\u044b) \u043d\u0430 \u041a\u0430\u0442\u044b\u0448\u043a\u0443) \u0438\u043d\u0430\u0447\u0435 \u0431\u0435\u0440\u0435\u0442\u0441\u044f \u0442\u0435\u043a\u0441\u0442 \u0438\u0437 \u0422\u0443\u0434\u0430', max_length=100, null=True, verbose_name='\u043f\u0440\u0438\u0431\u044b\u0442\u0438\u0435 \u0422\u0443\u0434\u0430', blank=True)),
                ('arrival_title_to', models.CharField(help_text='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043e\u0431\u0440\u0430\u0442\u043d\u043e(\u043d\u0430 \u041c\u043e\u0441\u043a\u0432\u0443). \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f \u043d\u0430 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438((\u043d\u0430 \u041c\u043e\u0441\u043a\u0432\u0443) \u043d\u0430 \u0411\u0443\u0442\u043a\u0443) \u0438\u043d\u0430\u0447\u0435 \u0431\u0435\u0440\u0435\u0442\u0441\u044f \u0442\u0435\u043a\u0441\u0442 \u0438\u0437 \u041e\u0431\u0440\u0430\u0442\u043d\u043e', max_length=100, null=True, verbose_name='\u043f\u0440\u0438\u0431\u044b\u0442\u0438\u0435 \u041e\u0431\u0440\u0430\u0442\u043d\u043e', blank=True)),
                ('arrow_type', models.CharField(blank=True, max_length=100, null=True, verbose_name='\u0442\u0438\u043f \u043e\u0442\u0432\u0435\u0442\u0432\u043b\u0435\u043d\u0438\u044f', choices=[(b'', '\u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e'), (b'right', '\u043d\u0430\u043f\u0440\u0430\u0432\u043e'), (b'left', '\u043d\u0430\u043b\u0435\u0432\u043e'), (b'up', '\u0432\u0432\u0435\u0440\u0445'), (b'down', '\u0432\u043d\u0438\u0437'), (b'right-up', '\u043d\u0430\u043f\u0440\u0430\u0432\u043e-\u0432\u0432\u0435\u0440\u0445'), (b'right-down', '\u043d\u0430\u043f\u0440\u0430\u0432\u043e-\u0432\u043d\u0438\u0437'), (b'left-up', '\u043d\u0430\u043b\u0435\u0432\u043e-\u0432\u0432\u0435\u0440\u0445'), (b'left-down', '\u043d\u0430\u043b\u0435\u0432\u043e-\u0432\u043d\u0438\u0437')])),
                ('arrow_title', models.CharField(max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0440\u0435\u043b\u043a\u0438', blank=True)),
                ('direction', models.ForeignKey(verbose_name='\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435', to='www.Direction')),
                ('next', models.ForeignKey(related_name='prev_set', verbose_name='\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', blank=True, to='www.DirectionMarker', null=True)),
                ('prev', models.ForeignKey(related_name='next_set', verbose_name='\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', blank=True, to='www.DirectionMarker', null=True)),
            ],
            options={
                'ordering': ('order',),
                'db_table': 'www_directionmarker',
                'verbose_name': '\u043c\u0430\u0440\u043a\u0435\u0440 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                'verbose_name_plural': '\u043c\u0430\u0440\u043a\u0435\u0440\u044b \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='DirectionTranslate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('value', common.utils.fields.TrimmedCharField(null=True, default=None, max_length=100, blank=True, unique=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435')),
                ('value_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (ru)', blank=True)),
                ('value_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (en)', blank=True)),
                ('value_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (tr)', blank=True)),
                ('value_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (uk)', blank=True)),
            ],
            options={
                'ordering': ('value',),
                'db_table': 'www_directiontranslate',
                'verbose_name': '\u043f\u0435\u0440\u0435\u0432\u043e\u0434 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                'verbose_name_plural': '\u043f\u0435\u0440\u0435\u0432\u043e\u0434\u044b \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0439 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='District',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=255, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('_disputed_territory', models.BooleanField(default=False, verbose_name='\u0441\u043f\u043e\u0440\u043d\u0430\u044f \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f', db_column=b'disputed_territory')),
            ],
            options={'verbose_name': 'район', 'verbose_name_plural': 'районы',
                     'db_table': 'www_district'},
        ),
        migrations.CreateModel(
            name='ExpressNumber',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', common.utils.fields.RegExpField(help_text='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430 \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0442\u044c \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u044b\u043c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c', unique=True, max_length=255, verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430')),
                ('express_type', models.CharField(max_length=20, verbose_name='\u0442\u0438\u043f \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u0430', choices=[(b'', '\u041e\u0431\u044b\u0447\u043d\u044b\u0439 \u0440\u0435\u0439\u0441'), (b'express', '\u042d\u043a\u0441\u043f\u0440\u0435\u0441\u0441'), (b'aeroexpress', '\u0410\u044d\u0440\u043e\u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441')])),
            ],
            options={
                'verbose_name': '\u043d\u043e\u043c\u0435\u0440 \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u0430',
                'verbose_name_plural': '\u043d\u043e\u043c\u0435\u0440\u0430 \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='ExpressTypeLite',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', common.utils.fields.TrimmedCharField(default=b'', max_length=100, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('code', common.utils.fields.TrimmedCharField(default=b'', max_length=40, verbose_name='\u041a\u043e\u0434', blank=True)),
                ('color', common.utils.fields.TrimmedCharField(default=b'', max_length=10, verbose_name='\u0426\u0432\u0435\u0442', blank=True)),
            ],
            options={
                'db_table': 'www_expresstypelite',
                'verbose_name': '\u043f\u043e\u0434\u0442\u0438\u043f \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u043e\u0432',
                'verbose_name_plural': '\u043f\u043e\u0434\u0442\u0438\u043f\u044b \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='ExternalDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=50, verbose_name='\u043a\u043e\u0434 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),
                ('reduced_tariff', models.FloatField(default=0, verbose_name='\u043c\u043d\u043e\u0436\u0438\u0442\u0435\u043b\u044c \u043b\u044c\u0433\u043e\u0442\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430')),
                ('use_synchronous_tariff', models.BooleanField(default=False, verbose_name='\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u043d\u044b\u0439 \u0442\u0430\u0440\u0438\u0444')),
                ('schema_file', common.utils.fields.TextFileField(help_text='\u043f\u0440\u0438\u043d\u0438\u043c\u0430\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u0432 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0435 cp1251', verbose_name='\u0444\u0430\u0439\u043b \u0441 \u043a\u0430\u0440\u0442\u043e\u0439 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True)),
                ('full_title', common.utils.fields.TrimmedCharField(default=None, max_length=100, verbose_name='\u043f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('full_title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('full_title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('full_title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('full_title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('title', common.utils.fields.TrimmedCharField(default=None, max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f (ru)', blank=True)),
                ('title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f (en)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f (tr)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f (uk)', blank=True)),
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_externaldirection',
                'verbose_name': '\u0432\u043d\u0435\u0448\u043d\u0435\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435',
                'verbose_name_plural': '\u0432\u043d\u0435\u0448\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='ExternalDirectionMarker',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('order', models.IntegerField(verbose_name='\u043f\u043e\u0440\u044f\u0434\u043e\u043a', db_index=True)),
                ('zone', common.utils.fields.TrimmedCharField(max_length=10, null=True, verbose_name='\u0442\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u0437\u043e\u043d\u0430', blank=True)),
                ('zgroup', common.utils.fields.TrimmedCharField(max_length=50, null=True, verbose_name='\u0442\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430', blank=True)),
                ('zprice', common.utils.fields.TrimmedCharField(max_length=50, null=True, verbose_name='\u0432\u044a\u0435\u0437\u0434 \u0432 \u0437\u043e\u043d\u0443', blank=True)),
                ('zprice_inner', common.utils.fields.TrimmedCharField(max_length=50, null=True, verbose_name='\u043f\u0440\u043e\u0435\u0437\u0434 \u0432\u043d\u0443\u0442\u0440\u0438 \u0437\u043e\u043d\u044b', blank=True)),
                ('zprice_exit', common.utils.fields.TrimmedCharField(max_length=50, null=True, verbose_name='\u0432\u044b\u0435\u0437\u0434 \u0438\u0437 \u0437\u043e\u043d\u044b \u0432 \u0441\u043e\u0441\u0435\u0434\u043d\u044e\u044e', blank=True)),
                ('branch', common.utils.fields.CodeCharField(max_length=50, null=True, verbose_name='\u0432\u0435\u0442\u043a\u0430', blank=True)),
                ('external_direction', models.ForeignKey(verbose_name='\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435', to='www.ExternalDirection')),
            ],
            options={
                'ordering': ('order',),
                'db_table': 'www_externaldirectionmarker',
                'verbose_name': '\u043c\u0430\u0440\u043a\u0435\u0440 \u0432\u043d\u0435\u0448\u043d\u0435\u0433\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                'verbose_name_plural': '\u043c\u0430\u0440\u043a\u0435\u0440\u044b \u0432\u043d\u0435\u0448\u043d\u0438\u0445 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='FaceDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('text', models.CharField(max_length=255, null=True, verbose_name='\u0422\u0435\u0441\u043a\u0442', blank=True)),
                ('url', models.TextField(null=True, verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430', blank=True)),
            ],
            options={
                'verbose_name': '\u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435',
                'verbose_name_plural': '\u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u043c\u043e\u0440\u0434\u0435 \u0433\u043e\u0440\u043e\u0434\u0430',
            },
        ),
        migrations.CreateModel(
            name='GortransCityLink',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('url', models.CharField(max_length=255, verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430')),
            ],
            options={
                'db_table': 'www_gortranscitylink',
                'verbose_name': '\u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0433\u043e\u0440\u0442\u0440\u0430\u043d\u0441',
                'verbose_name_plural': '\u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u0433\u043e\u0440\u0442\u0440\u0430\u043d\u0441',
            },
        ),
        migrations.CreateModel(
            name='Holiday',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u0441\u0447\u0438\u0442\u0430\u044e\u0449\u0430\u044f\u0441\u044f \u043f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u043e\u0439')),
                ('title', models.CharField(default=b'', help_text='\u043d\u0435\u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435', max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0430\u0437\u0434\u043d\u0438\u043a\u0430', blank=True)),
            ],
            options={
                'verbose_name': '\u043f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u044b\u0439 \u0434\u0435\u043d\u044c',
                'verbose_name_plural': '\u043f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u044b\u0435 \u0434\u043d\u0438',
            },
        ),
        migrations.CreateModel(
            name='NameSearchIndex',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('text', models.CharField(max_length=255, db_index=True)),
                ('exact', models.BooleanField()),
                ('object_id', models.PositiveIntegerField()),
                ('content_type', models.ForeignKey(to='contenttypes.ContentType')),
            ],
        ),
        migrations.CreateModel(
            name='NotTariffTrain',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', common.utils.fields.RegExpField(help_text='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430 \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0442\u044c \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u044b\u043c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c', unique=True, max_length=255, verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430')),
            ],
            options={
                'verbose_name': '\u043f\u043e\u0435\u0437\u0434, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435 \u0442\u0430\u0440\u0438\u0444\u0438\u0446\u0438\u0440\u0443\u0435\u0442 \u042d\u043a\u0441\u043f\u0440\u0435\u0441\u0441',
                'verbose_name_plural': '\u043f\u043e\u0435\u0437\u0434\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435 \u0442\u0430\u0440\u0438\u0444\u0438\u0446\u0438\u0440\u0443\u0435\u0442 \u042d\u043a\u0441\u043f\u0440\u0435\u0441\u0441',
            },
        ),
        migrations.CreateModel(
            name='Page',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=100, verbose_name='\u043a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b')),
                ('title', models.CharField(max_length=250, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b')),
            ],
            options={
                'verbose_name': '\u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430',
                'verbose_name_plural': '\u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b',
            },
        ),
        migrations.CreateModel(
            name='PlatformTranslation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('description', models.CharField(default=None, max_length=255, null=True, verbose_name='\u0413\u0434\u0435 \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f', blank=True)),
                ('platform', common.utils.fields.TrimmedCharField(default=None, max_length=30, null=True, verbose_name='\u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0430', blank=True)),
                ('platform_ru', common.utils.fields.TrimmedCharField(default=None, max_length=30, null=True, verbose_name='\u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0430 (ru)', blank=True)),
                ('platform_en', common.utils.fields.TrimmedCharField(default=None, max_length=30, null=True, verbose_name='\u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0430 (en)', blank=True)),
                ('platform_tr', common.utils.fields.TrimmedCharField(default=None, max_length=30, null=True, verbose_name='\u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0430 (tr)', blank=True)),
                ('platform_uk', common.utils.fields.TrimmedCharField(default=None, max_length=30, null=True, verbose_name='\u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0430 (uk)', blank=True)),
            ],
            options={
                'db_table': 'www_platformtranslation',
                'verbose_name': '\u041f\u0435\u0440\u0435\u0432\u043e\u0434 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b',
                'verbose_name_plural': '\u041f\u0435\u0440\u0435\u0432\u043e\u0434\u044b \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c',
            },
        ),
        migrations.CreateModel(
            name='PointSynonym',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u0441\u0438\u043d\u043e\u043d\u0438\u043c')),
                ('object_id', models.PositiveIntegerField()),
                ('search_type', models.CharField(default=b'synonym', max_length=20, editable=False, db_index=True, choices=[(b'synonym', '\u0441\u0438\u043d\u043e\u043d\u0438\u043c'), (b'normalized', '\u043d\u043e\u0440\u043c\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430'), (b'tokenized', '\u0442\u043e\u043a\u0435\u043d\u044b'), (b'exact', '\u0442\u043e\u0447\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f')])),
                ('content_type', models.ForeignKey(to='contenttypes.ContentType')),
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_pointsynonym',
                'verbose_name': '\u0441\u0438\u043d\u043e\u043d\u0438\u043c',
                'verbose_name_plural': '\u0441\u0438\u043d\u043e\u043d\u0438\u043c\u044b',
            },
        ),
        migrations.CreateModel(
            name='PreHoliday',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u0441\u0447\u0438\u0442\u0430\u044e\u0449\u0430\u044f\u0441\u044f \u043f\u0440\u0435\u0434\u043f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u043e\u0439')),
                ('title', models.CharField(default=b'', help_text='\u043d\u0435\u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435', max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0430\u0437\u0434\u043d\u0438\u043a\u0430', blank=True)),
            ],
            options={
                'verbose_name': '\u043f\u0440\u0435\u0434\u043f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u044b\u0439 \u0434\u0435\u043d\u044c',
                'verbose_name_plural': '\u043f\u0440\u0435\u0434\u043f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u044b\u0435 \u0434\u043d\u0438',
            },
        ),
        migrations.CreateModel(
            name='PseudoRegion',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=255, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('countries', models.ManyToManyField(to='www.Country', verbose_name='\u0441\u0442\u0440\u0430\u043d\u044b', blank=True)),
            ],
            options={
                'db_table': 'www_pseudoregion',
                'verbose_name': '\u043f\u0441\u0435\u0432\u0434\u043e-\u0440\u0435\u0433\u0438\u043e\u043d',
                'verbose_name_plural': '\u043f\u0441\u0435\u0432\u0434\u043e-\u0440\u0435\u0433\u0438\u043e\u043d\u044b',
            },
        ),
        migrations.CreateModel(
            name='Redirect',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('old_url', models.CharField(unique=True, max_length=100, verbose_name='\u0421\u0442\u0430\u0440\u044b\u0439 \u0430\u0434\u0440\u0435\u0441')),
                ('new_url', models.CharField(max_length=100, verbose_name='\u041d\u043e\u0432\u044b\u0439 \u0430\u0434\u0440\u0435\u0441')),
            ],
            options={
                'verbose_name': '\u0420\u0435\u0434\u0438\u0440\u0435\u043a\u0442',
                'verbose_name_plural': '\u0420\u0435\u0434\u0438\u0440\u0435\u043a\u0442\u044b',
            },
        ),
        migrations.CreateModel(
            name='Region',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('time_zone', models.CharField(help_text='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u0432 \u043c\u0435\u0436\u0434\u0443\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435', max_length=30, null=True, verbose_name='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430')),
                ('_geo_id', models.IntegerField(default=None, unique=True, null=True, verbose_name='geo ID', blank=True)),
                ('_kladr_id', models.CharField(default=None, editable=False, max_length=50, blank=True, null=True, verbose_name='kladr ID')),
                ('hidden', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0438\u0433\u0434\u0435!')),
                ('koatuu', common.utils.fields.CodeCharField(null=True, default=None, max_length=40, blank=True, help_text="\u0434\u0435\u0440\u0436\u0430\u0301\u0432\u043d\u0438\u0439 \u043a\u043b\u0430\u0441\u0438\u0444\u0456\u043a\u0430\u0301\u0442\u043e\u0440 \u043e\u0431'\u0454\u0301\u043a\u0442\u0456\u0432 \u0430\u0434\u043c\u0456\u043d\u0456\u0441\u0442\u0440\u0430\u0442\u0438\u0301\u0432\u043d\u043e-\u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0456\u0430\u0301\u043b\u044c\u043d\u043e\u0433\u043e \u0443\u0301\u0441\u0442\u0440\u043e\u044e \u0423\u043a\u0440\u0430\u0457\u0301\u043d\u0438", unique=True, verbose_name='\u043a\u043e\u0434 \u041a\u041e\u0410\u0422\u0423\u0423')),
                ('agent_geo_id', models.IntegerField(default=None, null=True, verbose_name='agent Geo ID', blank=True)),
                ('disputed_territory', models.BooleanField(default=False, verbose_name='\u0441\u043f\u043e\u0440\u043d\u0430\u044f \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f')),
                ('title', common.utils.fields.TrimmedCharField(default=None, max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('country', models.ForeignKey(verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430', to='www.Country')),
            ],
            options={
                'db_table': 'www_region',
                'verbose_name': '\u043e\u0431\u043b\u0430\u0441\u0442\u044c',
                'verbose_name_plural': '\u043e\u0431\u043b\u0430\u0441\u0442\u0438',
            },
            bases=(models.Model, common.models_utils.geo.TimeZoneMixin, common.models_utils.geo.Point),
        ),
        migrations.CreateModel(
            name='RegionWhiteList',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('regions', models.ManyToManyField(to='www.Region', verbose_name='\u043e\u0431\u043b\u0430\u0441\u0442\u0438', blank=True)),
            ],
            options={
                'verbose_name': '\u0431\u0435\u043b\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u043e\u0431\u043b\u0430\u0441\u0442\u0435\u0439 \u0434\u043b\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u0431\u0435\u043b\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u043e\u0431\u043b\u0430\u0441\u0442\u0435\u0439 \u0434\u043b\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='ReplaceException',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
            ],
            options={
                'db_table': 'www_replaceexception',
                'verbose_name': '\u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043b\u0434\u0443\u043d\u0441\u0442\u0432\u0430',
                'verbose_name_plural': '\u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a\u043e\u043b\u0434\u0443\u043d\u0441\u0442\u0432\u0430',
            },
        ),
        migrations.CreateModel(
            name='Route',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('comment', models.TextField(default='', null=True, verbose_name='\u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439', blank=True)),
                ('script_protected', models.BooleanField(default=True, verbose_name='\u043d\u0435 \u043c\u0435\u043d\u044f\u0442\u044c \u043f\u0440\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0435')),
                ('route_uid', models.CharField(help_text='\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0437\u043d\u0430\u0447\u043d\u043e\u0433\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u0440\u0435\u0439\u0441\u0430 \u0438\u0437 \u0438\u043c\u043f\u043e\u0440\u0442\u0430', max_length=100, verbose_name='\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440')),
                ('hidden', models.BooleanField(default=False, verbose_name='\u0440\u0435\u0439\u0441 \u0441\u043a\u0440\u044b\u0442')),
                ('style', models.TextField(default=None, null=True, verbose_name='\u0441\u0442\u0438\u043b\u044c \u043b\u0438\u043d\u0438\u0438 \u043c\u0435\u0442\u0440\u043e', blank=True)),
            ],
            options={
                'abstract': False,
                'db_table': 'www_route',
                'verbose_name': '\u0440\u0435\u0439\u0441',
                'verbose_name_plural': '\u0440\u0435\u0439\u0441\u044b',
            },
        ),
        migrations.CreateModel(
            name='Route2Company',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', models.CharField(max_length=100, verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430')),
                ('company', models.ForeignKey(verbose_name='\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f-\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a', to='www.Company')),
            ],
            options={
                'ordering': ('number', 'company'),
                'verbose_name': '\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u0440\u0435\u0439\u0441\u0430 \u0438 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438',
                'verbose_name_plural': '\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f \u043d\u043e\u043c\u0435\u0440\u043e\u0432 \u0416\u0414 \u0440\u0435\u0439\u0441\u043e\u0432 \u0438 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='RouteImportInfo',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', models.CharField(max_length=100, verbose_name='\u043d\u043e\u043c\u0435\u0440', db_index=True)),
                ('route_uid', models.CharField(null=True, default=None, max_length=100, blank=True, help_text='\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0437\u043d\u0430\u0447\u043d\u043e\u0433\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u0440\u0435\u0439\u0441\u0430 \u0438\u0437 \u0438\u043c\u043f\u043e\u0440\u0442\u0430', unique=True, verbose_name='\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440')),
            ],
            options={
                'ordering': ('supplier__id', 'number'),
                'verbose_name': '\u0434\u043e\u043f. \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0440\u0435\u0439\u0441\u0435',
                'verbose_name_plural': '\u0434\u043e\u043f. \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0440\u0435\u0439\u0441\u0435',
            },
        ),
        migrations.CreateModel(
            name='RouteMapBlacklist',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', common.utils.fields.TrimmedCharField(unique=True, max_length=100, verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430')),
            ],
            options={
                'verbose_name': '\u0440\u0435\u0439\u0441, \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u044b\u0439 \u043a \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044e \u043d\u0430 \u043a\u0430\u0440\u0442\u0435',
                'verbose_name_plural': '\u0440\u0435\u0439\u0441\u044b, \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u044b\u0435 \u043a \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044e \u043d\u0430 \u043a\u0430\u0440\u0442\u0435',
            },
        ),
        migrations.CreateModel(
            name='RouteNumberIndex',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', models.CharField(default='', max_length=100, verbose_name='\u043f\u0440\u043e\u0441\u0442\u043e \u041d\u043e\u043c\u0435\u0440', db_index=True)),
                ('reversed_number', models.CharField(verbose_name='\u043f\u0435\u0440\u0435\u0432\u0435\u0440\u043d\u0443\u0442\u044b\u0439 \u043d\u043e\u043c\u0435\u0440', max_length=100, editable=False, db_index=True)),
                ('route_uid', models.CharField(help_text='\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0437\u043d\u0430\u0447\u043d\u043e\u0433\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u0440\u0435\u0439\u0441\u0430 \u0438\u0437 \u0438\u043c\u043f\u043e\u0440\u0442\u0430', max_length=100, verbose_name='route_uid', db_index=True)),
                ('route', models.ForeignKey(verbose_name='\u043c\u0430\u0440\u0448\u0440\u0443\u0442', to='www.Route')),
            ],
            options={
                'verbose_name': '\u0438\u043d\u0434\u0435\u043a\u0441 \u0437\u0430\u043f\u0438\u0441\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442',
                'verbose_name_plural': '\u0441\u043b\u0438\u0442\u043d\u044b\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u043f\u043e \u0440\u0435\u0439\u0441\u0430\u043c',
            },
        ),
        migrations.CreateModel(
            name='RoutePath',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('for_two_directions', models.BooleanField(verbose_name='\u0434\u043b\u044f \u0434\u0432\u0443\u0445 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439')),
                ('data_direct', models.TextField(help_text='json-\u0434\u0430\u043d\u043d\u044b\u0435 \u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430', null=True, verbose_name='\u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u0440\u044f\u043c\u043e\u0433\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True)),
                ('data_back', models.TextField(help_text='json-\u0434\u0430\u043d\u043d\u044b\u0435 \u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430', null=True, verbose_name='\u0434\u0430\u043d\u043d\u044b\u0435 \u043e\u0431\u0440\u0430\u0442\u043d\u043e\u0433\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True)),
                ('status_direct', models.IntegerField(default=0, verbose_name='\u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u044f\u043c\u043e\u0433\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', choices=[(0, '\u043d\u0435 \u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043e'), (1, '\u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043e'), (2, '\u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043f\u0435\u0440\u0435\u0434\u0432\u0438\u043d\u0443\u0442\u044b')])),
                ('status_back', models.IntegerField(default=0, verbose_name='\u0441\u0442\u0430\u0442\u0443\u0441 \u043e\u0431\u0440\u0430\u0442\u043d\u043e\u0433\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', choices=[(0, '\u043d\u0435 \u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043e'), (1, '\u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043e'), (2, '\u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043f\u0435\u0440\u0435\u0434\u0432\u0438\u043d\u0443\u0442\u044b')])),
            ],
            options={
                'verbose_name': '\u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0443\u0447\u0430\u0441\u0442\u043e\u043a \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430',
                'verbose_name_plural': '\u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0443\u0447\u0430\u0441\u0442\u043a\u0438 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='RThread',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('old_thread_number', models.CharField(default=b'', max_length=100, verbose_name='\u0421\u0442\u0430\u0440\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043d\u0438\u0442\u043a\u0438', db_column=b'number', blank=True)),
                ('title', models.CharField(max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('is_manual_title', models.BooleanField(default=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0432\u0440\u0443\u0447\u043d\u0443\u044e')),
                ('title_tr', common.utils.fields.TrimmedCharField(db_index=True, max_length=100, null=True, verbose_name='Turkish title', blank=True)),
                ('title_tr_author', common.utils.fields.CodeCharField(max_length=100, null=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(db_index=True, max_length=100, null=True, verbose_name='\u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0435 \u0440\u0443\u0447\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('title_uk_author', common.utils.fields.CodeCharField(max_length=100, null=True)),
                ('title_common', models.CharField(max_length=500, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('title_short', models.CharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435', blank=True)),
                ('uid', models.CharField(null=True, max_length=100, blank=True, help_text='\u0440\u0430\u0441\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u0441\u043a\u0440\u0438\u043f\u0442\u043e\u043c', unique=True, verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0432 \u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0435')),
                ('tz_start_time', models.TimeField(verbose_name='\u0432\u0440\u0435\u043c\u044f \u0432\u044b\u0435\u0437\u0434\u0430(\u0432\u044b\u043b\u0435\u0442\u0430) \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0437\u043e\u043d\u044b')),
                ('time_zone', models.CharField(max_length=30, verbose_name='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430')),
                ('period_int', models.IntegerField(default=None, null=True, verbose_name='\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043c\u0435\u0436\u0434\u0443 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\u043c\u0438 \u0440\u0435\u0439\u0441\u043e\u0432, \u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445', blank=True)),
                ('begin_time', models.TimeField(default=None, null=True, verbose_name='\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430', blank=True)),
                ('end_time', models.TimeField(default=None, null=True, verbose_name='\u041a\u043e\u043d\u0435\u0446 \u043f\u0435\u0440\u0438\u043e\u0434\u0430', blank=True)),
                ('density', common.utils.fields.TrimmedCharField(default=b'', max_length=200, verbose_name='\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0441\u0442\u044c \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0432 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0435', blank=True)),
                ('pseudo_data', models.TextField(default=b'', verbose_name='\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0442\u043d\u044b\u0445 \u043f\u0441\u0435\u0432\u0434\u043e\u0440\u0435\u0439\u0441\u043e\u0432', blank=True)),
                ('comment', common.utils.fields.TrimmedTextField(default=b'', verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439', blank=True)),
                ('year_days', common.utils.fields.ThreadCalendarField(default=b'000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', verbose_name='\u0434\u043d\u0438 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0439', db_column=b'tz_year_days')),
                ('has_extrapolatable_mask', models.BooleanField(default=True, verbose_name='\u044d\u043a\u0441\u0442\u0440\u0430\u043f\u043e\u043b\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u0434\u043d\u0438 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f')),
                ('changed', models.BooleanField(default=False, verbose_name='\u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c \u043f\u0435\u0440\u0435\u0441\u0447\u0435\u0442 \u0442\u0430\u0431\u043b\u043e \u0438 \u043f\u043e\u0438\u0441\u043a\u0430')),
                ('path_and_time_unchanged', models.BooleanField(default=False, help_text='\u043c\u043e\u0436\u043d\u043e \u043d\u0435 \u043f\u0435\u0440\u0435\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u043d\u043e\u0434\u0435\u0440\u043e\u0442', verbose_name='\u041f\u0443\u0442\u044c \u0438 \u0432\u0440\u0435\u043c\u044f \u043d\u0435 \u043c\u0435\u043d\u044f\u043b\u0438\u0441\u044c')),
                ('recount_station_schedule', models.BooleanField(default=False, verbose_name='\u043f\u0435\u0440\u0435\u0441\u0447\u0438\u0442\u0430\u0442\u044c \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u044f\u0445')),
                ('template_text', models.CharField(default=None, max_length=200, blank=True, help_text='\u0448\u0430\u0431\u043b\u043e\u043d\u044b \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0439 \u0447\u0435\u0440\u0435\u0437 \u0442\u043e\u0447\u043a\u0443 \u0441 \u0437\u0430\u043f\u044f\u0442\u043e\u0439, \u0435\u0441\u043b\u0438 \u0435\u0441\u0442\u044c \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0441\u0443\u0442\u043e\u043a \u0432 \u0440\u0435\u0439\u0441\u0435, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, "\u0435\u0436\u0435\u0434\u043d\u0435\u0432\u043d\u043e;\u0435\u0436\u0435\u0434\u043d\u0435\u0432\u043d\u043e".', null=True, verbose_name='\u0422\u0435\u043a\u0441\u0442 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0439(\u0441\u0442\u0430\u0440\u043e\u0435)')),
                ('template_start', models.DateField(null=True, verbose_name='\u041d\u0430\u0447\u0430\u043b\u043e \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430', blank=True)),
                ('template_end', models.DateField(null=True, verbose_name='\u041a\u043e\u043d\u0435\u0446 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430', blank=True)),
                ('template_code', models.CharField(default=None, max_length=100, null=True, verbose_name='\u041a\u043e\u0434 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0439', blank=True)),
                ('translated_manual_days_texts', models.TextField(default=b'', verbose_name='\u0422\u0435\u043a\u0441\u0442\u044b \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 \u043a\u043e\u0434\u0430 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0410.\u0424.', blank=True)),
                ('translated_days_texts', models.TextField(default=b'', verbose_name='\u041f\u0440\u0435\u0434\u0440\u0430\u0441\u0447\u0438\u0442\u0430\u043d\u043d\u044b\u0435 \u0442\u0435\u043a\u0441\u0442\u044b \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f', blank=True)),
                ('translated_except_texts', models.TextField(default=b'', verbose_name='\u041f\u0440\u0435\u0434\u0440\u0430\u0441\u0447\u0438\u0442\u0430\u043d\u043d\u044b\u0435 \u0442\u0435\u043a\u0441\u0442\u044b \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f', blank=True)),
                ('import_uid', models.CharField(null=True, default=None, editable=False, max_length=255, blank=True, unique=True, verbose_name='\u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043d\u0438\u0442\u043a\u0438 \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c\u044b\u0439 \u043d\u0430 \u043e\u0441\u043d\u043e\u0432\u0435 \u0440\u0435\u0439\u0441\u0430 \u043d\u0438\u0442\u043a\u0438')),
                ('is_circular', models.BooleanField(default=False, verbose_name='\u043d\u0438\u0442\u043a\u0430 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u043e\u043b\u044c\u0446\u0435\u0432\u043e\u0439')),
                ('hidden', models.BooleanField(default=False, verbose_name='\u043d\u0438\u0442\u043a\u0430 \u0441\u043a\u0440\u044b\u0442\u0430')),
                ('is_combined', models.BooleanField(default=False, verbose_name='\u041d\u0438\u0442\u043a\u0430 \u0441\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0435\u0437\u0434\u0430')),
                ('show_in_alldays_pages', models.BooleanField(default=True, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0432 \u043f\u043e\u0438\u0441\u043a\u0435 \u0438 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438 \u043d\u0430 \u0432\u0441\u0435 \u0434\u043d\u0438')),
                ('number', models.CharField(db_column=b'route_number', default='', max_length=100, blank=True, verbose_name='\u043d\u043e\u043c\u0435\u0440', db_index=True)),
                ('hidden_number', models.CharField(default='', max_length=100, verbose_name='\u0441\u043a\u0440\u044b\u0442\u044b\u0439 \u043d\u043e\u043c\u0435\u0440', blank=True)),
                ('express_type', models.CharField(default=None, choices=[(b'', '\u041e\u0431\u044b\u0447\u043d\u044b\u0439 \u0440\u0435\u0439\u0441'), (b'express', '\u042d\u043a\u0441\u043f\u0440\u0435\u0441\u0441'), (b'aeroexpress', '\u0410\u044d\u0440\u043e\u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441')], max_length=20, blank=True, null=True, verbose_name='\u0442\u0438\u043f \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u0430')),
                ('reversed_number', models.CharField(default='', verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430', max_length=100, editable=False, db_index=True)),
                ('ordinal_number', models.PositiveIntegerField(verbose_name='\u041f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043d\u0438\u0442\u043a\u0438, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 uid')),
                ('path_key', models.TextField(default=None, null=True, verbose_name='\u041a\u043b\u044e\u0447 \u043f\u0443\u0442\u0438', blank=True)),
                ('basic_thread', models.ForeignKey(related_name='thread_changes', default=None, blank=True, to='www.RThread', null=True, verbose_name='\u043e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u043d\u0438\u0442\u043a\u0430')),
                ('company', models.ForeignKey(default=None, blank=True, to='www.Company', null=True, verbose_name='\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f-\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a')),
                ('express_lite', models.ForeignKey(default=None, blank=True, to='www.ExpressTypeLite', null=True, verbose_name='\u043f\u043e\u0434\u0442\u0438\u043f \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u0430')),
                ('route', models.ForeignKey(verbose_name='\u0440\u0435\u0439\u0441', to='www.Route')),
            ],
            options={
                'abstract': False,
                'db_table': 'www_rthread',
                'verbose_name': '\u043d\u0438\u0442\u043a\u0430',
                'verbose_name_plural': '\u043d\u0438\u0442\u043a\u0438',
            },
        ),
        migrations.CreateModel(
            name='RThreadType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('code', models.CharField(unique=True, max_length=100, verbose_name='\u043a\u043e\u0434')),
            ],
            options={
                'ordering': ('id',),
                'db_table': 'www_rthreadtype',
                'verbose_name': '\u0442\u0438\u043f \u043d\u0438\u0442\u043a\u0438',
                'verbose_name_plural': '\u0442\u0438\u043f\u044b \u043d\u0438\u0442\u043e\u043a',
            },
        ),
        migrations.CreateModel(
            name='RTStation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('tz_arrival', models.IntegerField(help_text='\u0440\u0430\u0441\u0441\u0442. \u043e\u0442 \u043d\u0430\u0447. \u043c\u0430\u0440\u0448\u0440. \u0434\u043e \u043f\u0440\u0438\u0431. (\u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445). \u041f\u0440\u0438\u0431\u044b\u0442\u0438\u0435 \u043d\u0430 \u043f\u0435\u0440\u0432\u0443\u044e \u0441\u0442\u0430\u043d\u0446\u0438\u044e \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f(\u043e\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c)', null=True, blank=True)),
                ('tz_departure', models.IntegerField(help_text='\u0440\u0430\u0441\u0441\u0442. \u043e\u0442 \u043d\u0430\u0447. \u043c\u0430\u0440\u0448\u0440. \u0434\u043e \u043e\u0442\u043f\u0440. (\u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445). \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f(\u043e\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c)', null=True, blank=True)),
                ('time_zone', models.CharField(max_length=30, verbose_name='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430')),
                ('arrival_code_sharing', models.BooleanField(default=False, verbose_name='\u043f\u0440\u0438\u0431\u044b\u0442\u0438\u0435 code sharing')),
                ('departure_code_sharing', models.BooleanField(default=False, verbose_name='\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 code sharing')),
                ('arrival_subdir', models.CharField(max_length=100, null=True, verbose_name='arr_subdir', blank=True)),
                ('departure_subdir', models.CharField(max_length=100, null=True, verbose_name='dep_subdir', blank=True)),
                ('is_from_subdir', models.BooleanField(default=True, help_text='\u043e\u0442 \u041c\u043e\u0441\u043a\u0432\u044b', verbose_name='\u043f\u043e\u0434\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 "\u0442\u0443\u0434\u0430"')),
                ('is_technical_stop', models.BooleanField(default=False, help_text='\u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430', verbose_name='\u0422\u041e')),
                ('platform', common.utils.fields.TrimmedCharField(default=None, max_length=20, null=True, verbose_name='\u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0430', blank=True)),
                ('is_virtual_end', models.BooleanField(default=False, verbose_name='\u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439 \u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0439 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u043e\u0439')),
                ('is_fuzzy', models.BooleanField(default=False, verbose_name='\u043d\u0435\u0447\u0435\u0442\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f/\u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f')),
                ('is_searchable_to', models.BooleanField(default=True, verbose_name='\u0438\u0441\u043a\u0430\u0442\u044c \u0434\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),
                ('is_searchable_from', models.BooleanField(default=True, verbose_name='\u0438\u0441\u043a\u0430\u0442\u044c \u043e\u0442 \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),
                ('in_station_schedule', models.BooleanField(default=True, verbose_name='\u0432 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438 \u043f\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),
                ('in_thread', models.BooleanField(default=True, verbose_name='\u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0438\u0442\u043a\u0438')),
                ('is_combined', models.BooleanField(default=False, verbose_name='\u0421\u0442\u0430\u043d\u0446\u0438\u044f \u0441\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u0441\u0430\u0434\u043a\u0438')),
                ('arrival_direction', models.ForeignKey(related_name='arrival_rtstation_set', blank=True, to='www.Direction', help_text='\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', null=True, verbose_name='arr_direction')),
            ],
            options={
                'ordering': ('id',),
                'db_table': 'www_rtstation',
                'verbose_name': '\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043d\u0438\u0442\u043a\u0438',
                'verbose_name_plural': '\u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043d\u0438\u0442\u043e\u043a',
            },
        ),
        migrations.CreateModel(
            name='ScheduleExclusion',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', common.utils.fields.TrimmedCharField(help_text='\u0415\u0441\u043b\u0438 \u043d\u043e\u043c\u0435\u0440\u0430 \u043d\u0435\u0442, \u0431\u0435\u0440\u0443\u0442\u0441\u044f \u0432\u0441\u0435 \u0440\u0435\u0439\u0441\u044b \u043c\u0435\u0436\u0434\u0443 \u0441\u0442\u0430\u043d\u0446\u0438\u044f\u043c\u0438', max_length=255, null=True, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430', blank=True)),
                ('departure', models.TimeField(null=True, verbose_name='\u041e\u043f\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', blank=True)),
                ('departure_interval', models.TimeField(default=None, null=True, verbose_name='\u041a\u043e\u043d\u0435\u0446 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True)),
            ],
            options={
                'db_table': 'importinfo_scheduleexclusion',
                'verbose_name': '\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043f\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0438\u0437 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043f\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438',
            },
        ),
        migrations.CreateModel(
            name='Setting',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', common.utils.fields.TrimmedCharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('code', common.utils.fields.CodeCharField(max_length=255, verbose_name='\u041a\u043e\u0434', validators=[django.core.validators.RegexValidator('(?u)^[A-Z][A-Z_0-9]*$', '\u041a\u043e\u0434 \u0434\u043e\u043b\u0436\u0435\u043d \u043d\u0430\u0447\u0438\u043d\u0430\u0442\u044c\u0441\u044f \u0441 \u0431\u0443\u043a\u0432\u044b, \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b [A-Z_0-9]')])),
                ('type', models.CharField(default=b'str', max_length=20, verbose_name='\u0422\u0438\u043f', choices=[(b'int', '\u0426\u0435\u043b\u043e\u0435'), (b'float', '\u0427\u0438\u0441\u043b\u043e \u0441 \u043f\u043b\u0430\u0432\u0430\u044e\u0449\u0435\u0439 \u0442\u043e\u0447\u043a\u043e\u0439'), (b'str', '\u0421\u0442\u0440\u043e\u043a\u0430')])),
                ('value', models.CharField(default=b'', max_length=1024, verbose_name='\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435', blank=True)),
                ('help_text', models.TextField(default=b'', max_length=1024, null=True, verbose_name='\u041f\u043e\u0434\u0441\u043a\u0430\u0437\u043a\u0430', blank=True)),
            ],
            options={
                'verbose_name': '\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430',
                'verbose_name_plural': '\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438',
            },
        ),
        migrations.CreateModel(
            name='Settlement',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('suggest_order', models.IntegerField(default=100, help_text='\u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0432\u044b\u0432\u043e\u0434\u044f\u0442\u0441\u044f \u0433\u043e\u0440\u043e\u0434\u0430 \u0441 \u043c\u0435\u043d\u044c\u0448\u0438\u043c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u043c', verbose_name='\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0432 \u0441\u0430\u0434\u0436\u0435\u0441\u0442\u0430\u0445')),
                ('title_ru_preposition_v_vo_na', common.utils.fields.TrimmedCharField(default=None, max_length=2, null=True, verbose_name='\u043f\u0440\u0435\u0434\u043b\u043e\u0433 (\u0432, \u0432\u043e, \u043d\u0430)', blank=True)),
                ('title_ru_genitive', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u0440\u043e\u0434. \u043f\u0430\u0434\u0435\u0436)', blank=True)),
                ('title_ru_accusative', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u0432\u0438\u043d. \u043f\u0430\u0434\u0435\u0436)', blank=True)),
                ('title_ru_locative', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u043c\u0435\u0441\u0442\u043d. \u043f\u0430\u0434\u0435\u0436)', blank=True)),
                ('time_zone', models.CharField(help_text='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u0432 \u043c\u0435\u0436\u0434\u0443\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435', max_length=30, verbose_name='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430')),
                ('phone_info', models.CharField(default=None, max_length=20, null=True, verbose_name='\u0442\u0435\u043b. \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u043e\u0439', blank=True)),
                ('phone_info_short', models.CharField(default=None, max_length=20, null=True, verbose_name='\u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0439 \u0442\u0435\u043b. \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u043e\u0439', blank=True)),
                ('_geo_id', models.IntegerField(default=None, unique=True, null=True, verbose_name='geo ID', blank=True)),
                ('_kladr_id', models.CharField(default=None, editable=False, max_length=50, blank=True, null=True, verbose_name='kladr ID')),
                ('sirena_id', common.utils.fields.CodeCharField(null=True, default=None, max_length=50, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u0432 "Sirena"')),
                ('iata', common.utils.fields.CodeCharField(null=True, default=None, max_length=20, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 IATA')),
                ('koatuu', common.utils.fields.CodeCharField(null=True, default=None, max_length=40, blank=True, help_text="\u0434\u0435\u0440\u0436\u0430\u0301\u0432\u043d\u0438\u0439 \u043a\u043b\u0430\u0441\u0438\u0444\u0456\u043a\u0430\u0301\u0442\u043e\u0440 \u043e\u0431'\u0454\u0301\u043a\u0442\u0456\u0432 \u0430\u0434\u043c\u0456\u043d\u0456\u0441\u0442\u0440\u0430\u0442\u0438\u0301\u0432\u043d\u043e-\u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0456\u0430\u0301\u043b\u044c\u043d\u043e\u0433\u043e \u0443\u0301\u0441\u0442\u0440\u043e\u044e \u0423\u043a\u0440\u0430\u0457\u0301\u043d\u0438", unique=True, verbose_name='\u043a\u043e\u0434 \u041a\u041e\u0410\u0422\u0423\u0423')),
                ('big_city', models.BooleanField(default=False, verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043d\u0430 \u0443\u0440\u043e\u0432\u043d\u0435 \u0441\u0442\u043e\u043b\u0438\u0446\u044b')),
                ('hidden', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0438\u0433\u0434\u0435!')),
                ('service_comment', models.TextField(default=None, help_text='\u043d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u0432 \u0441\u0435\u0440\u0432\u0438\u0441\u0435', null=True, verbose_name='\u0441\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0439 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439', blank=True)),
                ('has_tablo', models.BooleanField(default=True, verbose_name='\u0433\u043e\u0440\u043e\u0434 \u0438\u043c\u0435\u0435\u0442 \u0442\u0430\u0431\u043b\u043e')),
                ('agent_geo_id', models.IntegerField(default=None, null=True, verbose_name='agent Geo ID', blank=True)),
                ('has_many_airports', models.BooleanField(default=False, verbose_name='\u043c\u043d\u043e\u0433\u043e \u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442\u043e\u0432')),
                ('has_urban_transport', models.BooleanField(default=False, verbose_name='\u0435\u0441\u0442\u044c \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442')),
                ('human_url', common.utils.fields.CodeCharField(null=True, default=None, max_length=50, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u0433\u043e\u0440\u043e\u0434\u0430 \u0434\u043b\u044f \u0427\u041f\u0423')),
                ('threads_amount', models.PositiveIntegerField(default=0, verbose_name='\u043e\u0431\u0449\u0435\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0440\u0435\u0439\u0441\u043e\u0432 \u0432 \u0442\u0430\u0431\u043b\u043e', editable=False)),
                ('type_choices', models.CharField(default=b'', max_length=50, verbose_name='\u0442\u0438\u043f\u044b \u0422\u0421', blank=True)),
                ('longitude', models.FloatField(default=None, null=True, verbose_name='\u0434\u043e\u043b\u0433\u043e\u0442\u0430', db_index=True, blank=True)),
                ('latitude', models.FloatField(default=None, null=True, verbose_name='\u0448\u0438\u0440\u043e\u0442\u0430', db_index=True, blank=True)),
                ('_disputed_territory', models.BooleanField(default=False, verbose_name='\u0441\u043f\u043e\u0440\u043d\u0430\u044f \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f', db_column=b'disputed_territory')),
                ('title', common.utils.fields.TrimmedCharField(default=None, max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435', db_index=True)),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', db_index=True)),
                ('title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', db_index=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', db_index=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', db_index=True)),
                ('abbr_title', common.utils.fields.TrimmedCharField(default=None, max_length=4, blank=True, help_text='\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c 4 \u0441\u0438\u043c\u0432\u043e\u043b\u0430', null=True, verbose_name='\u0441\u043e\u043a\u0440. \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('abbr_title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=4, blank=True, help_text='\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c 4 \u0441\u0438\u043c\u0432\u043e\u043b\u0430', null=True, verbose_name='\u0441\u043e\u043a\u0440. \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)')),
                ('abbr_title_en', common.utils.fields.TrimmedCharField(default=None, max_length=4, blank=True, help_text='\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c 4 \u0441\u0438\u043c\u0432\u043e\u043b\u0430', null=True, verbose_name='\u0441\u043e\u043a\u0440. \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)')),
                ('abbr_title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=4, blank=True, help_text='\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c 4 \u0441\u0438\u043c\u0432\u043e\u043b\u0430', null=True, verbose_name='\u0441\u043e\u043a\u0440. \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)')),
                ('abbr_title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=4, blank=True, help_text='\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c 4 \u0441\u0438\u043c\u0432\u043e\u043b\u0430', null=True, verbose_name='\u0441\u043e\u043a\u0440. \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)')),
                ('country', models.ForeignKey(default=None, blank=True, to='www.Country', null=True, verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430')),
                ('district', models.ForeignKey(related_name='settlements', default=None, blank=True, to='www.District', null=True, verbose_name='\u0440\u0430\u0439\u043e\u043d')),
                ('majority', models.ForeignKey(default=None, blank=True, to='www.CityMajority', null=True, verbose_name='\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u0433\u043e\u0440\u043e\u0434\u0430')),
            ],
            options={
                'db_table': 'www_settlement',
                'verbose_name': '\u0433\u043e\u0440\u043e\u0434',
                'verbose_name_plural': '\u0433\u043e\u0440\u043e\u0434\u0430',
            },
            bases=(models.Model, common.models_utils.geo.TimeZoneMixin, common.models_utils.geo.TransLocalMixin, common.models_utils.geo.Point),
        ),
        migrations.CreateModel(
            name='SettlementCode',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', common.utils.fields.CodeCharField(max_length=50, verbose_name='\u043a\u043e\u0434', db_index=True)),
                ('settlement', models.ForeignKey(related_name='code_set', verbose_name='\u0433\u043e\u0440\u043e\u0434', to='www.Settlement')),
                ('system', models.ForeignKey(verbose_name='\u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f', to='www.CodeSystem')),
            ],
            options={
                'ordering': ('settlement__id',),
                'db_table': 'www_settlementcode',
                'verbose_name': '\u043a\u043e\u0434 \u0433\u043e\u0440\u043e\u0434\u0430',
                'verbose_name_plural': '\u043a\u043e\u0434\u044b \u0433\u043e\u0440\u043e\u0434\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='SettlementNearest',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('description', models.TextField(null=True, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0435\u0437\u0434\u0430', blank=True)),
                ('nearest', models.ForeignKey(related_name='related_nearest', verbose_name='\u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0438\u0439', to='www.Settlement')),
                ('settlement', models.ForeignKey(related_name='related_settlement', verbose_name='\u0433\u043e\u0440\u043e\u0434', to='www.Settlement')),
            ],
            options={
                'db_table': 'www_settlementnearest',
                'verbose_name': '\u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0438\u0439 \u0433\u043e\u0440\u043e\u0434',
                'verbose_name_plural': '\u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0438\u0435 \u0433\u043e\u0440\u043e\u0434\u0430',
            },
        ),
        migrations.CreateModel(
            name='SettlementProperty',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('description', models.TextField(default=None, null=True, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_settlementproperty',
                'verbose_name': '\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e \u0433\u043e\u0440\u043e\u0434\u0430',
                'verbose_name_plural': '\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0433\u043e\u0440\u043e\u0434\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='SettlementRelatedStations',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('settlement', models.ForeignKey(related_name='related_stations', verbose_name='\u0433\u043e\u0440\u043e\u0434', to='www.Settlement')),
            ],
            options={
                'ordering': ('settlement', 'station'),
                'db_table': 'www_settlement_related_stations',
                'verbose_name': '\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0438 \u0433\u043e\u0440\u043e\u0434\u0430 \u0434\u043b\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f',
                'verbose_name_plural': '\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u0439 \u0438 \u0433\u043e\u0440\u043e\u0434\u043e\u0432 \u0434\u043b\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='SpecialOffer',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('tariff', models.FloatField(verbose_name='\u0426\u0435\u043d\u0430')),
                ('service_class', models.CharField(default=b'e', max_length=1, verbose_name='\u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f', choices=[(b'e', '\u042d\u043a\u043e\u043d\u043e\u043c'), (b'b', '\u0411\u0438\u0437\u043d\u0435\u0441'), (b'f', '\u041f\u0435\u0440\u0432\u044b\u0439')])),
                ('date_start', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f')),
                ('date_end', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f')),
                ('period_start', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0438\u044f')),
                ('period_end', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0438\u044f')),
                ('reverse', models.BooleanField(default=False, verbose_name='\u0442\u0443\u0434\u0430-\u043e\u0431\u0440\u0430\u0442\u043d\u043e')),
                ('online_booking', models.BooleanField(default=False, verbose_name='\u043e\u043d\u043b\u0430\u0439\u043d \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('tariff_code', common.utils.fields.TrimmedCharField(default=b'', max_length=20, verbose_name='\u043a\u043e\u0434 \u0442\u0430\u0440\u0438\u0444\u0430', blank=True)),
                ('text', models.TextField(default=b'', verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
            ],
            options={
                'verbose_name': '\u0421\u043f\u0435\u0446\u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043d\u0430 \u0410\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442\u044b',
                'verbose_name_plural': '\u0421\u043f\u0435\u0446\u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043d\u0430 \u0410\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442\u044b',
            },
        ),
        migrations.CreateModel(
            name='Station',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title_ru_preposition_v_vo_na', common.utils.fields.TrimmedCharField(default=None, max_length=2, blank=True, help_text='\u0432, \u0432\u043e, \u043d\u0430 \u2013 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435: \u043a\u0443\u0434\u0430? (\u0432\u043e \u0412\u043b\u0430\u0434\u0438\u043c\u0438\u0440, \u043d\u0430 \u0443\u043b. \u041f\u0443\u0448\u043a\u0438\u043d\u0430)', null=True, verbose_name='\u043f\u0440\u0435\u0434\u043b\u043e\u0433 (\u0432, \u0432\u043e, \u043d\u0430)')),
                ('title_ru_genitive', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043e\u0442\u043a\u0443\u0434\u0430? - \u043e\u0442 (\u043a\u043e\u0433\u043e? \u0447\u0435\u0433\u043e?) \u041c\u043e\u0441\u043a\u0432\u044b, \u0438\u0437 (\u043a\u043e\u0433\u043e? \u0447\u0435\u0433\u043e?) \u041c\u043e\u0441\u043a\u0432\u044b, \u0442\u0430\u0431\u043b\u043e (\u043a\u043e\u0433\u043e? \u0447\u0435\u0433\u043e?) \u041c\u043e\u0441\u043a\u0432\u044b', null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u0440\u043e\u0434. \u043f\u0430\u0434\u0435\u0436)')),
                ('title_ru_accusative', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043a\u0443\u0434\u0430? - \u0432 (\u043a\u043e\u0433\u043e? \u0447\u0442\u043e?) \u041c\u043e\u0441\u043a\u0432\u0443', null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u0432\u0438\u043d. \u043f\u0430\u0434\u0435\u0436)')),
                ('title_ru_locative', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u0433\u0434\u0435? - \u0432 (\u043a\u043e\u043c? \u0447\u0435\u043c?) \u041c\u043e\u0441\u043a\u0432\u0435', null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u043f\u0440\u0435\u0434. \u043f\u0430\u0434\u0435\u0436)')),
                ('popular_title_ru_genitive', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043e\u0442\u043a\u0443\u0434\u0430? - \u043e\u0442 (\u043a\u043e\u0433\u043e? \u0447\u0435\u0433\u043e?) \u041c\u043e\u0441\u043a\u0432\u044b, \u0438\u0437 (\u043a\u043e\u0433\u043e? \u0447\u0435\u0433\u043e?) \u041c\u043e\u0441\u043a\u0432\u044b, \u0442\u0430\u0431\u043b\u043e (\u043a\u043e\u0433\u043e? \u0447\u0435\u0433\u043e?) \u041c\u043e\u0441\u043a\u0432\u044b', null=True, verbose_name='\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u0440\u043e\u0434. \u043f\u0430\u0434\u0435\u0436)', db_index=True)),
                ('type_choices', common.utils.fields.TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u0442\u0438\u043f\u044b \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0442\u0430\u0431\u043b\u043e/\u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f', blank=True)),
                ('hidden', models.BooleanField(default=False, help_text='\u043d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0438\u0433\u0434\u0435, \u043a\u0440\u043e\u043c\u0435 \u0440\u0435\u0439\u0441\u043e\u0432 \u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f. \u041d\u0435 \u0434\u0430\u0432\u0430\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443 \u0432 \u0440\u0435\u0439\u0441\u0435 \u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f.', verbose_name='\u0441\u043a\u0440\u044b\u0442\u0430')),
                ('express_id', common.utils.fields.CodeCharField(null=True, default=None, editable=False, max_length=50, blank=True, unique=True)),
                ('sirena_id', common.utils.fields.CodeCharField(null=True, default=None, editable=False, max_length=10, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u0432 "Sirena"')),
                ('time_zone', models.CharField(blank=True, help_text='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u0432 \u043c\u0435\u0436\u0434\u0443\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435', max_length=30, verbose_name='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430')),
                ('time_zone_not_check', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u0441\u0432\u0435\u0440\u044f\u0442\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e \u0437\u043e\u043d\u0443 \u0441 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u043c \u0440\u0435\u0433\u0438\u043e\u043d\u043e\u043c')),
                ('site_url', models.URLField(default=None, max_length=100, null=True, verbose_name='\u0443\u0440\u043b \u0441\u0430\u0439\u0442\u0430', blank=True)),
                ('_majority', models.IntegerField(default=None, null=True, verbose_name='\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c', blank=True)),
                ('not_generalize', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043e\u0431\u043e\u0431\u0449\u0430\u0442\u044c \u0434\u043e \u0433\u043e\u0440\u043e\u0434\u0430 \u043f\u0440\u0438 \u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0438 \u0440\u0435\u0439\u0441\u043e\u0432')),
                ('longitude', models.FloatField(default=None, null=True, verbose_name='\u0434\u043e\u043b\u0433\u043e\u0442\u0430', db_index=True, blank=True)),
                ('latitude', models.FloatField(default=None, null=True, verbose_name='\u0448\u0438\u0440\u043e\u0442\u0430', db_index=True, blank=True)),
                ('map_zoom', models.IntegerField(default=None, null=True, verbose_name='\u043c\u0430\u0441\u0448\u0442\u0430\u0431 \u043a\u0430\u0440\u0442\u044b', blank=True)),
                ('use_direction', models.CharField(default=b'subdir', max_length=10, verbose_name='\u0441\u0432\u044f\u0437\u044c \u0441 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\u043c\u0438', blank=True, choices=[(b'', '\u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f'), (b'dir', '\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f'), (b'subdir', '\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u043f\u043e\u0434\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')])),
                ('has_aeroexpress', models.BooleanField(default=False, verbose_name='\u043f\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0445\u043e\u0434\u044f\u0442 \u0430\u044d\u0440\u043e\u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u044b')),
                ('near_metro', models.CharField(default=None, max_length=25, null=True, verbose_name='\u0440\u044f\u0434\u043e\u043c \u0441 \u043c\u0435\u0442\u0440\u043e', blank=True)),
                ('last_change', models.DateTimeField(default=None, help_text='\u0432\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u0440\u0443\u0447\u043d\u043e\u0439 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435 \u0430\u0434\u0440\u0435\u0441\u0430, \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0439 \u0438 \u0442\u0434.', null=True, verbose_name='\u0434\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438', blank=True)),
                ('photo', models.ImageField(default=None, upload_to=b'data/station/photo', null=True, verbose_name='\u0444\u043e\u0442\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438', blank=True)),
                ('schema_image', models.ImageField(default=None, upload_to=b'data/station/schema_image', null=True, verbose_name='\u0421\u0445\u0435\u043c\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', blank=True)),
                ('panorama_url', models.URLField(null=True, verbose_name='\u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u043f\u0430\u043d\u043e\u0440\u0430\u043c\u0443', blank=True)),
                ('show_settlement', models.BooleanField(default=True, help_text='\u043f\u0438\u0441\u0430\u0442\u044c \u043b\u0438 \u043f\u0435\u0440\u0435\u0434 \u0430\u0434\u0440\u0435\u0441\u043e\u043c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u043e\u0440\u043e\u0434\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', verbose_name='\u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0433\u043e\u0440\u043e\u0434 \u0432 \u0430\u0434\u0440\u0435\u0441\u0435')),
                ('tablo_state', models.CharField(default=b'', max_length=10, verbose_name='\u0442\u0430\u0431\u043b\u043e', blank=True, choices=[(b'', '\u043d\u0435\u0442 \u0442\u0430\u0431\u043b\u043e'), (b'statuses', '\u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u044b'), (b'real', '\u0441\u0442\u0430\u0442\u0443\u0441\u044b \u0438 \u0432\u0440\u0435\u043c\u044f'), (b'nodata', '\u043d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445')])),
                ('tablo_state_prev', models.CharField(default=b'', max_length=10, verbose_name='\u0442\u0430\u0431\u043b\u043e (\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435)', blank=True, choices=[(b'', '\u043d\u0435\u0442 \u0442\u0430\u0431\u043b\u043e'), (b'statuses', '\u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u044b'), (b'real', '\u0441\u0442\u0430\u0442\u0443\u0441\u044b \u0438 \u0432\u0440\u0435\u043c\u044f'), (b'nodata', '\u043d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445')])),
                ('fuzzy_only', models.BooleanField(default=False, verbose_name='\u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0435\u0447\u0435\u0442\u043a\u0438\u0435 rtstations')),
                ('virtual_end', models.BooleanField(default=False, verbose_name='\u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u0430\u044f \u043a\u043e\u043d\u0435\u0447\u043d\u0430\u044f')),
                ('incomplete_bus_schedule', models.BooleanField(default=False, verbose_name='\u043d\u0435\u043f\u043e\u043b\u043d\u043e\u0435 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0430\u0432\u0442\u043e\u0431\u0443\u0441\u043e\u0432')),
                ('show_mode', models.CharField(default=b'block', max_length=5, verbose_name='\u0440\u0435\u0436\u0438\u043c \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0430\u0432\u0442\u043e\u0431\u0443\u0441\u043e\u0432', choices=[(b'block', '\u0431\u043b\u043e\u0447\u043d\u043e\u0435 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435'), (b'simpl', '\u043f\u043e\u0441\u0442\u0440\u043e\u0447\u043d\u043e\u0435 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435')])),
                ('meta_title', models.CharField(max_length=255, null=True, verbose_name='meta title', blank=True)),
                ('meta_description', models.TextField(null=True, verbose_name='meta description', blank=True)),
                ('is_fuzzy', models.BooleanField(default=False, verbose_name='\u043d\u0435\u0447\u0435\u0442\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f/\u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f')),
                ('is_searchable_to', models.BooleanField(default=True, verbose_name='\u0438\u0441\u043a\u0430\u0442\u044c \u0434\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),
                ('is_searchable_from', models.BooleanField(default=True, verbose_name='\u0438\u0441\u043a\u0430\u0442\u044c \u043e\u0442 \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),
                ('in_station_schedule', models.BooleanField(default=True, verbose_name='\u0432 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438 \u043f\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),
                ('in_thread', models.BooleanField(default=True, verbose_name='\u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0438\u0442\u043a\u0438')),
                ('show_tablo_stat', models.BooleanField(default=True, verbose_name='\u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043e\u0442\u043c\u0435\u043d\u044b \u0438 \u0437\u0430\u0434\u0435\u0440\u0436\u043a\u0438 \u043f\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043d\u0430 \u0433\u043b\u0430\u0432\u043d\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0439')),
                ('short_title', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('short_title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('short_title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('short_title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('short_title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('how_to_get_to_city_ru', models.TextField(null=True, verbose_name='\u043a\u0430\u043a \u0434\u043e\u0435\u0445\u0430\u0442\u044c \u0434\u043e \u0433\u043e\u0440\u043e\u0434\u0430 (ru)', blank=True)),
                ('how_to_get_to_city_en', models.TextField(null=True, verbose_name='\u043a\u0430\u043a \u0434\u043e\u0435\u0445\u0430\u0442\u044c \u0434\u043e \u0433\u043e\u0440\u043e\u0434\u0430 (en)', blank=True)),
                ('how_to_get_to_city_tr', models.TextField(null=True, verbose_name='\u043a\u0430\u043a \u0434\u043e\u0435\u0445\u0430\u0442\u044c \u0434\u043e \u0433\u043e\u0440\u043e\u0434\u0430 (tr)', blank=True)),
                ('how_to_get_to_city_uk', models.TextField(null=True, verbose_name='\u043a\u0430\u043a \u0434\u043e\u0435\u0445\u0430\u0442\u044c \u0434\u043e \u0433\u043e\u0440\u043e\u0434\u0430 (uk)', blank=True)),
                ('popular_title', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432 \u043d\u0430\u0440\u043e\u0434\u043d\u044b\u0445 \u043c\u0430\u0441\u0441\u0430\u0445 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', null=True, verbose_name='\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435', db_index=True)),
                ('popular_title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432 \u043d\u0430\u0440\u043e\u0434\u043d\u044b\u0445 \u043c\u0430\u0441\u0441\u0430\u0445 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', null=True, verbose_name='\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', db_index=True)),
                ('popular_title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432 \u043d\u0430\u0440\u043e\u0434\u043d\u044b\u0445 \u043c\u0430\u0441\u0441\u0430\u0445 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', null=True, verbose_name='\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', db_index=True)),
                ('popular_title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432 \u043d\u0430\u0440\u043e\u0434\u043d\u044b\u0445 \u043c\u0430\u0441\u0441\u0430\u0445 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', null=True, verbose_name='\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', db_index=True)),
                ('popular_title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432 \u043d\u0430\u0440\u043e\u0434\u043d\u044b\u0445 \u043c\u0430\u0441\u0441\u0430\u0445 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', null=True, verbose_name='\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', db_index=True)),
                ('title', common.utils.fields.TrimmedCharField(default=None, max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435', db_index=True)),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', db_index=True)),
                ('title_ru_override', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0442\u044c \u0438\u0437 \u0442\u0430\u043d\u043a\u0435\u0440\u0430 (ru)')),
                ('title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', db_index=True)),
                ('title_en_override', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0442\u044c \u0438\u0437 \u0442\u0430\u043d\u043a\u0435\u0440\u0430 (en)')),
                ('title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', db_index=True)),
                ('title_tr_override', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0442\u044c \u0438\u0437 \u0442\u0430\u043d\u043a\u0435\u0440\u0430 (tr)')),
                ('title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', db_index=True)),
                ('title_uk_override', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0442\u044c \u0438\u0437 \u0442\u0430\u043d\u043a\u0435\u0440\u0430 (uk)')),
                ('address', common.utils.fields.TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u0430\u0434\u0440\u0435\u0441', blank=True)),
                ('address_ru', common.utils.fields.TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u0430\u0434\u0440\u0435\u0441 (ru)', blank=True)),
                ('address_en', common.utils.fields.TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u0430\u0434\u0440\u0435\u0441 (en)', blank=True)),
                ('address_tr', common.utils.fields.TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u0430\u0434\u0440\u0435\u0441 (tr)', blank=True)),
                ('address_uk', common.utils.fields.TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u0430\u0434\u0440\u0435\u0441 (uk)', blank=True)),
                ('is_base', models.BooleanField(default=False, help_text='\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0431\u0430\u0437\u043e\u0432\u043e\u0433\u043e \u0430\u0432\u0442\u043e\u0432\u043e\u043a\u0437\u0430\u043b\u0430 (\u0442\u0430\u0441\u043a RASPADMIN-183)', verbose_name='\u042f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0431\u0430\u0437\u043e\u0432\u044b\u043c \u0430\u0432\u0442\u043e\u0432\u043e\u043a\u0437\u0430\u043b\u043e\u043c')),
                ('country', models.ForeignKey(default=None, blank=True, to='www.Country', null=True, verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430')),
                ('district', models.ForeignKey(default=None, blank=True, to='www.District', null=True, verbose_name='\u0440\u0430\u0439\u043e\u043d')),
            ],
            options={
                'abstract': False,
                'db_table': 'www_station',
                'verbose_name': '\u0441\u0442\u0430\u043d\u0446\u0438\u044f',
                'verbose_name_plural': '\u0441\u0442\u0430\u043d\u0446\u0438\u0438',
            },
            bases=(models.Model, common.models_utils.geo.TimeZoneMixin, common.models_utils.geo.TransLocalMixin, common.models_utils.geo.Point),
        ),
        migrations.CreateModel(
            name='Station2Settlement',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('settlement', models.ForeignKey(verbose_name='\u0433\u043e\u0440\u043e\u0434', to='www.Settlement')),
                ('station', models.ForeignKey(verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
            ],
            options={
                'db_table': 'www_station2settlement',
                'verbose_name': 'соответствиe станции и города',
                'verbose_name_plural': 'соответствия станций и городов',
            },
        ),
        migrations.CreateModel(
            name='StationCode',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', common.utils.fields.CodeCharField(max_length=50, verbose_name='\u043a\u043e\u0434', db_index=True)),
                ('station', models.ForeignKey(related_name='code_set', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
                ('system', models.ForeignKey(verbose_name='\u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f', to='www.CodeSystem')),
            ],
            options={
                'ordering': ('station__id',),
                'db_table': 'www_stationcode',
                'verbose_name': '\u043a\u043e\u0434 \u0441\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u043a\u043e\u0434\u044b \u0441\u0442\u0430\u043d\u0446\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='StationExpressAlias',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('alias', common.utils.fields.CodeCharField(unique=True, max_length=50, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', db_index=True)),
                ('station', models.ForeignKey(related_name='expressalias_set', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
            ],
            options={
                'db_table': 'www_stationexpressalias',
                'verbose_name': '\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u042d\u043a\u0441\u043f\u0440\u0435\u0441\u0441',
            },
        ),
        migrations.CreateModel(
            name='StationMajority',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(verbose_name='\u043a\u043e\u0434 \u0434\u043b\u044f \u043f\u0438\u0442\u043e\u043d\u0430', max_length=50, editable=False)),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
            ],
            options={
                'db_table': 'www_stationmajority',
                'verbose_name': '\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u0441\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u0438 \u0441\u0442\u0430\u043d\u0446\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='StationPassage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('duration', models.IntegerField(default=None, null=True, verbose_name='\u0434\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430', blank=True)),
                ('is_dual', models.BooleanField(default=True, verbose_name='\u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u0434\u0432\u0443\u0441\u0442\u043e\u0440\u043e\u043d\u043d\u0438\u0439')),
                ('station_from', models.ForeignKey(related_name='outgoing_passages', verbose_name='\u0441 \u043a\u0430\u043a\u043e\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', to='www.Station')),
                ('station_to', models.ForeignKey(related_name='incoming_passages', verbose_name='\u0434\u043e \u043a\u0430\u043a\u043e\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', to='www.Station')),
            ],
            options={
                'db_table': 'www_stationpassage',
                'verbose_name': '\u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u043c\u0435\u0436\u0434\u0443 \u0441\u0442\u0430\u043d\u0446\u0438\u044f\u043c\u0438',
                'verbose_name_plural': '\u043f\u0435\u0440\u0435\u0445\u043e\u0434\u044b \u043c\u0435\u0436\u0434\u0443 \u0441\u0442\u0430\u043d\u0446\u0438\u044f\u043c\u0438',
            },
        ),
        migrations.CreateModel(
            name='StationPhone',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('phone', models.CharField(max_length=255, verbose_name='\u0442\u0435\u043b\u0435\u0444\u043e\u043d')),
                ('note', models.TextField(default=None, null=True, verbose_name='\u043f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435', blank=True)),
                ('station', models.ForeignKey(verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
            ],
            options={
                'ordering': ('phone',),
                'verbose_name': '\u0442\u0435\u043b\u0435\u0444\u043e\u043d \u0441\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u0442\u0435\u043b\u0435\u0444\u043e\u043d\u044b \u0441\u0442\u0430\u043d\u0446\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='StationProperty',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('description', models.TextField(default=None, null=True, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('order', models.IntegerField(default=10, help_text='\u0447\u0435\u043c \u0431\u043e\u043b\u044c\u0448\u0435 \u0446\u0438\u0444\u0440\u0430, \u0442\u0435\u043c \u0445\u0443\u0436\u0435 \u043f\u0440\u0438\u0437\u043d\u0430\u043a')),
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_stationproperty',
                'verbose_name': '\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='StationSchedule',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('stops', models.TextField(null=True)),
                ('stops_translations', models.TextField(null=True)),
                ('is_fuzzy', models.BooleanField(default=False)),
                ('route', models.ForeignKey(to='www.Route')),
                ('rtstation', models.OneToOneField(related_name='schedule', to='www.RTStation')),
                ('station', models.ForeignKey(to='www.Station')),
                ('thread', models.ForeignKey(to='www.RThread', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='StationTeleportMap',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('teleport_time', models.IntegerField(help_text='\u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445 (\u0446\u0435\u043b\u043e\u0435 \u0447\u0438\u0441\u043b\u043e)', verbose_name='\u0432\u0440\u0435\u043c\u044f \u043d\u0430 \u043f\u0435\u0440\u0435\u0441\u0430\u0434\u043a\u0443')),
                ('settlement_from', models.ForeignKey(related_name='station_teleport_map_from', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043e\u0442', blank=True, to='www.Settlement', null=True)),
                ('settlement_to', models.ForeignKey(related_name='station_teleport_map_to', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u0434\u043e', blank=True, to='www.Settlement', null=True)),
                ('station_from', models.ForeignKey(related_name='station_teleport_map_from', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043e\u0442', blank=True, to='www.Station', null=True)),
                ('station_to', models.ForeignKey(related_name='station_teleport_map_to', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u0434\u043e', blank=True, to='www.Station', null=True)),
            ],
            options={
                'verbose_name': '\u0441\u0432\u044f\u0437\u044c \u043c\u0435\u0436\u0434\u0443 \u0441\u0442\u0430\u043d\u0446\u0438\u044f\u043c\u0438',
                'verbose_name_plural': '\u0441\u0432\u044f\u0437\u0438 \u043c\u0435\u0436\u0434\u0443 \u0441\u0442\u0430\u043d\u0446\u0438\u044f\u043c\u0438',
            },
        ),
        migrations.CreateModel(
            name='StationTerminal',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', common.utils.fields.TrimmedCharField(max_length=50, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('sirena_id', common.utils.fields.CodeCharField(max_length=6, null=True, verbose_name='\u0414\u0438\u0430\u043d\u0430 \u043a\u043e\u0434 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430', blank=True)),
                ('sirena_letter', common.utils.fields.CodeCharField(max_length=6, null=True, verbose_name='\u0421\u0438\u0440\u0435\u043d\u0430 \u0431\u0443\u043a\u0432\u0430 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430', blank=True)),
                ('longitude', models.FloatField(default=None, null=True, verbose_name='\u0434\u043e\u043b\u0433\u043e\u0442\u0430', blank=True)),
                ('latitude', models.FloatField(default=None, null=True, verbose_name='\u0448\u0438\u0440\u043e\u0442\u0430', blank=True)),
                ('station', models.ForeignKey(verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
            ],
            options={
                'db_table': 'www_stationterminal',
                'verbose_name': '\u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b',
                'verbose_name_plural': '\u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u044b',
            },
        ),
        migrations.CreateModel(
            name='StationType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name_ru_genitive', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u043c \u043f\u0430\u0434\u0435\u0436\u0435', blank=True)),
                ('name_ru_accusative', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0432\u0438\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u043c \u043f\u0430\u0434\u0435\u0436\u0435', blank=True)),
                ('name_ru_dative', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0434\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u043c \u043f\u0430\u0434\u0435\u0436\u0435', blank=True)),
                ('title_regex', common.utils.fields.RegExpField(default=None, max_length=100, null=True, verbose_name='\u0448\u0430\u0431\u043b\u043e\u043d \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u0438', blank=True)),
                ('railway_prefix_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u0434\u043b\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0436\u0434 \u0440\u0435\u0439\u0441\u0430', null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 \u0434\u043b\u044f \u0436\u0434 (ru)')),
                ('railway_prefix_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u0434\u043b\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0436\u0434 \u0440\u0435\u0439\u0441\u0430', null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 \u0434\u043b\u044f \u0436\u0434 (en)')),
                ('railway_prefix_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u0434\u043b\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0436\u0434 \u0440\u0435\u0439\u0441\u0430', null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 \u0434\u043b\u044f \u0436\u0434 (tr)')),
                ('railway_prefix_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u0434\u043b\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0436\u0434 \u0440\u0435\u0439\u0441\u0430', null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 \u0434\u043b\u044f \u0436\u0434 (uk)')),
                ('prefix_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 (ru)', blank=True)),
                ('prefix_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 (en)', blank=True)),
                ('prefix_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 (tr)', blank=True)),
                ('prefix_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 (uk)', blank=True)),
                ('name_ru', common.utils.fields.TrimmedCharField(default=None, max_length=255, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)')),
                ('name_en', common.utils.fields.TrimmedCharField(default=None, max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('name_tr', common.utils.fields.TrimmedCharField(default=None, max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('name_uk', common.utils.fields.TrimmedCharField(default=None, max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
            ],
            options={
                'db_table': 'www_stationtype',
                'verbose_name': '\u0442\u0438\u043f \u0441\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u0442\u0438\u043f\u044b \u0441\u0442\u0430\u043d\u0446\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='SuburbanTariff',
            fields=[
                ('code', common.utils.fields.TrimmedCharField(max_length=10, serialize=False, verbose_name='\u043a\u043e\u0434', primary_key=True)),
                ('tariff', models.FloatField(verbose_name='\u0446\u0435\u043d\u0430')),
            ],
            options={
                'verbose_name': '\u0442\u0430\u0440\u0438\u0444 \u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u043e\u0433\u043e \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u0442\u0430\u0440\u0438\u0444\u044b \u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u043e\u0433\u043e \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='SuburbanZone',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=100, verbose_name='\u043a\u043e\u0434 \u0437\u043e\u043d\u044b')),
                ('title_from', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u0434\u0430(\u043e\u0442 \u041c\u043e\u0441\u043a\u0432\u044b)')),
                ('title_to', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043e\u0431\u0440\u0430\u0442\u043d\u043e(\u043d\u0430 \u041c\u043e\u0441\u043a\u0432\u0443)')),
                ('title', common.utils.fields.TrimmedCharField(default=None, max_length=200, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('title_en', common.utils.fields.TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('settlement', models.ForeignKey(related_name='zone_settlement', verbose_name='\u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u0433\u043e\u0440\u043e\u0434 \u0437\u043e\u043d\u044b', to='www.Settlement')),
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_suburbanzone',
                'verbose_name': '\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430',
                'verbose_name_plural': '\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u044b\u0435 \u0437\u043e\u043d\u044b',
            },
        ),
        migrations.CreateModel(
            name='Suggest',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', common.utils.fields.TrimmedCharField(max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('title_ru', common.utils.fields.TrimmedCharField(max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_en', common.utils.fields.TrimmedCharField(max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('full_title', common.utils.fields.TrimmedCharField(default=b'', max_length=100, verbose_name='\u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u0438\u043c\u044f')),
                ('full_title_ru', common.utils.fields.TrimmedCharField(default=b'', max_length=100, verbose_name='\u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u0438\u043c\u044f (ru)')),
                ('full_title_tr', common.utils.fields.TrimmedCharField(default=b'', max_length=100, verbose_name='\u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u0438\u043c\u044f (tr)')),
                ('full_title_uk', common.utils.fields.TrimmedCharField(default=b'', max_length=100, verbose_name='\u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u0438\u043c\u044f (uk)')),
                ('full_title_en', common.utils.fields.TrimmedCharField(default=b'', max_length=100, verbose_name='\u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u0438\u043c\u044f (en)')),
                ('ttype', models.CharField(default=None, max_length=100, null=True, verbose_name='\u0442\u0438\u043f \u0422\u0421', blank=True)),
                ('type', models.CharField(default=None, max_length=100, null=True, verbose_name='\u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430', blank=True)),
                ('object_id', models.IntegerField(default=None, null=True, verbose_name='\u043a\u043e\u0434 \u043e\u0431\u044a\u0435\u043a\u0442\u0430', blank=True)),
                ('majority', models.IntegerField(default=None, null=True, verbose_name='\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442\u0430', blank=True)),
                ('order', models.IntegerField(default=100, verbose_name='\u043f\u043e\u0440\u044f\u0434\u043e\u043a')),
                ('country', models.ForeignKey(default=None, blank=True, to='www.Country', null=True, verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430')),
                ('region', models.ForeignKey(default=None, blank=True, to='www.Region', null=True, verbose_name='\u043e\u0431\u043b\u0430\u0441\u0442\u044c')),
                ('zone', models.ForeignKey(default=None, blank=True, to='www.SuburbanZone', null=True, verbose_name='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430')),
            ],
            options={
                'ordering': ('title',),
                'verbose_name': '\u0441\u0430\u0433\u0433\u0435\u0441\u0442',
                'verbose_name_plural': '\u0441\u0430\u0433\u0433\u0435\u0441\u0442\u044b',
            },
        ),
        migrations.CreateModel(
            name='Supplier',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430')),
                ('code', common.utils.fields.CodeCharField(unique=True, max_length=100, verbose_name='\u043a\u043e\u0434 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', validators=[django.core.validators.RegexValidator('(?u)^([0-9a-zA-Z-]*|airport\\_donetsk|airport\\_kharkov|airport\\_simferopol|arch\\_av|avto\\_siktivcar|a\\_linii|b2\\_msq|bb\\_travel|BS\\_Tushinskaya|chel\\_gortrans|dyc\\_ast|ekb\\_northav|IP\\_Bezuglov|IP\\_Stachanov|IP\\_Vildanova|Kostroma\\_avia|kvc\\_tula|maykop\\_av|middle\\_station\\_route\\_af|msk\\_subway|next\\_bus\\_tour|Nordexpress\\_Rybinsk|STK\\_Parus|Tarasovskoe\\_ATP|tis\\_from\\_hp|zd\\_syktyvkar)$', '\u0412 \u043a\u043e\u0434\u0435 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u043c\u043e\u0433\u0443\u0442 \u0443\u0447\u0430\u0432\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0435 \u0431\u0443\u043a\u0432\u044b \u0446\u0438\u0444\u0440\u044b \u0438 \u0437\u043d\u0430\u043a \u043c\u0438\u043d\u0443\u0441')])),
                ('lmt', models.DateTimeField(help_text='\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0422\u0418\u0421', verbose_name='\u0434\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0438\u043c\u043f\u043e\u0440\u0442\u0430', auto_now_add=True)),
                ('filename', models.CharField(max_length=100, null=True, verbose_name='\u0444\u0430\u0439\u043b \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430', blank=True)),
                ('hide_in_filters', models.BooleanField(default=False, verbose_name='\u041d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0432 \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0445')),
                ('exclude_from_external_api', models.BooleanField(default=False, verbose_name='\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0438\u0437 \u0432\u043d\u0435\u0448\u043d\u0435\u0433\u043e API')),
                ('can_buy_ru', models.BooleanField(default=False, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 (ru)')),
                ('can_buy_ua', models.BooleanField(default=False, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 (ua)')),
                ('can_buy_tr', models.BooleanField(default=False, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 (tr)')),
                ('logo', models.ImageField(default=None, upload_to=b'data/supplier_logo', null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f', blank=True)),
                ('sale_url_template', models.CharField(default='', validators=[base_supplier.StringTemplateValidator(fields=(b'from_code', b'to_code', b'departure'))], max_length=1024, blank=True, help_text='\u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, https://example.org/buy/?from={from_code}&to={to_code}&date={departure:%Y-%m-%d}&time={departure:%H:%M}', verbose_name='\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u0441\u044b\u043b\u043a\u0438')),
                ('sale_start_days', models.IntegerField(help_text='\u0417\u0430 \u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0441\u0443\u0442\u043e\u043a \u0434\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0430', null=True, verbose_name='\u0414\u043d\u0438 \u043f\u0440\u043e\u0434\u0430\u0436\u0438', blank=True)),
                ('sale_stop_hours', models.IntegerField(help_text='\u0417\u0430 \u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0447\u0430\u0441\u043e\u0432 \u0434\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0437\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0430', null=True, verbose_name='\u0427\u0430\u0441\u044b \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0438', blank=True)),
                ('add_to_route_changes_report', models.BooleanField(default=True, verbose_name='\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u0432 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u043f\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u043c \u0440\u0435\u0439\u0441\u0430\u043c')),
            ],
            options={
                'abstract': False,
                'db_table': 'www_supplier',
                'verbose_name': '\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445',
                'verbose_name_plural': '\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445',
            },
        ),
        migrations.CreateModel(
            name='TariffType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('link', common.utils.fields.TrimmedCharField(max_length=255, verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430', blank=True)),
                ('category', models.CharField(default=b'usual', max_length=20, verbose_name='\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f', choices=[(b'season_ticket', '\u0410\u0431\u043e\u043d\u0435\u043c\u0435\u043d\u0442'), (b'usual', '\u041e\u0431\u044b\u0447\u043d\u044b\u0439')])),
                ('code', common.utils.fields.CodeCharField(unique=True, max_length=20, verbose_name='\u043a\u043e\u0434')),
                ('order', models.IntegerField(default=0, verbose_name='\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u043f\u043e\u043a\u0430\u0437\u0430')),
                ('title', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u0430', blank=True)),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 (ru)', blank=True)),
                ('title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 (en)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 (tr)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 (uk)', blank=True)),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': '\u0442\u0438\u043f \u0442\u0430\u0440\u0438\u0444\u0430',
                'verbose_name_plural': '\u0442\u0438\u043f\u044b \u0442\u0430\u0440\u0438\u0444\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='Teaser',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=255, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('content', models.TextField(verbose_name='\u0442\u0435\u043a\u0441\u0442')),
                ('mobile_content', models.TextField(default=b'', verbose_name='\u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439', blank=True)),
                ('url', models.URLField(null=True, verbose_name='url', blank=True)),
                ('image', models.ImageField(upload_to=b'data/teasers', null=True, verbose_name='\u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0430', blank=True)),
                ('template', models.CharField(max_length=20, null=True, verbose_name='\u0448\u0430\u0431\u043b\u043e\u043d', blank=True)),
                ('is_active_rasp', models.BooleanField(default=False, verbose_name='\u0430\u043a\u0442\u0438\u0432\u0435\u043d \u0432 \u041f\u041c')),
                ('is_active_ticket', models.BooleanField(default=False, verbose_name='\u0430\u043a\u0442\u0438\u0432\u0435\u043d \u0432 \u041a\u0411')),
                ('is_active_export', models.BooleanField(default=False, verbose_name='\u0410\u043a\u0442\u0438\u0432\u0435\u043d \u0432 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u0445 (export)')),
                ('mode', models.CharField(default=b'normal', max_length=20, verbose_name='\u0442\u0438\u043f', choices=[(b'normal', '\u041e\u0431\u044b\u0447\u043d\u044b\u0439'), (b'ahtung', '\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435'), (b'special', '\u0421\u043f\u0435\u0446\u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435'), (b'banner', '\u0411\u0430\u043d\u043d\u0435\u0440')])),
                ('importance', models.PositiveIntegerField(default=0, help_text='\u0447\u0435\u043c \u0431\u043e\u043b\u044c\u0448\u0435 \u0446\u0438\u0444\u0440\u0430, \u0442\u0435\u043c \u0432\u0430\u0436\u043d\u0435\u0435', verbose_name='\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c')),
                ('date_start', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043a\u0430\u043c\u043f\u0430\u043d\u0438\u0438')),
                ('date_finish', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043a\u0430\u043c\u043f\u0430\u043d\u0438\u0438')),
                ('lang', models.CharField(default=b'ru', max_length=25, verbose_name='\u042f\u0437\u044b\u043a', choices=[(b'ru', '\u0420\u0443\u0441\u0441\u043a\u0438\u0439'), (b'be', '\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0439'), (b'kk', '\u041a\u0430\u0437\u0430\u0445\u0441\u043a\u0438\u0439'), (b'tt', '\u0422\u0430\u0442\u0430\u0440\u0441\u043a\u0438\u0439'), (b'uk', '\u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0438\u0439'), (b'en', '\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439'), (b'tr', '\u0422\u0443\u0440\u0435\u0446\u043a\u0438\u0439')])),
                ('national_version', models.CharField(default=b'ru', max_length=25, null=True, verbose_name='\u041d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f', choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr')])),
                ('companies', models.ManyToManyField(default=None, to='www.Company', verbose_name='\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0438', blank=True)),
                ('countries', models.ManyToManyField(default=None, to='www.Country', verbose_name='\u0441\u0442\u0440\u0430\u043d\u044b', blank=True)),
                ('directions', models.ManyToManyField(default=None, related_name='directions', verbose_name='\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', to='www.ExternalDirection', blank=True)),
                ('pages', models.ManyToManyField(default=None, to='www.Page', verbose_name='\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b', blank=True)),
                ('settlements', models.ManyToManyField(default=None, related_name='settlements', verbose_name='\u0433\u043e\u0440\u043e\u0434\u0430', to='www.Settlement', blank=True)),
                ('stations', models.ManyToManyField(default=None, related_name='stations', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u0438', to='www.Station', blank=True)),
                ('threads', models.ManyToManyField(default=None, related_name='threads', verbose_name='\u043d\u0438\u0442\u043a\u0438', to='www.RThread', blank=True)),
            ],
            options={
                'verbose_name': '\u0442\u0438\u0437\u0435\u0440',
                'verbose_name_plural': '\u0442\u0438\u0437\u0435\u0440\u044b',
            },
        ),
        migrations.CreateModel(
            name='ThreadSchedule',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('schedule_oid', models.IntegerField(verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0438 \u043d\u0438\u0442\u043a\u0438')),
                ('start_date', models.DateField(verbose_name='\u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430')),
                ('end_date', models.DateField(verbose_name='\u043a\u043e\u043d\u0435\u0446 \u043f\u0435\u0440\u0438\u043e\u0434\u0430')),
                ('start_time', models.TimeField(verbose_name='\u0432\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043a\u0430')),
                ('end_time', models.TimeField(verbose_name='\u0432\u0440\u0435\u043c\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043a\u0430')),
                ('frequency', models.IntegerField(default=None, null=True, verbose_name='\u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f', blank=True)),
                ('times', models.CharField(default=None, max_length=255, null=True, verbose_name='\u0432\u0440\u0435\u043c\u044f \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0432\u043d\u0435 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u043e\u0432', blank=True)),
                ('week_days', models.CharField(default=b'1234567', max_length=20, null=True, verbose_name='\u0434\u043d\u0438 \u043d\u0435\u0434\u0435\u043b\u0438', blank=True)),
                ('is_cancel', models.BooleanField(default=False, verbose_name='\u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043b\u0438 \u043e\u0442\u043c\u0435\u043d\u043e\u0439')),
                ('time_zone', models.CharField(max_length=30, verbose_name='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430')),
                ('thread', models.ForeignKey(verbose_name='\u043d\u0438\u0442\u043a\u0430', to='www.RThread')),
            ],
            options={
                'verbose_name': '\u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='ThreadTariff',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('thread_uid', models.CharField(help_text='\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0437\u043d\u0430\u0447\u043d\u043e\u0433\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043d\u0438\u0442\u043a\u0438', max_length=100, verbose_name='\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440', db_index=True)),
                ('year_days', common.utils.fields.ThreadCalendarField(default='', verbose_name='\u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u0434\u043d\u0435\u0439 \u043a\u043e\u0433\u0434\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u044d\u0442\u0430 \u0446\u0435\u043d\u0430')),
                ('tariff', models.FloatField(verbose_name='\u0426\u0435\u043d\u0430')),
                ('currency', models.CharField(default=None, max_length=10, null=True, verbose_name='\u0412\u0430\u043b\u044e\u0442\u0430', blank=True)),
                ('is_min_tariff', models.BooleanField(default=False, verbose_name='\u042d\u0442\u043e \u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0446\u0435\u043d\u0430 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430, \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0438 \u0432\u044b\u0448\u0435')),
                ('url', common.utils.fields.TrimmedCharField(default=b'', max_length=255, verbose_name='order Url', blank=True)),
                ('data', models.TextField(default=b'', verbose_name='\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435')),
                ('station_from', models.ForeignKey(related_name='route_tariffs_from', verbose_name='\u043f\u0435\u0440\u0432\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
                ('station_to', models.ForeignKey(related_name='route_tariffs_to', verbose_name='\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
            ],
            options={
                'verbose_name': '\u0442\u0430\u0440\u0438\u0444 \u043d\u0438\u0442\u043a\u0430-\u0442\u043e\u0447\u043a\u0430-\u0442\u043e\u0447\u043a\u0430',
                'verbose_name_plural': '\u0442\u0430\u0440\u0438\u0444\u044b \u043d\u0438\u0442\u043a\u0430-\u0442\u043e\u0447\u043a\u0430-\u0442\u043e\u0447\u043a\u0430',
            },
        ),
        migrations.CreateModel(
            name='TicketOffice',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=200, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('postal_code', models.CharField(default=None, max_length=200, null=True, verbose_name='\u043f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441', blank=True)),
                ('address', models.CharField(default=None, max_length=200, null=True, verbose_name='\u0430\u0434\u0440\u0435\u0441', blank=True)),
                ('home_number', models.CharField(default=None, max_length=100, null=True, verbose_name='\u0434\u043e\u043c', blank=True)),
                ('address2', models.CharField(default=None, max_length=200, null=True, verbose_name='\u0434\u043e\u043f. \u0410\u0434\u0440\u0435\u0441', blank=True)),
                ('phone', models.CharField(default=None, max_length=100, null=True, verbose_name='\u0442\u0435\u043b\u0435\u0444\u043e\u043d', blank=True)),
                ('fax', models.CharField(default=None, max_length=100, null=True, verbose_name='\u0444\u0430\u043a\u0441', blank=True)),
                ('home_site', models.CharField(default=None, max_length=100, null=True, verbose_name='\u0441\u0430\u0439\u0442', blank=True)),
                ('email', models.EmailField(default=None, max_length=100, null=True, verbose_name='\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430', blank=True)),
                ('plane', models.BooleanField(default=False, verbose_name='\u043d\u0430 \u0441\u0430\u043c\u043e\u043b\u0435\u0442')),
                ('train', models.BooleanField(default=False, verbose_name='\u043d\u0430 \u043f\u043e\u0435\u0437\u0434')),
                ('companies', models.TextField(default=None, null=True, verbose_name='\u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438', blank=True)),
                ('longitude', models.FloatField(default=None, null=True, verbose_name='\u0434\u043e\u043b\u0433\u043e\u0442\u0430', blank=True)),
                ('latitude', models.FloatField(default=None, null=True, verbose_name='\u0448\u0438\u0440\u043e\u0442\u0430', blank=True)),
                ('settlement', models.ForeignKey(verbose_name='\u0433\u043e\u0440\u043e\u0434', to='www.Settlement')),
            ],
            options={
                'ordering': ('title',),
                'verbose_name': '\u0431\u0438\u043b\u0435\u0442\u043d\u0430\u044f \u043a\u0430\u0441\u0441\u0430',
                'verbose_name_plural': '\u0431\u0438\u043b\u0435\u0442\u043d\u044b\u0435 \u043a\u0430\u0441\u0441\u044b',
            },
        ),
        migrations.CreateModel(
            name='TrainPseudoStationMap',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', common.utils.fields.TrimmedCharField(max_length=50, verbose_name='\u043d\u043e\u043c\u0435\u0440')),
                ('pseudo_station', models.ForeignKey(related_name='pseudo_pseudo_station_set', verbose_name='\u043f\u0441\u0435\u0432\u0434\u043e\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
                ('station', models.ForeignKey(related_name='pseudo_station_set', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
            ],
            options={
                'verbose_name': '\u0437\u0430\u043c\u0435\u043d\u0430 \u043f\u0441\u0435\u0432\u0434\u043e\u0441\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u0437\u0430\u043c\u0435\u043d\u044b \u043f\u0441\u0435\u0432\u0434\u043e\u0441\u0442\u0430\u043d\u0446\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='TrainSchedulePlan',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', common.utils.fields.TrimmedCharField(default=None, max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0430\u0444\u0444\u0438\u043a\u0430', blank=True)),
                ('start_date', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430(\u0432\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e)')),
                ('end_date', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f(\u0432\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e)')),
                ('code', common.utils.fields.CodeCharField(unique=True, max_length=50, verbose_name='\u043a\u043e\u0434')),
                ('appendix_type', models.CharField(default=b'from', max_length=4, verbose_name='\u0441\u0435\u043b\u0435\u043a\u0442\u043e\u0440 \u0441/\u043f\u043e', choices=[(b'from', '\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c "c"'), (b'to', '\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c "\u043f\u043e"')])),
            ],
            options={
                'db_table': 'www_trainscheduleplan',
                'verbose_name': '\u0433\u0440\u0430\u0444\u0438\u043a \u043f\u043e\u0435\u0437\u0434\u043e\u0432 \u0438 \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u0435\u043a',
                'verbose_name_plural': '\u0433\u0440\u0430\u0444\u0438\u043a\u0438 \u043f\u043e\u0435\u0437\u0434\u043e\u0432 \u0438 \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u0435\u043a',
            },
        ),
        migrations.CreateModel(
            name='TransportModel',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('title_en', models.CharField(default='', max_length=100, verbose_name='\u0430\u043d\u0433\u043b. \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('template_page', models.CharField(max_length=100, null=True, verbose_name='\u0438\u043c\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430', blank=True)),
                ('code', common.utils.fields.CodeCharField(null=True, default=None, max_length=10, blank=True, unique=True, verbose_name='\u043a\u043e\u0434')),
                ('code_en', common.utils.fields.CodeCharField(null=True, default=None, max_length=10, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439')),
                ('img', models.ImageField(default=None, upload_to=b'data/transportmodel/img', null=True, verbose_name='\u0444\u043e\u0442\u043e \u0422\u0421', blank=True)),
                ('background', models.ImageField(default=None, upload_to=b'data/transportmodel/background', null=True, verbose_name='\u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0430 \u0434\u043b\u044f \u0444\u043e\u043d\u0430', blank=True)),
                ('ttx', models.TextField(default=None, null=True, verbose_name='\u0442\u0422\u0425', blank=True)),
                ('descr', models.TextField(default=None, null=True, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('is_cargo', models.BooleanField(default=False, verbose_name='\u0433\u0440\u0443\u0437\u043e\u0432\u043e\u0439')),
            ],
            options={
                'db_table': 'www_transportmodel',
                'verbose_name': '\u043c\u043e\u0434\u0435\u043b\u044c \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u043c\u043e\u0434\u0435\u043b\u0438 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='TransportScheme',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('img', models.ImageField(upload_to=b'data/transportscheme/img', verbose_name='\u0441\u0445\u0435\u043c\u0430')),
                ('transport_img', models.ImageField(default=None, upload_to=b'data/transportscheme/transport_img', null=True, verbose_name='\u0444\u043e\u0442\u043e \u0422\u0421', blank=True)),
                ('company', models.ForeignKey(default=None, blank=True, to='www.Company', null=True, verbose_name='\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f-\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a')),
                ('transport', models.ForeignKey(default=None, blank=True, to='www.TransportModel', null=True, verbose_name='\u043c\u043e\u0434\u0435\u043b\u044c \u0422\u0421')),
            ],
            options={
                'ordering': ('title',),
                'verbose_name': '\u0441\u0445\u0435\u043c\u0430 \u0441\u0430\u043b\u043e\u043d\u0430 \u0422\u0421',
                'verbose_name_plural': '\u0441\u0445\u0435\u043c\u044b \u0441\u0430\u043b\u043e\u043d\u043e\u0432 \u0422\u0421',
            },
        ),
        migrations.CreateModel(
            name='TransportSubtype',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=50, verbose_name='\u043a\u043e\u0434', validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z-]+$', '\u0412 \u043a\u043e\u0434\u0435 \u043f\u043e\u0434\u0442\u0438\u043f\u0430 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u043c\u043e\u0433\u0443\u0442 \u0443\u0447\u0430\u0432\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0435 \u0431\u0443\u043a\u0432\u044b \u0446\u0438\u0444\u0440\u044b \u0438 \u0437\u043d\u0430\u043a \u043c\u0438\u043d\u0443\u0441')])),
                ('icon', TransportSubtypeIconField(default=None, validators=[common.utils.files.validators.FileSizeValidator(size_limit_in_bytes=1048576), common.utils.files.validators.SvgValidator()], upload_to=transportsubtypeiconfield_generate_filename, blank=True, null=True, verbose_name='\u0418\u043a\u043e\u043d\u043a\u0430 (svg)')),
                ('comment', common.utils.fields.TrimmedTextField(default=b'', verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439', blank=True)),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)')),
                ('title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('station_name_plural_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (ru)')),
                ('station_name_plural_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (en)')),
                ('station_name_plural_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (tr)')),
                ('station_name_plural_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (uk)')),
                ('title_plural_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (ru)', blank=True)),
                ('title_plural_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (en)', blank=True)),
                ('title_plural_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (tr)', blank=True)),
                ('title_plural_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (uk)', blank=True)),
                ('title_partner_page_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (ru)', blank=True)),
                ('title_partner_page_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (en)', blank=True)),
                ('title_partner_page_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (tr)', blank=True)),
                ('title_partner_page_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (uk)', blank=True)),
                ('station_name_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (ru)')),
                ('station_name_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (en)')),
                ('station_name_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (tr)')),
                ('station_name_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (uk)')),
            ],
            options={
                'db_table': 'www_transportsubtype',
                'verbose_name': '\u043f\u043e\u0434\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u043f\u043e\u0434\u0442\u0438\u043f\u044b \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='TransportSubtypeColor',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=50, verbose_name='\u041a\u043e\u0434', validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z-]+$', '\u0412 \u043a\u043e\u0434\u0435 \u0446\u0432\u0435\u0442\u0430 \u043c\u043e\u0433\u0443\u0442 \u0443\u0447\u0430\u0432\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0435 \u0431\u0443\u043a\u0432\u044b \u0446\u0438\u0444\u0440\u044b \u0438 \u0437\u043d\u0430\u043a \u043c\u0438\u043d\u0443\u0441')])),
                ('color', common.utils.fields.TrimmedCharField(max_length=10, verbose_name='\u0426\u0432\u0435\u0442', validators=[django.core.validators.RegexValidator('^#[0-9a-fA-F]{6}$', '\u0426\u0432\u0435\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0437\u0430\u0434\u0430\u043d \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 #123456')])),
            ],
            options={
                'verbose_name': '\u0426\u0432\u0435\u0442 \u043f\u043e\u0434\u0442\u0438\u043f\u0430 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u0426\u0432\u0435\u0442\u0430 \u043f\u043e\u0434\u0442\u0438\u043f\u043e\u0432 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='TransportType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=50, verbose_name='\u043a\u043e\u0434', validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z-]+$', '\u0412 \u043a\u043e\u0434\u0435 \u0442\u0438\u043f\u0430 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u043c\u043e\u0433\u0443\u0442 \u0443\u0447\u0430\u0432\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0435 \u0431\u0443\u043a\u0432\u044b \u0446\u0438\u0444\u0440\u044b \u0438 \u0437\u043d\u0430\u043a \u043c\u0438\u043d\u0443\u0441')])),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)')),
                ('title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('station_name_plural_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (ru)')),
                ('station_name_plural_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (en)')),
                ('station_name_plural_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (tr)')),
                ('station_name_plural_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (uk)')),
                ('title_plural_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (ru)', blank=True)),
                ('title_plural_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (en)', blank=True)),
                ('title_plural_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (tr)', blank=True)),
                ('title_plural_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (uk)', blank=True)),
                ('title_partner_page_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (ru)', blank=True)),
                ('title_partner_page_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (en)', blank=True)),
                ('title_partner_page_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (tr)', blank=True)),
                ('title_partner_page_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (uk)', blank=True)),
                ('station_name_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (ru)')),
                ('station_name_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (en)')),
                ('station_name_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (tr)')),
                ('station_name_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (uk)')),
            ],
            options={
                'db_table': 'www_transporttype',
                'verbose_name': '\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u0442\u0438\u043f\u044b \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='VehicleProducer',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('t_type', models.ForeignKey(verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType')),
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_vehicleproducer',
                'verbose_name': '\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c \u0422\u0421',
                'verbose_name_plural': '\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u0438 \u0422\u0421',
            },
        ),
        migrations.CreateModel(
            name='ZNodeRoute2',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('stops_translations', models.TextField(default=b'')),
                ('route', models.ForeignKey(to='www.Route')),
                ('rtstation_from', models.ForeignKey(related_name='www_outgoing_noderoutes2', to='www.RTStation', null=True)),
                ('rtstation_to', models.ForeignKey(related_name='www_incoming_noderoutes2', to='www.RTStation', null=True)),
                ('settlement_from', models.ForeignKey(related_name='www_outgoing_noderoutes2', to='www.Settlement', null=True)),
                ('settlement_to', models.ForeignKey(related_name='www_incoming_noderoutes2', to='www.Settlement', null=True)),
                ('station_from', models.ForeignKey(related_name='www_outgoing_noderoutes2', to='www.Station')),
                ('station_to', models.ForeignKey(related_name='www_incoming_noderoutes2', to='www.Station')),
                ('supplier', models.ForeignKey(default=None, blank=True, to='www.Supplier', null=True, verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a')),
                ('thread', models.ForeignKey(to='www.RThread')),
            ],
            options={
                'abstract': False,
                'db_table': 'www_znoderoute2',
            },
        ),
        migrations.CreateModel(
            name='ZTablo2',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('platform', common.utils.fields.TrimmedCharField(default=None, max_length=22, null=True, verbose_name='\u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0430', blank=True)),
                ('number', models.CharField(max_length=100, null=True, db_column=b'r_number')),
                ('route_uid', models.CharField(max_length=50, null=True)),
                ('title', models.CharField(max_length=100, null=True, db_column=b'r_title')),
                ('title_common', models.CharField(max_length=500, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('original_arrival', models.DateTimeField(null=True)),
                ('original_departure', models.DateTimeField(null=True)),
                ('arrival', models.DateTimeField(null=True)),
                ('departure', models.DateTimeField(null=True)),
                ('real_arrival', models.DateTimeField(null=True)),
                ('real_departure', models.DateTimeField(null=True)),
                ('start_datetime', models.DateTimeField(null=True)),
                ('utc_start_datetime', models.DateTimeField(null=True)),
                ('arrival_cancelled', models.BooleanField(default=False)),
                ('departure_cancelled', models.BooleanField(default=False)),
                ('is_fuzzy', models.BooleanField(default=False)),
                ('lmt', models.DateTimeField(auto_now=True)),
                ('manual_status', models.CharField(default=None, choices=[(b'use_real_time', '\u0412\u0438\u0447\u0438\u0441\u043b\u0438\u0442\u044c \u043f\u043e \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u043c\u0443 \u0432\u0440\u0435\u043c\u0435\u043d\u0438'), (b'cancelled', '\u041e\u0442\u043c\u0435\u043d\u0435\u043d'), (b'hidden', '\u0421\u043a\u0440\u044b\u0442')], max_length=20, blank=True, null=True, verbose_name='\u0441\u0442\u0430\u0442\u0443\u0441')),
                ('for_search_ru', models.CharField(default=b'', max_length=500, verbose_name='\u043f\u043e\u043b\u0435 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u0440\u0435\u0439\u0441\u043e\u0432 (ru)')),
                ('for_search_tr', models.CharField(default=b'', max_length=500, verbose_name='\u043f\u043e\u043b\u0435 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u0440\u0435\u0439\u0441\u043e\u0432 (tr)')),
                ('for_search_uk', models.CharField(default=b'', max_length=500, verbose_name='\u043f\u043e\u043b\u0435 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u0440\u0435\u0439\u0441\u043e\u0432 (uk)')),
                ('comment', common.utils.fields.TrimmedCharField(default=b'', max_length=500, verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439', blank=True)),
                ('comment_ru', common.utils.fields.TrimmedCharField(default=b'', max_length=500, verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 (ru)', blank=True)),
                ('comment_en', common.utils.fields.TrimmedCharField(default=b'', max_length=500, verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 (en)', blank=True)),
                ('comment_tr', common.utils.fields.TrimmedCharField(default=b'', max_length=500, verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 (tr)', blank=True)),
                ('comment_uk', common.utils.fields.TrimmedCharField(default=b'', max_length=500, verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 (uk)', blank=True)),
                ('company', models.ForeignKey(to='www.Company', null=True)),
                ('merged_flight', models.ForeignKey(default=None, to='www.ZTablo2', null=True)),
                ('next_station', models.ForeignKey(related_name='prev_station_ztablo2_set', to='www.Station', null=True)),
                ('next_terminal', models.ForeignKey(related_name='prev_station_ztablo2_set', to='www.StationTerminal', null=True)),
                ('route', models.ForeignKey(to='www.Route', null=True)),
                ('rtstation', models.ForeignKey(to='www.RTStation', null=True)),
                ('station', models.ForeignKey(to='www.Station')),
                ('t_type', models.ForeignKey(to='www.TransportType', null=True)),
                ('terminal', models.ForeignKey(default=None, blank=True, to='www.StationTerminal', null=True, verbose_name='\u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b')),
                ('thread', models.ForeignKey(to='www.RThread', null=True)),
            ],
            options={
                'db_table': 'z_tablo2',
                'verbose_name': '\u0437\u0430\u043f\u0438\u0441\u044c \u0442\u0430\u0431\u043b\u043e',
                'verbose_name_plural': '\u0442\u0430\u0431\u043b\u043e'
            },
            bases=(models.Model, common.models_utils.DisplayTCodeMixin),
        ),
        migrations.CreateModel(
            name='RouteUidMap',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('new_uid', models.CharField(max_length=100,
                                             verbose_name='\u0421\u0442\u0430\u0440\u044b\u0439 uid \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430',
                                             db_index=True)),
                ('old_uid', models.CharField(max_length=100,
                                             verbose_name='\u041d\u043e\u0432\u044b\u0439 uid \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430',
                                             db_index=True)),
            ],
            options={
                'verbose_name': '\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0441\u0442\u0430\u0440\u043e\u0433\u043e \u0438 \u043d\u043e\u0432\u043e\u0433\u043e uid-\u043e\u0432 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430',
                'verbose_name_plural': '\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0438 \u043d\u043e\u0432\u044b\u0445 uid-\u043e\u0432 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='RThreadUidMap',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('new_uid', models.CharField(max_length=100,
                                             verbose_name='\u0421\u0442\u0430\u0440\u044b\u0439 uid \u043d\u0438\u0442\u043a\u0438',
                                             db_index=True)),
                ('old_uid', models.CharField(max_length=100,
                                             verbose_name='\u041d\u043e\u0432\u044b\u0439 uid \u043d\u0438\u0442\u043a\u0438',
                                             db_index=True)),
            ],
            options={
                'verbose_name': '\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0441\u0442\u0430\u0440\u043e\u0433\u043e \u0438 \u043d\u043e\u0432\u043e\u0433\u043e uid-\u043e\u0432 \u043d\u0438\u0442\u043a\u0438',
                'verbose_name_plural': '\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0438 \u043d\u043e\u0432\u044b\u0445 uid-\u043e\u0432 \u043d\u0438\u0442\u043e\u043a',
            },
        ),
        migrations.CreateModel(
            name='Timestamp',
            fields=[
                ('code', models.CharField(max_length=16, serialize=False, primary_key=True)),
                ('value', models.DateTimeField(null=True)),
            ],
        ),
        migrations.AddField(
            model_name='transportsubtype',
            name='color',
            field=models.ForeignKey(default=None, blank=True, to='www.TransportSubtypeColor', null=True, verbose_name='\u0426\u0432\u0435\u0442'),
        ),
        migrations.AddField(
            model_name='transportsubtype',
            name='t_type',
            field=models.ForeignKey(related_name='subtype', verbose_name='\u0422\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='transportmodel',
            name='producer',
            field=models.ForeignKey(default=None, blank=True, to='www.VehicleProducer', null=True, verbose_name='\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c'),
        ),
        migrations.AddField(
            model_name='transportmodel',
            name='t_subtype',
            field=models.ForeignKey(default=None, blank=True, to='www.TransportSubtype', null=True, verbose_name='\u043f\u043e\u0434\u0442\u0438\u043f'),
        ),
        migrations.AddField(
            model_name='transportmodel',
            name='t_type',
            field=models.ForeignKey(verbose_name='\u0442\u0438\u043f', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='stationtype',
            name='default_for_t_type',
            field=models.ForeignKey(null=True, default=None, to='www.TransportType', blank=True, unique=True, verbose_name='\u043f\u043e \u0443\u043c\u043e\u0447\u0430\u043d\u0438\u044e \u0434\u043b\u044f \u0442\u0438\u043f\u0430 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430'),
        ),
        migrations.AddField(
            model_name='stationpassage',
            name='terminal_from',
            field=models.ForeignKey(related_name='outgoing_passages', default=None, blank=True, to='www.StationTerminal', null=True, verbose_name='\u0441 \u043a\u0430\u043a\u043e\u0433\u043e \u0432\u044b\u0445\u043e\u0434\u0430'),
        ),
        migrations.AddField(
            model_name='stationpassage',
            name='terminal_to',
            field=models.ForeignKey(related_name='incoming_passages', default=None, blank=True, to='www.StationTerminal', null=True, verbose_name='\u0434\u043e \u043a\u0430\u043a\u043e\u0433\u043e \u0432\u044b\u0445\u043e\u0434\u0430'),
        ),
        migrations.AddField(
            model_name='station',
            name='majority',
            field=models.ForeignKey(verbose_name='\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u0441\u0442\u0430\u043d\u0446\u0438\u0438', to='www.StationMajority'),
        ),
        migrations.AddField(
            model_name='station',
            name='properties',
            field=models.ManyToManyField(default=None, to='www.StationProperty', verbose_name='\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430', blank=True),
        ),
        migrations.AddField(
            model_name='station',
            name='region',
            field=models.ForeignKey(default=None, blank=True, to='www.Region', null=True, verbose_name='\u043e\u0431\u043b\u0430\u0441\u0442\u044c'),
        ),
        migrations.AddField(
            model_name='station',
            name='settlement',
            field=models.ForeignKey(default=None, blank=True, to='www.Settlement', null=True, verbose_name='\u0433\u043e\u0440\u043e\u0434'),
        ),
        migrations.AddField(
            model_name='station',
            name='station_type',
            field=models.ForeignKey(default=12, verbose_name='\u0442\u0438\u043f \u0441\u0442\u0430\u043d\u0446\u0438\u0438', to='www.StationType'),
        ),
        migrations.AddField(
            model_name='station',
            name='suburban_zone',
            field=models.ForeignKey(default=None, blank=True, to='www.SuburbanZone', null=True, verbose_name='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430'),
        ),
        migrations.AddField(
            model_name='station',
            name='supplier',
            field=models.ForeignKey(default=None, blank=True, to='www.Supplier', null=True, verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a'),
        ),
        migrations.AddField(
            model_name='station',
            name='t_type',
            field=models.ForeignKey(default=1, verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='specialoffer',
            name='airport_from',
            field=models.ForeignKey(related_name='special_offers_from', verbose_name='\u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True, to='www.Station', null=True),
        ),
        migrations.AddField(
            model_name='specialoffer',
            name='airport_to',
            field=models.ForeignKey(related_name='special_offers_to', verbose_name='\u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', blank=True, to='www.Station', null=True),
        ),
        migrations.AddField(
            model_name='specialoffer',
            name='company',
            field=models.ForeignKey(verbose_name='\u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f', to='www.Company'),
        ),
        migrations.AddField(
            model_name='specialoffer',
            name='settlement_from',
            field=models.ForeignKey(related_name='special_offers_from', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', to='www.Settlement'),
        ),
        migrations.AddField(
            model_name='specialoffer',
            name='settlement_to',
            field=models.ForeignKey(related_name='special_offers_to', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', to='www.Settlement'),
        ),
        migrations.AddField(
            model_name='settlementrelatedstations',
            name='station',
            field=models.ForeignKey(related_name='related_settlements', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station'),
        ),
        migrations.AddField(
            model_name='settlement',
            name='properties',
            field=models.ManyToManyField(default=None, to='www.SettlementProperty', verbose_name='\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430', blank=True),
        ),
        migrations.AddField(
            model_name='settlement',
            name='region',
            field=models.ForeignKey(default=None, blank=True, to='www.Region', null=True, verbose_name='\u043e\u0431\u043b\u0430\u0441\u0442\u044c'),
        ),
        migrations.AddField(
            model_name='settlement',
            name='suburban_zone',
            field=models.ForeignKey(related_name='settlement_set', blank=True, to='www.SuburbanZone', help_text='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430, \u0432 \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u0432\u0445\u043e\u0434\u0438\u0442 \u0433\u043e\u0440\u043e\u0434', null=True, verbose_name='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430'),
        ),
        migrations.AddField(
            model_name='scheduleexclusion',
            name='end_station',
            field=models.ForeignKey(related_name='scheduleexclusion_end_set', verbose_name='\u041a\u043e\u043d\u0435\u0447\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430', to='www.Station'),
        ),
        migrations.AddField(
            model_name='scheduleexclusion',
            name='exclude_station',
            field=models.ForeignKey(verbose_name='\u0418\u0441\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u0430\u044f \u0441\u0442\u0430\u043d\u0438\u044f', to='www.Station'),
        ),
        migrations.AddField(
            model_name='scheduleexclusion',
            name='start_station',
            field=models.ForeignKey(related_name='scheduleexclusion_start_set', verbose_name='\u041d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430', to='www.Station'),
        ),
        migrations.AddField(
            model_name='rtstation',
            name='arrival_t_model',
            field=models.ForeignKey(related_name='arrival_rtstation_set', default=None, blank=True, to='www.TransportModel', null=True, verbose_name='\u043c\u043e\u0434\u0435\u043b\u044c \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f'),
        ),
        migrations.AddField(
            model_name='rtstation',
            name='departure_direction',
            field=models.ForeignKey(related_name='departure_rtstation_set', blank=True, to='www.Direction', help_text='\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', null=True, verbose_name='dep_direction'),
        ),
        migrations.AddField(
            model_name='rtstation',
            name='departure_t_model',
            field=models.ForeignKey(related_name='departure_rtstation_set', default=None, blank=True, to='www.TransportModel', null=True, verbose_name='\u043c\u043e\u0434\u0435\u043b\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f'),
        ),
        migrations.AddField(
            model_name='rtstation',
            name='next_station',
            field=models.ForeignKey(related_name='rtstation_next_station_set', verbose_name='\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station', null=True),
        ),
        migrations.AddField(
            model_name='rtstation',
            name='prev_station',
            field=models.ForeignKey(related_name='rtstation_prev_station_set', verbose_name='\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station', null=True),
        ),
        migrations.AddField(
            model_name='rtstation',
            name='station',
            field=models.ForeignKey(verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station'),
        ),
        migrations.AddField(
            model_name='rtstation',
            name='terminal',
            field=models.ForeignKey(default=None, blank=True, to='www.StationTerminal', null=True, verbose_name='\u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b'),
        ),
        migrations.AddField(
            model_name='rtstation',
            name='thread',
            field=models.ForeignKey(verbose_name='\u043d\u0438\u0442\u043a\u0430', to='www.RThread'),
        ),
        migrations.AddField(
            model_name='rthread',
            name='schedule_plan',
            field=models.ForeignKey(default=None, blank=True, to='www.TrainSchedulePlan', null=True, verbose_name='\u0433\u0440\u0430\u0444\u0438\u043a \u043f\u043e\u0435\u0437\u0434\u043e\u0432'),
        ),
        migrations.AddField(
            model_name='rthread',
            name='supplier',
            field=models.ForeignKey(default=None, blank=True, to='www.Supplier', null=True, verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a \u043d\u0438\u0442\u043a\u0438'),
        ),
        migrations.AddField(
            model_name='rthread',
            name='t_model',
            field=models.ForeignKey(verbose_name='\u043c\u043e\u0434\u0435\u043b\u044c', blank=True, to='www.TransportModel', null=True),
        ),
        migrations.AddField(
            model_name='rthread',
            name='t_subtype',
            field=models.ForeignKey(default=None, blank=True, to='www.TransportSubtype', null=True, verbose_name='\u041f\u043e\u0434\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430'),
        ),
        migrations.AddField(
            model_name='rthread',
            name='t_type',
            field=models.ForeignKey(verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='rthread',
            name='tariff_type',
            field=models.ForeignKey(default=None, blank=True, to='www.TariffType', null=True, verbose_name='\u0442\u0438\u043f \u0446\u0435\u043d \u043d\u0430 \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u043a\u0438'),
        ),
        migrations.AddField(
            model_name='rthread',
            name='type',
            field=models.ForeignKey(default=None, verbose_name='\u0442\u0438\u043f', to='www.RThreadType'),
        ),
        migrations.AddField(
            model_name='routepath',
            name='station_from',
            field=models.ForeignKey(related_name='routesegment_directions_from', blank=True, to='www.Station', help_text='\u043d\u0430\u0447\u0430\u043b\u043e \u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0443\u0447\u0430\u0441\u0442\u043a\u0430', null=True, verbose_name='\u043e\u0442 \u0441\u0442\u0430\u043d\u0446\u0438\u0438'),
        ),
        migrations.AddField(
            model_name='routepath',
            name='station_to',
            field=models.ForeignKey(related_name='routesegment_directions_to', blank=True, to='www.Station', help_text='\u043a\u043e\u043d\u0435\u0446 \u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0443\u0447\u0430\u0441\u0442\u043a\u0430', null=True, verbose_name='\u0434\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438'),
        ),
        migrations.AddField(
            model_name='routeimportinfo',
            name='supplier',
            field=models.ForeignKey(verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', to='www.Supplier'),
        ),
        migrations.AddField(
            model_name='routeimportinfo',
            name='t_type',
            field=models.ForeignKey(verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='route',
            name='supplier',
            field=models.ForeignKey(verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', blank=True, to='www.Supplier'),
        ),
        migrations.AddField(
            model_name='route',
            name='t_type',
            field=models.ForeignKey(verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='replaceexception',
            name='city_from',
            field=models.ForeignKey(related_name='city_from', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', to='www.Settlement'),
        ),
        migrations.AddField(
            model_name='replaceexception',
            name='city_to',
            field=models.ForeignKey(related_name='city_to', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', blank=True, to='www.Settlement', null=True),
        ),
        migrations.AddField(
            model_name='replaceexception',
            name='station_to',
            field=models.ForeignKey(related_name='station_to', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', blank=True, to='www.Station', null=True),
        ),
        migrations.AddField(
            model_name='gortranscitylink',
            name='city',
            field=models.ForeignKey(verbose_name='\u0433\u043e\u0440\u043e\u0434', to='www.Settlement'),
        ),
        migrations.AddField(
            model_name='facedirection',
            name='arrival_settlement',
            field=models.ForeignKey(related_name='arrival_facedirections', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', to='www.Settlement'),
        ),
        migrations.AddField(
            model_name='facedirection',
            name='departure_settlement',
            field=models.ForeignKey(related_name='departure_facedirections', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', to='www.Settlement'),
        ),
        migrations.AddField(
            model_name='facedirection',
            name='ttype',
            field=models.ForeignKey(verbose_name='\u0422\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='externaldirectionmarker',
            name='station',
            field=models.ForeignKey(verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station'),
        ),
        migrations.AddField(
            model_name='externaldirection',
            name='base_station',
            field=models.ForeignKey(verbose_name='\u0431\u0430\u0437\u043e\u0432\u044b\u0439 \u0432\u043e\u043a\u0437\u0430\u043b', blank=True, to='www.Station', null=True),
        ),
        migrations.AddField(
            model_name='externaldirection',
            name='suburban_zone',
            field=models.ForeignKey(blank=True, to='www.SuburbanZone', help_text='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430, \u0432 \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u0432\u0445\u043e\u0434\u0438\u0442 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435', null=True, verbose_name='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430'),
        ),
        migrations.AddField(
            model_name='expressnumber',
            name='supplier',
            field=models.ForeignKey(verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', to='www.Supplier'),
        ),
        migrations.AddField(
            model_name='district',
            name='region',
            field=models.ForeignKey(verbose_name='\u043e\u0431\u043b\u0430\u0441\u0442\u044c', to='www.Region'),
        ),
        migrations.AddField(
            model_name='district',
            name='settlement',
            field=models.ForeignKey(related_name='districts', default=None, blank=True, to='www.Settlement', null=True, verbose_name='\u0433\u043e\u0440\u043e\u0434'),
        ),
        migrations.AddField(
            model_name='directionmarker',
            name='station',
            field=models.ForeignKey(blank=True, to='www.Station', help_text='\u0435\u0441\u043b\u0438 \u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430, \u0442\u043e \u044d\u0442\u043e \u0441\u0442\u0440\u0435\u043b\u043a\u0430', null=True, verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f'),
        ),
        migrations.AddField(
            model_name='direction',
            name='suburban_zone',
            field=models.ForeignKey(blank=True, to='www.SuburbanZone', help_text='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430, \u0432 \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u0432\u0445\u043e\u0434\u0438\u0442 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435', null=True, verbose_name='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430'),
        ),
        migrations.AddField(
            model_name='defaultpoint',
            name='settlement',
            field=models.ForeignKey(verbose_name='\u0413\u043e\u0440\u043e\u0434', blank=True, to='www.Settlement', null=True),
        ),
        migrations.AddField(
            model_name='defaultpoint',
            name='station',
            field=models.ForeignKey(verbose_name='\u0421\u0442\u0430\u043d\u0446\u0438\u044f', blank=True, to='www.Station', null=True),
        ),
        migrations.AddField(
            model_name='companyoffice',
            name='main_station',
            field=models.ForeignKey(default=None, blank=True, to='www.Station', null=True, verbose_name='\u0413\u043b\u0430\u0432\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f'),
        ),
        migrations.AddField(
            model_name='companyoffice',
            name='settlement',
            field=models.ForeignKey(verbose_name='\u0413\u043e\u0440\u043e\u0434', to='www.Settlement'),
        ),
        migrations.AddField(
            model_name='company',
            name='country',
            field=models.ForeignKey(default=None, blank=True, to='www.Country', null=True, verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430'),
        ),
        migrations.AddField(
            model_name='company',
            name='home_station',
            field=models.ForeignKey(verbose_name='\u0433\u043b\u0430\u0432\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', blank=True, to='www.Station', null=True),
        ),
        migrations.AddField(
            model_name='company',
            name='t_type',
            field=models.ForeignKey(default=None, blank=True, to='www.TransportType', null=True, verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430'),
        ),
        migrations.AddField(
            model_name='aeroextariff',
            name='station_from',
            field=models.ForeignKey(db_index=False, related_name='aeroex_tariffs_from', verbose_name='\u043f\u0435\u0440\u0432\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station'),
        ),
        migrations.AddField(
            model_name='aeroextariff',
            name='station_to',
            field=models.ForeignKey(db_index=False, related_name='aeroex_tariffs_to', verbose_name='\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station'),
        ),
        migrations.AddField(
            model_name='aeroextariff',
            name='type',
            field=models.ForeignKey(default=1, to='www.TariffType'),
        ),
        migrations.AlterField(
            model_name='aeroextariff',
            name='station_from',
            field=models.ForeignKey(related_name='aeroex_tariffs_from',
                                    verbose_name='\u043f\u0435\u0440\u0432\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f',
                                    to='www.Station'),
        ),
        migrations.AlterIndexTogether(
            name='znoderoute2',
            index_together=set([('settlement_from', 'settlement_to'), ('settlement_from', 'station_to'), ('station_from', 'settlement_to'), ('station_from', 'station_to')]),
        ),
        migrations.AlterUniqueTogether(
            name='trainpseudostationmap',
            unique_together=set([('number', 'station')]),
        ),
        migrations.AlterUniqueTogether(
            name='stationcode',
            unique_together=set([('system', 'code'), ('station', 'system')]),
        ),
        migrations.AlterUniqueTogether(
            name='settlementcode',
            unique_together=set([('system', 'code'), ('settlement', 'system')]),
        ),
        migrations.AlterUniqueTogether(
            name='rthread',
            unique_together=set([('route', 'ordinal_number')]),
        ),
        migrations.AlterUniqueTogether(
            name='routeimportinfo',
            unique_together=set([('number', 'supplier')]),
        ),
        migrations.AlterUniqueTogether(
            name='route2company',
            unique_together=set([('number', 'company')]),
        ),
        migrations.AlterUniqueTogether(
            name='route',
            unique_together=set([('route_uid', 't_type', 'supplier')]),
        ),
        migrations.AlterUniqueTogether(
            name='externaldirectionmarker',
            unique_together=set([('external_direction', 'order'), ('external_direction', 'station')]),
        ),
        migrations.AlterUniqueTogether(
            name='directionmarker',
            unique_together=set([('direction', 'order'), ('direction', 'station')]),
        ),
        migrations.AlterUniqueTogether(
            name='aeroextariff',
            unique_together=set([('station_from', 'station_to', 'type', 'precalc')]),
        ),
        migrations.AlterUniqueTogether(
            name='ztablo2',
            unique_together=set([('station', 'arrival', 'route'), ('station', 'departure', 'route')]),
        ),
    ]
