# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from datetime import datetime

from django.db import migrations, models


class Migration(migrations.Migration):
    # Избегаем циклических зависимостей, делаем ссылки на другие сабмодули тут.

    dependencies = [
        ('importinfo', '0001_initial'),
        ('red', '0001_initial'),
        ('currency', '0001_initial'),
        ('www', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='country',
            name='currency',
            field=models.ForeignKey(default=None, blank=True, to='currency.Currency', null=True, verbose_name='\u0432\u0430\u043b\u044e\u0442\u0430'),
        ),
        migrations.AddField(
            model_name='route',
            name='red_metaroute',
            field=models.ForeignKey(default=None, blank=True, to='red.MetaRoute', null=True),
        ),
        migrations.AddField(
            model_name='route',
            name='triangle_package',
            field=models.ForeignKey(default=None, blank=True, to='importinfo.TriangleBusImportPackage', null=True),
        ),
        migrations.AddField(
            model_name='route',
            name='two_stage_package',
            field=models.ForeignKey(default=None, blank=True, to='importinfo.TwoStageImportPackage', null=True),
        ),
        migrations.AddField(
            model_name='znoderoute2',
            name='two_stage_package',
            field=models.ForeignKey(default=None, blank=True, to='importinfo.TwoStageImportPackage', null=True),
        ),
        migrations.SeparateDatabaseAndState([
            migrations.RunSQL(
                'ALTER TABLE `www_country` ADD `modified_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;',
                'ALTER TABLE `www_country` DROP COLUMN `modified_at`;'
            ),
            migrations.RunSQL(
                'ALTER TABLE `www_region` ADD `modified_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;',
                'ALTER TABLE `www_region` DROP COLUMN `modified_at`;'
            ),
            migrations.RunSQL(
                'ALTER TABLE `www_route` ADD `modified_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;',
                'ALTER TABLE `www_route` DROP COLUMN `modified_at`;'
            ),
            migrations.RunSQL(
                'ALTER TABLE `www_rthread` ADD `modified_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;',
                'ALTER TABLE `www_rthread` DROP COLUMN `modified_at`;'
            ),
            migrations.RunSQL(
                'ALTER TABLE `www_settlement` ADD `modified_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;',
                'ALTER TABLE `www_settlement` DROP COLUMN `modified_at`;'
            ),
            migrations.RunSQL(
                'ALTER TABLE `www_station` ADD `modified_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;',
                'ALTER TABLE `www_station` DROP COLUMN `modified_at`;'
            ),
        ], [
            migrations.AddField(
                model_name='country',
                name='modified_at',
                field=models.DateTimeField(default=datetime.now(),
                                           verbose_name='\u0414\u0430\u0442\u0430-\u0432\u0440\u0435\u043c\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f',
                                           auto_now=True),
                preserve_default=False,
            ),
            migrations.AddField(
                model_name='region',
                name='modified_at',
                field=models.DateTimeField(default=datetime.now(),
                                           verbose_name='\u0414\u0430\u0442\u0430-\u0432\u0440\u0435\u043c\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f',
                                           auto_now=True),
                preserve_default=False,
            ),
            migrations.AddField(
                model_name='route',
                name='modified_at',
                field=models.DateTimeField(default=datetime.now(),
                                           verbose_name='\u0414\u0430\u0442\u0430-\u0432\u0440\u0435\u043c\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f',
                                           auto_now=True),
                preserve_default=False,
            ),
            migrations.AddField(
                model_name='rthread',
                name='modified_at',
                field=models.DateTimeField(default=datetime.now(),
                                           verbose_name='\u0414\u0430\u0442\u0430-\u0432\u0440\u0435\u043c\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f',
                                           auto_now=True),
                preserve_default=False,
            ),
            migrations.AddField(
                model_name='settlement',
                name='modified_at',
                field=models.DateTimeField(default=datetime.now(),
                                           verbose_name='\u0414\u0430\u0442\u0430-\u0432\u0440\u0435\u043c\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f',
                                           auto_now=True),
                preserve_default=False,
            ),
            migrations.AddField(
                model_name='station',
                name='modified_at',
                field=models.DateTimeField(default=datetime.now(),
                                           verbose_name='\u0414\u0430\u0442\u0430-\u0432\u0440\u0435\u043c\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f',
                                           auto_now=True),
                preserve_default=False,
            ),

        ])
    ]
