# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models


SETTING_CODE = 'AGENT_PART_LENGTH'


def forward(apps, schema_editor):
    if settings.IS_BLANK_TEST_DB:
        return

    Setting = apps.get_model('www', 'Setting')

    Setting.objects.create(
        type='int', value='20',
        name=u'Максимальной длина запроса расписаний Агента',
        code=SETTING_CODE
    )


def backward(apps, schema_editor):
    if settings.IS_BLANK_TEST_DB:
        return

    Setting = apps.get_model('www', 'Setting')
    Setting.objects.get(code=SETTING_CODE).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0002_refs_to_other_submodules_and_custom_fields'),
    ]

    operations = [
        migrations.RunPython(forward, backward)
    ]
