# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import common.utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0003_agent_part_length'),
    ]

    operations = [
        migrations.RunSQL(
            sql="""
                ALTER TABLE `www_threadtariff`
                    ADD COLUMN `settlement_from_id` integer NULL,
                    ADD COLUMN `settlement_to_id` integer NULL,
                    ADD COLUMN `year_days_from` longtext NOT NULL,
                    ADD COLUMN `time_from` time NOT NULL DEFAULT '00:00:00',
                    ADD COLUMN `time_zone_from` varchar(30) NOT NULL DEFAULT 'Europe/Moscow',
                    ADD COLUMN `duration` integer NOT NULL DEFAULT 0,
                    ADD COLUMN `time_to` time NOT NULL DEFAULT '00:00:00',
                    ADD COLUMN `time_zone_to` varchar(30) NOT NULL DEFAULT 'Europe/Moscow',
                    ADD COLUMN `supplier_id` integer NOT NULL DEFAULT 1,
                    ADD COLUMN `number` varchar(100) NOT NULL DEFAULT '',
                    ADD COLUMN `t_type_id` integer NOT NULL DEFAULT 3,
                    ADD CONSTRAINT `www_threadtariff__settlement_from_id__fk` FOREIGN KEY (`settlement_from_id`) REFERENCES `www_settlement` (`id`),
                    ADD CONSTRAINT `www_threadtariff__settlement_to_id__fk` FOREIGN KEY (`settlement_to_id`) REFERENCES `www_settlement` (`id`),
                    ADD CONSTRAINT `www_threadtariff__supplier_id__fk` FOREIGN KEY (`supplier_id`) REFERENCES `www_supplier` (`id`),
                    ADD CONSTRAINT `www_threadtariff__t_type_id__fk` FOREIGN KEY (`t_type_id`) REFERENCES `www_transporttype` (`id`),
                    ADD INDEX (`settlement_from_id`),
                    ADD INDEX (`settlement_to_id`),
                    ADD INDEX (`supplier_id`),
                    ADD INDEX (`t_type_id`);
                ALTER TABLE `www_threadtariff`
                    ALTER COLUMN `time_from` DROP DEFAULT,
                    ALTER COLUMN `time_zone_from` DROP DEFAULT,
                    ALTER COLUMN `duration` DROP DEFAULT,
                    ALTER COLUMN `time_to` DROP DEFAULT,
                    ALTER COLUMN `time_zone_to` DROP DEFAULT,
                    ALTER COLUMN `supplier_id` DROP DEFAULT,
                    ALTER COLUMN `t_type_id` DROP DEFAULT;""",
            reverse_sql="""
                ALTER TABLE `www_threadtariff`
                    DROP FOREIGN KEY `www_threadtariff__t_type_id__fk`,
                    DROP FOREIGN KEY `www_threadtariff__supplier_id__fk`,
                    DROP FOREIGN KEY `www_threadtariff__settlement_from_id__fk`,
                    DROP FOREIGN KEY `www_threadtariff__settlement_to_id__fk`,
                    DROP COLUMN `settlement_from_id` CASCADE,
                    DROP COLUMN `settlement_to_id` CASCADE,
                    DROP COLUMN `year_days_from` CASCADE,
                    DROP COLUMN `time_from` CASCADE,
                    DROP COLUMN `time_zone_from` CASCADE,
                    DROP COLUMN `time_to` CASCADE,
                    DROP COLUMN `duration` CASCADE,
                    DROP COLUMN `time_zone_to` CASCADE,
                    DROP COLUMN `supplier_id` CASCADE,
                    DROP COLUMN `number` CASCADE,
                    DROP COLUMN `t_type_id` CASCADE;""",
            state_operations=[
                migrations.AddField(
                    model_name='threadtariff',
                    name='duration',
                    field=models.IntegerField(verbose_name='\u0412\u0440\u0435\u043c\u044f \u0432 \u043f\u0443\u0442\u0438 (\u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445).'),
                ),
                migrations.AddField(
                    model_name='threadtariff',
                    name='number',
                    field=models.CharField(default='', max_length=100, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430', blank=True),
                ),
                migrations.AddField(
                    model_name='threadtariff',
                    name='settlement_from',
                    field=models.ForeignKey(related_name='tariffs_from', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438', to='www.Settlement', null=True),
                ),
                migrations.AddField(
                    model_name='threadtariff',
                    name='settlement_to',
                    field=models.ForeignKey(related_name='tariffs_to', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', to='www.Settlement', null=True),
                ),
                migrations.AddField(
                    model_name='threadtariff',
                    name='supplier',
                    field=models.ForeignKey(verbose_name='\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a \u0442\u0430\u0440\u0438\u0444\u0430', to='www.Supplier'),
                ),
                migrations.AddField(
                    model_name='threadtariff',
                    name='t_type',
                    field=models.ForeignKey(verbose_name='\u0422\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
                ),
                migrations.AddField(
                    model_name='threadtariff',
                    name='time_from',
                    field=models.TimeField(verbose_name='\u0412\u0440\u0435\u043c\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0437\u043e\u043d\u044b'),
                ),
                migrations.AddField(
                    model_name='threadtariff',
                    name='time_to',
                    field=models.TimeField(verbose_name='\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0437\u043e\u043d\u044b'),
                ),
                migrations.AddField(
                    model_name='threadtariff',
                    name='time_zone_from',
                    field=models.CharField(max_length=30, verbose_name='\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f'),
                ),
                migrations.AddField(
                    model_name='threadtariff',
                    name='time_zone_to',
                    field=models.CharField(max_length=30, verbose_name='\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f'),
                ),
                migrations.AddField(
                    model_name='threadtariff',
                    name='year_days_from',
                    field=common.utils.fields.ThreadCalendarField(default=b'000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', verbose_name='\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c \u0432\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0437\u043e\u043d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f'),
                ),
                migrations.AlterField(
                    model_name='threadtariff',
                    name='thread_uid',
                    field=models.CharField(help_text='\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0437\u043d\u0430\u0447\u043d\u043e\u0433\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043d\u0438\u0442\u043a\u0438', max_length=100, verbose_name='\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440', db_index=True),
                ),
                migrations.AlterField(
                    model_name='threadtariff',
                    name='station_from',
                    field=models.ForeignKey(related_name='route_tariffs_from', verbose_name='\u041f\u0435\u0440\u0432\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station'),
                ),
                migrations.AlterField(
                    model_name='threadtariff',
                    name='station_to',
                    field=models.ForeignKey(related_name='route_tariffs_to', verbose_name='\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station'),
                ),
                migrations.AlterField(
                    model_name='threadtariff',
                    name='year_days',
                    field=common.utils.fields.ThreadCalendarField(default='', verbose_name='\u0428\u0430\u0431\u043b\u043e\u043d \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u0434\u043d\u0435\u0439 \u043a\u043e\u0433\u0434\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u044d\u0442\u0430 \u0446\u0435\u043d\u0430'),
                ),
            ]
        ),
    ]
