# -*- coding: utf-8 -*-

import logging

from django.db import migrations


def run(apps, schema_editor):
    log = logging.getLogger('www.migrations')
    try:
        from travel.rasp.admin.scripts.single.raspfront_1825_fill_thread_tariff import fill_thread_tariff
    except ImportError:
        log.error(u'Не получилось импортировать скрипт заполнения тарифов точка-точка.')
    else:
        fill_thread_tariff(log)


class Migration(migrations.Migration):
    dependencies = [
        ('www', '0004_threadtariff_new_fields'),
    ]

    operations = [
        migrations.RunPython(run),
    ]
