# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


HIGH_SPEED_TRAIN_TITLES = (u'Сапсан', u'Ласточка', u'Стриж')


def fill_high_speed(apps, schema_editor):
    apps.get_model('www', 'deluxetrain').objects.filter(title_ru__in=HIGH_SPEED_TRAIN_TITLES).update(high_speed=True)


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0007_tariff_groups'),
    ]

    operations = [
        migrations.SeparateDatabaseAndState(state_operations=[
            migrations.RemoveField(
                model_name='deluxetrain',
                name='plain_title',
            )
        ]),
        migrations.AlterField(
            model_name='deluxetrain',
            name='deluxe',
            field=models.BooleanField(default=False, verbose_name='\u0444\u0438\u0440\u043c\u0435\u043d\u043d\u044b\u0439'),
        ),
        migrations.AddField(
            model_name='deluxetrain',
            name='high_speed',
            field=models.BooleanField(default=False, verbose_name='\u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0439'),
        ),
        migrations.RunPython(fill_high_speed, migrations.RunPython.noop),
    ]
