# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import common.utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0012_fix_default_for_t_type_relation'),
    ]

    operations = [
        migrations.RunSQL(
            sql="""ALTER TABLE `www_rthread`
                    MODIFY COLUMN `title` varchar(200) NULL,
                    MODIFY COLUMN `title_short` varchar(200) NULL,
                    MODIFY COLUMN `title_tr` varchar(200) NULL,
                    MODIFY COLUMN `title_uk` varchar(200) NULL;""",

            state_operations=[
                migrations.AlterField(
                    model_name='rthread',
                    name='title',
                    field=models.CharField(max_length=200, null=True, verbose_name='название'),
                ),
                migrations.AlterField(
                    model_name='rthread',
                    name='title_short',
                    field=models.CharField(default=None, max_length=200, null=True, verbose_name='название короткое', blank=True),
                ),
                migrations.AlterField(
                    model_name='rthread',
                    name='title_tr',
                    field=common.utils.fields.TrimmedCharField(db_index=True, max_length=200, null=True, verbose_name='Turkish title', blank=True),
                ),
                migrations.AlterField(
                    model_name='rthread',
                    name='title_uk',
                    field=common.utils.fields.TrimmedCharField(db_index=True, max_length=200, null=True, verbose_name='Украинское ручное название', blank=True),
                )
            ]
        ),
    ]
