# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models

from travel.rasp.admin.lib.migrations import drop_field_if_exists, drop_table_if_exists


def remove_old_fields(apps, schema_editor):
    # https://st.yandex-team.ru/RASPADMIN-1143
    # Удалить www_deluxetrain.plain_title из базы
    drop_field_if_exists(schema_editor, 'www_deluxetrain', 'plain_title')

    # https://st.yandex-team.ru/RASPADMIN-1091
    # Удалить поле "name" в ContentType
    drop_field_if_exists(schema_editor, 'django_content_type', 'name')

    # https://st.yandex-team.ru/RASPADMIN-940
    # Удалить колонку use_cysix из базы
    drop_field_if_exists(schema_editor, 'www_supplier', 'use_cysix')

    # https://st.yandex-team.ru/RASPADMIN-929
    # Удалить таблицу ztablorule из базы, из кода уже удалил
    drop_table_if_exists(schema_editor, 'www_tablorules')


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0016_company_permission_other_small_changes'),
    ]

    operations = [
        migrations.RunPython(remove_old_fields, migrations.RunPython.noop)
    ]
