# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models

from travel.rasp.admin.lib.migrations import drop_table_if_exists, drop_field_if_exists


def remove_old_fields_and_tables(apps, schema_editor):
    # https://st.yandex-team.ru/RASPADMIN-339
    # Удалить реальные поля из админки

    # https://github.yandex-team.ru/rasp/admin/blob/release-3.10.60/www/migrations/0402_fake__del_teaserthread__del_field_teaser_settlement__del_field_teaser_.py
    # # Deleting model 'TeaserThread'
    # db.delete_table('www_teaserthread')
    drop_table_if_exists(schema_editor, 'www_teaserthread')

    # # Deleting field 'Teaser.settlement'
    # db.delete_column('www_teaser', 'settlement_id')
    drop_field_if_exists(schema_editor, 'www_teaser', 'settlement_id')

    # # Deleting field 'Teaser.station'
    # db.delete_column('www_teaser', 'station_id')
    drop_field_if_exists(schema_editor, 'www_teaser', 'station_id')

    # # Deleting field 'Teaser.direction'
    # db.delete_column('www_teaser', 'direction_id')
    drop_field_if_exists(schema_editor, 'www_teaser', 'direction_id')

    # https://github.yandex-team.ru/rasp/admin/blob/release-3.10.60/staticpages/migrations/0074_alter_fields_and_fake_delete.py
    # Удаляем в www т.к. этих полей все равно не будет в базе созданной с нуля
    # # Deleting field 'Partner.lang'
    # db.delete_column('staticpages_partner', 'lang')
    drop_field_if_exists(schema_editor, 'staticpages_partner', 'lang')
    # # Deleting field 'StaticPage.lang'
    # db.delete_column('staticpages_staticpage', 'lang')
    drop_field_if_exists(schema_editor, 'staticpages_staticpage', 'lang')

    # https://st.yandex-team.ru/RASPADMIN-422
    # Удалить поле из базы
    # https://github.yandex-team.ru/rasp/admin/blob/release-3.10.60/www/migrations/0412_fake__del_field_teaser_moscow_region.py
    # Deleting field 'Teaser.moscow_region'
    # db.delete_column('www_teaser', 'moscow_region')
    drop_field_if_exists(schema_editor, 'www_teaser', 'moscow_region')

    # https://st.yandex-team.ru/RASPADMIN-583
    # Фактически удалить старую таблицу из базы
    # https://github.yandex-team.ru/rasp/admin/blob/release-3.10.60/www/migrations/0422_auto__del_ztablo.py
    # Deleting model 'ZTablo'
    # db.delete_table('z_tablo')
    drop_table_if_exists(schema_editor, 'z_tablo')

    # https://st.yandex-team.ru/RASPADMIN-846
    # Удалить неиспользуемые колонки в TransportSubType
    # https://github.yandex-team.ru/rasp/admin/blob/release-3.10.60/www/migrations/0444_fake__delete_transport_subtype_columns.py
    # # Deleting field 'TransportSubtype.supplier_title'
    # db.delete_column('www_transportsubtype', 'supplier_title')
    drop_field_if_exists(schema_editor, 'www_transportsubtype', 'supplier_title')

    # # Deleting field 'TransportSubtype.title'
    # db.delete_column('www_transportsubtype', 'title')
    drop_field_if_exists(schema_editor, 'www_transportsubtype', 'title')

    # # Deleting field 'TransportSubtype.supplier'
    # db.delete_column('www_transportsubtype', 'supplier_id')
    drop_field_if_exists(schema_editor, 'www_transportsubtype', 'supplier_id')


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0017_remove_old_fileds'),
    ]

    operations = [
        migrations.RunPython(remove_old_fields_and_tables, migrations.RunPython.noop)
    ]
