# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models

from travel.rasp.admin.lib.migrations import drop_table_if_exists


def remove_old_fields_and_tables(apps, schema_editor):
    # Таблицы уже были перенесены в importinfo_afschedulefile и importinfo_afupdatefile
    drop_table_if_exists(schema_editor, 'www_afschedulefile')
    drop_table_if_exists(schema_editor, 'www_afupdatefile')

    # Не нашел использования
    drop_table_if_exists(schema_editor, 'back_namesearchindex')
    drop_table_if_exists(schema_editor, 'back_suggest')

    # Не нашел использования
    drop_table_if_exists(schema_editor, 'sochi2014_promodirection')
    drop_table_if_exists(schema_editor, 'sochi2014_promopage')


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0022_company_tis_code'),
    ]

    operations = [
        migrations.RunPython(remove_old_fields_and_tables, migrations.RunPython.noop)
    ]
