# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import uuid


def gen_teasers_uuid(apps, schema_editor):
    teasers_model = apps.get_model('www', 'Teaser')
    for obj in teasers_model.objects.all():
        obj.uid = uuid.uuid4()
        obj.save()


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0023_delete_not_usedd_tables'),
    ]

    operations = [
        migrations.AddField(
            model_name='teaser',
            name='uid',
            field=models.UUIDField(default=uuid.uuid4, null=True),
        ),
        migrations.RunPython(gen_teasers_uuid, reverse_code=migrations.RunPython.noop),
        migrations.AlterField(
            model_name='teaser',
            name='uid',
            field=models.UUIDField(default=uuid.uuid4, unique=True),
        ),
    ]
