# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from django.db.migrations.operations.special import SeparateDatabaseAndState

from common.utils import uuid64_int
from common.utils.fields import UUID64Field


def gen_teasers_uuid(apps, schema_editor):
    teasers_model = apps.get_model('www', 'Teaser')
    for obj in teasers_model.objects.all():
        obj.uid64 = uuid64_int()
        obj.save()


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0024_add_teasers_uids'),
    ]

    operations = [
        migrations.AddField(
            model_name='teaser',
            name='uid64',
            field=UUID64Field(default=uuid64_int, null=True),
        ),
        migrations.RunPython(gen_teasers_uuid, reverse_code=migrations.RunPython.noop),
        migrations.AlterField(
            model_name='teaser',
            name='uid64',
            field=UUID64Field(default=uuid64_int, null=True, unique=True),
        ),
        migrations.AlterField(
            model_name='teaser',
            name='uid',
            field=models.UUIDField(default=None, null=True),
        ),
        SeparateDatabaseAndState(state_operations=[
            migrations.RemoveField(
                model_name='teaser',
                name='uid',
            ),
        ]),
    ]
