# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import common.utils.fields


def change_stations_forecast_flag(apps, schema_editor):
    stations_model = apps.get_model('www', 'station')
    for obj in stations_model.objects.all():
        obj.use_in_forecast = False
        obj.save()


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0027_add_suburban_forecast_flags'),
    ]

    operations = [
        migrations.AlterField(
            model_name='station',
            name='use_in_forecast',
            field=models.BooleanField(default=False, verbose_name='использовать при прогнозировании опозданий для поездов, которые не пришли на следующую станцию'),
        ),
        migrations.RunPython(change_stations_forecast_flag, reverse_code=migrations.RunPython.noop),
    ]
