# -*- coding: utf-8 -*-
# Generated by Django 1.9.12 on 2017-09-27 03:10
from __future__ import unicode_literals

import common.utils.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0032_transport_subtype_add_title_short'),
    ]

    operations = [
        migrations.CreateModel(
            name='TrainTurnover',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_date', models.DateField(blank=True, null=True, verbose_name='Начало хождения шаблона')),
                ('end_date', models.DateField(blank=True, null=True, verbose_name='Конец хождения шаблона')),
                ('template_code', models.CharField(blank=True, default=None, max_length=100, null=True,
                                                   verbose_name='Код шаблона дней хождений')),
                ('year_days', common.utils.fields.ThreadCalendarField(
                    default=b'00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
                            b'00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
                            b'00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
                            b'00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
                            b'0000000000000000', verbose_name='Дни хождений')),
                ('number_before', models.CharField(blank=True, db_index=True, default='', max_length=100,
                                                   verbose_name='Номер')),
                ('number_after', models.CharField(blank=True, db_index=True, default='', max_length=100,
                                                  verbose_name='Номер')),
                ('graph', models.ForeignKey(blank=True, default=None, null=True,
                                            on_delete=django.db.models.deletion.CASCADE,
                                            to='www.TrainSchedulePlan', verbose_name='График поездов')),
                ('station', models.ForeignKey(blank=True, null=True,
                                              on_delete=django.db.models.deletion.CASCADE,
                                              to='www.Station', verbose_name='Станция оборота')),
            ],
            options={
                'verbose_name': 'Оборот поезда',
                'verbose_name_plural': 'Обороты поездов',
            },
        ),
        migrations.AlterUniqueTogether(
            name='trainturnover',
            unique_together=set([('number_before', 'station', 'template_code', 'graph')]),
        ),
    ]
