# -*- coding: utf-8 -*-
# Generated by Django 1.9.12 on 2018-04-27 16:08
from __future__ import unicode_literals

from django.db import migrations

from travel.rasp.admin.lib import tmpfiles
from travel.rasp.admin.lib.mysqlutils import MysqlModelUpdater


def change_slugs(apps, schema_editor):
    stations_model = apps.get_model('www', 'station')
    tmp_dir = tmpfiles.get_tmp_dir()
    fields = ['slug']
    with MysqlModelUpdater(stations_model, tmp_dir, fields=fields) as station_updater:
        for point in stations_model.objects.all():
            if point.slug:
                point.slug = point.slug.lower()
                station_updater.add(point)
    settlements_model = apps.get_model('www', 'settlement')
    with MysqlModelUpdater(settlements_model, tmp_dir, fields=fields) as settlement_updater:
        for point in settlements_model.objects.all():
            if point.slug:
                point.slug = point.slug.lower()
                settlement_updater.add(point)


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0036_add_slugs'),
    ]

    operations = [
        migrations.RunPython(change_slugs, reverse_code=migrations.RunPython.noop),
    ]
