# -*- coding: utf-8 -*-

import logging

from django.db import models
from django.utils.translation import ugettext_lazy as _


log = logging.getLogger(__name__)


class TicketOffice(models.Model):
    u""" Билетная касса"""
    title = models.CharField(verbose_name=_(u"название"), max_length=200,
                             null=False, blank=False)
    settlement = models.ForeignKey('www.Settlement', null=False, blank=False,
                                   verbose_name=_(u"город"))
    postal_code = models.CharField(verbose_name=_(u"почтовый индекс"), max_length=200,
                                   null=True, blank=True, default=None)
    address = models.CharField(verbose_name=_(u"адрес"), max_length=200,
                               null=True, blank=True, default=None)
    home_number = models.CharField(verbose_name=_(u"дом"), max_length=100,
                                   null=True, blank=True, default=None)
    address2 = models.CharField(verbose_name=_(u"доп. Адрес"), max_length=200,
                                null=True, blank=True, default=None)
    phone = models.CharField(verbose_name=_(u"телефон"), max_length=100,
                             null=True, blank=True, default=None)
    fax = models.CharField(verbose_name=_(u"факс"), max_length=100,
                           null=True, blank=True, default=None)
    home_site = models.CharField(verbose_name=_(u"сайт"), max_length=100,
                                 null=True, blank=True, default=None)
    email = models.EmailField(verbose_name=_(u"электронная почта"), max_length=100,
                              null=True, blank=True, default=None)
    plane = models.BooleanField(verbose_name=_(u"на самолет"),
                                null=False, blank=False, default=False)
    train = models.BooleanField(verbose_name=_(u"на поезд"),
                                null=False, blank=False, default=False)
    companies = models.TextField(verbose_name=_(u'транспортные компании'),
                                 null=True, blank=True, default=None)
    longitude = models.FloatField(verbose_name=_(u"долгота"), default=None,
                                  blank=True, null=True)
    latitude = models.FloatField(verbose_name=_(u"широта"), default=None,
                                 blank=True, null=True)

    def __unicode__(self):
        return self.title + u" в " + self.settlement.title

    class Meta:
        ordering = ('title',)
        verbose_name = _(u'билетная касса')
        verbose_name_plural = _(u'билетные кассы')
        app_label = 'www'


