# coding: utf-8
from __future__ import absolute_import

from django.http import QueryDict

from travel.rasp.admin.lib.jinja import Library


jinja = Library()


@jinja.callable
def class_attribute(*classes):
    """
    Вставляет аттрибут class(с пробелом перед ним)
    с переданными именами классов. Если переданы значения,
    приводящиеся к False, то они не добавляются.
    Если никаких правильных классов не передано, то возвращается
    пустая строка.
    """
    class_name = " ".join(cls for cls in classes if cls)

    if class_name:
        return ' class="%s"' % class_name

    return ''


@jinja.callable
def url(view_name, *args, **kwargs):
    urlconf = kwargs.pop('urlconf', None)

    from django.core.urlresolvers import reverse, NoReverseMatch

    try:
        return reverse(view_name, urlconf=urlconf, args=args, kwargs=kwargs)
    except NoReverseMatch:
        # Пробуем урлы основной версии
        return reverse(view_name, urlconf='urls', args=args, kwargs=kwargs)


class Positional(object):
    def __init__(self, index, value):
        self.index = index
        self.value = value

    @classmethod
    def get(cls, request_get, name, index):
        try:
            return request_get.getlist(name)[index]
        except IndexError:
            return None


ONE_SHOT_PARAMS = ['noDirect']


@jinja.callable
def get_params(query_dict=None, escape=True, **params):
    """
    Параметры со значением None удаляются из исходных (если они там есть)
    """
    if query_dict:
        new_params = query_dict.copy()
        for param in ONE_SHOT_PARAMS:
            if param in new_params:
                del new_params[param]
    else:
        new_params = QueryDict(None, mutable=True)

    for name, value in params.items():
        if value is None:
            if name in new_params:
                del(new_params[name])
        elif isinstance(value, Positional):
            values = new_params.getlist(name)

            # Удлинняем массив, если в него не входит нужный индекс
            if len(values) < value.index + 1:
                values.extend([''] * (value.index + 1 - len(values)))

            values[value.index] = value.value
            new_params.setlist(name, values)
        elif isinstance(value, list):
            new_params.setlist(name, value)
        elif value is not False:
            new_params[name] = value

    query_string = new_params.urlencode()

    if escape:
        query_string = query_string.replace('&', '&amp;')

    return '?' + query_string
