# coding: utf-8
from __future__ import absolute_import

from django import template


register = template.Library()


@register.inclusion_tag('admin/quick_tree_add_obj.html', takes_context=True)
def quick_tree_add_obj(context, object_type, add_object_params):
    """ Возвращает строку - урл для добавления соответствующего объекта """
    context['add_object_class'] = object_type
    context['add_object_class_title'] = ({'country': u'страну',
                                          'region': u'область(регион)',
                                          'settlement': u'город',
                                          'station': u'станцию',
                                          'stationphone': u'телефон станции'}).get(object_type, '')
    context['add_object_params'] = add_object_params
    return context
