# coding: utf-8
from __future__ import absolute_import

from django import template


register = template.Library()


@register.inclusion_tag('admin/quick_tree_nav.html', takes_context=True)
def quick_tree_nav_tag(context):
    """ Возвращает "строку навигации":
        список словарей: [{'id': .., 'title': .., 'type': ..}]
    """
    prefixes = {'Station': u'ст. ', 'Settlement': u'г. '}
    nav_objects = []
    pnode = context.get('current_node')
    node_class = pnode and pnode.__class__.__name__
    while node_class:
        nav_objects = [{'id': pnode.id,
                        'title': prefixes.get(node_class, '') + pnode.title,
                        'type': node_class.lower()}] + nav_objects
        if node_class == 'Station':
            pnode = pnode.settlement or pnode.region
        elif node_class == 'Settlement':
            pnode = pnode.region
        elif node_class == 'Region':
            pnode = pnode.country
        else:
            pnode = None
        node_class = pnode and pnode.__class__.__name__
    nav_objects = [{'id': None,
                    'title': u"Планета Земля",
                    'type': 'planet'}] + nav_objects
    context['nav_objects'] = nav_objects
    return context
