# coding: utf-8

from __future__ import absolute_import

from common.utils.text import transliterate


def items_tds(items, row_len=3, vertical=1):
    """ Возвращает список объектов в виде списка списков
        Вход: items - список некоторых объектов,
              row_len - по сколько объектов возвращать в каждом списке
              vertical - выводить вертикально или горизонтально: 1 or 0
        Выход: [[obj, .., obj], [obj, .., obj], .., [obj, .., ..]]
    """
    items_tds = []
    rows_count = len(items) / row_len + int(len(items) % row_len != 0)
    for index in range(rows_count):
        new_tds_row = []
        for td_index in range(row_len):
            try:
                if vertical:
                    new_tds_row.append(items[index + rows_count * td_index])
                else:
                    new_tds_row.append(items[row_len * index + td_index])
            except IndexError:
                new_tds_row.append({})
        items_tds.append(new_tds_row)
    return items_tds


def change_similar(s, dest='rus'):
    """ Заменяет латинские буквы на похожие по написанию русские """
    lat = u'CAEOPHKXTcxyoepak'
    rus = u'САЕОРНКХТсхуоерак'

    from_chars = lat
    to_charts = rus

    if dest != 'rus':
        from_chars, to_charts = rus, lat

    res = ''
    for c in s:
        pos = from_chars.find(c)
        if pos >= 0:
            res += to_charts[pos]
        else:
            res += c

    return res


def rus2translit(text):
    return transliterate(text, 'cyr-lat')
