# -*- coding: utf-8 -*-
from __future__ import absolute_import

import logging

from django.db import transaction

from common.models.geo import Settlement, Station
from common.utils.unicode_csv import UnicodeDictReader
from travel.rasp.admin.importinfo.related_log import save_log_for_first_arg_object

log = logging.getLogger(__name__)


@save_log_for_first_arg_object
def import_district(district, fileobj):
    try:
        try_import_district(district, fileobj)
        log.info(u"Импорт прошел успешно")
        success = True
    except Exception:
        log.exception(u"Ошибка при импортировании района, все изменения откатываются")
        success = False

    return success


@transaction.atomic
def try_import_district(district, fileobj):
    log.info(u"Импортируем %s", district)
    log.info(u"Чистим привязки")
    Station.objects.filter(district=district).update(district=None)
    Settlement.objects.filter(district=district).update(district=None)

    reader = UnicodeDictReader(fileobj, delimiter=";", strip_values=True)
    for rowdict in reader:
        station_id, settlement_id, title = rowdict['station_id'], rowdict['settlement_id'],\
            rowdict.get('title', u"")
        log.info(u"Обрабатываем запись %s %s %s", title, station_id, settlement_id)

        if station_id:
            station = Station.objects.get(id=int(station_id))
            station.district = district
            station.save()
            log.info(u"Добавили станцию %s в район", station.title)

        if settlement_id:
            settlement = Settlement.objects.get(id=int(settlement_id))
            settlement.district = district
            settlement.save()
            log.info(u"Добавили город %s в район", settlement.title)
