# coding: utf-8
from __future__ import unicode_literals

import six
from django.core.exceptions import ValidationError
from django.db import models
from django.db.models import Q

from common.models.schedule import Company


@six.python_2_unicode_compatible
class CompanyExtra(models.Model):
    allow_sirena_import = models.BooleanField(verbose_name='Разрешить импорт от Сирены',
                                              null=False, blank=True, default=False)
    company = models.OneToOneField(Company, related_name='extra')

    def __str__(self):
        return 'Настройки импорта для компании {}'.format(self.company)

    def clean(self):
        super(CompanyExtra, self).clean()
        if not self.allow_sirena_import:
            return

        other_companies = Company.objects.filter(extra__allow_sirena_import=True)
        if self.company.id:
            other_companies = other_companies.exclude(id=self.company.id)
        code_filter = Q(pk=None)  # always False
        if self.company.iata:
            code_filter |= Q(iata=self.company.iata)
        if self.company.sirena_id:
            code_filter |= Q(sirena_id=self.company.sirena_id)
        other_companies = other_companies.filter(code_filter)
        if other_companies.exists():
            raise ValidationError('Уже есть другие компании с такими же кодами, для которых '
                                  'разрешен импорт от Сирены. {}'.format(list(other_companies)))
